/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtColumnExpanded;
import com.sap.dictionary.designtime.DtStructureExpanded;
import com.sap.ide.metamodel.dictionary.datatype.DtDbView;
import com.sap.ide.metamodel.dictionary.datatype.DtImportFromOtherStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtInclusiveField;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtStructureElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class DtDbViewExpanded {
    protected String name = "";
    protected String prefix = "";
    protected String author = "";
    protected String creationDate = "";
    protected String language = "";
    protected String description = "";
    protected boolean isUpdatable = false;
    protected boolean isGrouped = false;
    protected DtDbView dtDbView = null;
    protected boolean expanded = true;
    protected HashMap gColumns = new HashMap();
    protected ArrayList gColumnsAsList = new ArrayList();
    protected TreeMap sortedFields = null;
    private String predefinedAction = "";
    private String deploymentStatus = "";
    private ArrayList gDatabaseInfo = new ArrayList();
    private ArrayList baseTableNames = new ArrayList();

    public DtDbViewExpanded(DtDbView dtDbView) {
        this.dtDbView = dtDbView;
        this.expand(dtDbView);
    }

    protected void expandHeader(DtDbView dtDbView) {
        this.name = dtDbView.getName();
        this.description = dtDbView.getDescription();
        this.isUpdatable = dtDbView.getIsUpdateable();
        this.isGrouped = dtDbView.getIsGrouped();
    }

    protected void expandColumns(DtDbView dtView) {
        DtStructureElement[] structureElements = dtView.getStructureElements();
        int pos = 1;
        int i = 0;
        while (i < structureElements.length) {
            if (structureElements[i] instanceof DtImportFromOtherStructure) {
                DtImportFromOtherStructure importFromOtherStructure = (DtImportFromOtherStructure)structureElements[i];
                DtStructure baseTable = importFromOtherStructure.getUsedStructure();
                if (!this.baseTableNames.contains(baseTable.getName())) {
                    this.baseTableNames.add(baseTable.getName());
                }
                HashMap tableColumns = new DtStructureExpanded(baseTable).getColumns();
                DtInclusiveField[] fields = importFromOtherStructure.getInclusiveFields();
                DtColumnExpanded nextColumn = null;
                int j = 0;
                while (j < fields.length) {
                    nextColumn = (DtColumnExpanded)tableColumns.get(fields[j].getName());
                    nextColumn.setPosition(pos);
                    nextColumn.setTabname(baseTable.getName());
                    ++pos;
                    this.gColumns.put(fields[j].getNewName(), nextColumn);
                    ++j;
                }
            }
            ++i;
        }
    }

    protected boolean expand(DtDbView dtDbView) {
        this.expandHeader(dtDbView);
        this.expandColumns(dtDbView);
        return this.expanded;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPredefinedAction() {
        return this.predefinedAction;
    }

    public String getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public HashMap getColumns() {
        return this.gColumns;
    }

    public ArrayList getBaseTableNames() {
        return this.baseTableNames;
    }

    public String getStatement() {
        return "";
    }

    public boolean isUpdatable() {
        return this.isUpdatable;
    }

    public boolean isGrouped() {
        return this.isGrouped;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public String toString() {
        Iterator iter = null;
        String s = null;
        s = "View: " + this.name + "\n" + "\n";
        iter = this.gColumns.keySet().iterator();
        while (iter.hasNext()) {
            s = s + (DtColumnExpanded)this.gColumns.get(iter.next());
        }
        return s;
    }
}

