/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.designtime.DtColumnExpanded;
import com.sap.dictionary.designtime.DtDbTableExpanded;
import com.sap.dictionary.designtime.DtHelper;
import com.sap.dictionary.designtime.DtIndexChecker;
import com.sap.dictionary.designtime.DtIndexColumnExpanded;
import com.sap.dictionary.designtime.DtIndexExpanded;
import com.sap.dictionary.designtime.DtStructureChecker;
import com.sap.dictionary.designtime.ErrTexts;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.sql.sqlparser.SQLKeywords;
import java.util.ArrayList;
import java.util.HashMap;

public class DtDbTableChecker
extends DtStructureChecker {
    public DtDbTableChecker() {
    }

    public DtDbTableChecker(DtStructure dbTable) {
        super(dbTable);
    }

    protected DtDbTableChecker(DtStructure dbTable, DtDbTableExpanded expDbTable) {
        super(dbTable, expDbTable);
    }

    public boolean nameIsOk() {
        HashMap<String, String> messages = new HashMap<String, String>();
        boolean structureNameIsOk = super.nameIsOk();
        int ch = 95;
        if (this.name.indexOf(ch) == -1) {
            messages.put(ErrTexts.get("106"), "Error");
        }
        if (this.name.length() > 18) {
            messages.put(DtHelper.concat(ErrTexts.get("110"), this.name), "Error");
        }
        if (!messages.isEmpty()) {
            this.mess.putAll(messages);
        }
        return messages.isEmpty() && structureNameIsOk;
    }

    public boolean nameIsOk(String tableName) {
        this.name = tableName;
        return this.nameIsOk();
    }

    public boolean reservedWordIsUsed() {
        if (SQLKeywords.isKeyword((String)this.name)) {
            this.mess.put(DtHelper.concat(ErrTexts.get("113"), this.name), "Error");
            return false;
        }
        return true;
    }

    public boolean primaryKeyIsOk() {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (this.expStructure == null) {
            this.expStructure = new DtDbTableExpanded(this.structure, false);
        }
        HashMap columns = this.expStructure.getColumns();
        ArrayList primaryKey = ((DtDbTableExpanded)this.expStructure).getPrimaryKey();
        if (primaryKey == null) {
            return true;
        }
        DtColumnExpanded column = null;
        int keyPosition = 0;
        int i = 0;
        while (i < primaryKey.size()) {
            if (!columns.containsKey(primaryKey.get(i))) {
                messages.put(DtHelper.concat(ErrTexts.get("101"), this.name), "Error");
            } else {
                column = (DtColumnExpanded)columns.get(primaryKey.get(i));
                keyPosition = i + 1;
                if (column.getPosition() != keyPosition) {
                    if (keyPosition == 1) {
                        messages.put(ErrTexts.get("103"), "Error");
                    } else {
                        messages.put(ErrTexts.get("102"), "Error");
                    }
                }
                if (column.getBuiltInType().equalsIgnoreCase("float")) {
                    messages.put(DtHelper.concat(ErrTexts.get("111"), "float"), "Error");
                }
            }
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean indexesAreOk() {
        HashMap messages = new HashMap();
        if (this.expStructure == null) {
            this.expStructure = new DtDbTableExpanded(this.structure, false);
        }
        ArrayList indexes = ((DtDbTableExpanded)this.expStructure).getIndexes();
        int i = 0;
        while (i < indexes.size()) {
            ((DtIndexExpanded)indexes.get(i)).indexIsOk(messages);
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean indexColumnNamesAreOk() {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (this.expStructure == null) {
            this.expStructure = new DtDbTableExpanded(this.structure, false);
        }
        HashMap columns = ((DtDbTableExpanded)this.expStructure).getColumns();
        ArrayList indexes = ((DtDbTableExpanded)this.expStructure).getIndexes();
        DtIndexExpanded expIndex = null;
        ArrayList indexColumns = null;
        String indexColumnName = null;
        int i = 0;
        while (i < indexes.size()) {
            expIndex = (DtIndexExpanded)indexes.get(i);
            indexColumns = expIndex.getColumns();
            int j = 0;
            while (j < indexColumns.size()) {
                indexColumnName = ((DtIndexColumnExpanded)indexColumns.get(j)).getName();
                if (!columns.containsKey(indexColumnName)) {
                    messages.put(DtHelper.concat(ErrTexts.get("303"), indexColumnName, expIndex.getName()), "Error");
                }
                ++j;
            }
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        this.mess.putAll(messages);
        return false;
    }

    public boolean indexesAreAllDifferent() {
        HashMap messages = new HashMap();
        DtIndexExpanded index = null;
        DtIndexChecker checker = null;
        if (this.expStructure == null) {
            this.expStructure = new DtDbTableExpanded(this.structure, false);
        }
        ArrayList indexes = ((DtDbTableExpanded)this.expStructure).getIndexes();
        int i = 0;
        while (i < indexes.size()) {
            index = (DtIndexExpanded)indexes.get(i);
            checker = new DtIndexChecker(index, messages);
            int j = i + 1;
            while (j < indexes.size()) {
                checker.indexesAreDifferent((DtIndexExpanded)indexes.get(j));
                ++j;
            }
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        if (messages.containsValue("Error")) {
            this.mess.putAll(messages);
            return false;
        }
        return true;
    }

    public boolean indexesAndPrimaryKeyAreDifferent() {
        HashMap messages = new HashMap();
        DtIndexChecker checker = null;
        DtIndexExpanded index = null;
        if (this.expStructure == null) {
            this.expStructure = new DtDbTableExpanded(this.structure, false);
        }
        ArrayList indexes = ((DtDbTableExpanded)this.expStructure).getIndexes();
        ArrayList gPrimaryKey = ((DtDbTableExpanded)this.expStructure).getPrimaryKey();
        if (gPrimaryKey == null) {
            return true;
        }
        int i = 0;
        while (i < indexes.size()) {
            index = (DtIndexExpanded)indexes.get(i);
            checker = new DtIndexChecker(index, messages);
            checker.indexAndPrimaryAreDifferent(gPrimaryKey);
            ++i;
        }
        if (messages.isEmpty()) {
            return true;
        }
        if (messages.containsValue("Error")) {
            this.mess.putAll(messages);
            return false;
        }
        return true;
    }

    public HashMap getMessages() {
        return this.mess;
    }

    protected void setMessage(String message, String severity) {
        this.mess.put(message, severity);
    }
}

