/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dictionary.designtime;

import com.sap.dictionary.database.dbs.JavaSqlTypeInfo;
import com.sap.dictionary.designtime.DtTypeInfoForDatabase;
import com.sap.ide.metamodel.dictionary.datatype.DatabaseEnum;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;

public class DdMapping {
    private static final HashMap jdbc_simple = new HashMap();
    private static final HashMap stringTypeNames = new HashMap();
    private static final HashMap binaryTypeNames = new HashMap();
    static final String[][] DDJDBC = new String[][]{{"short", "SMALLINT"}, {"integer", "INTEGER"}, {"decimal", "DECIMAL"}, {"long", "BIGINT"}, {"float", "REAL"}, {"double", "DOUBLE"}, {"binary", "BLOB"}, {"date", "DATE"}, {"time", "TIME"}, {"timestamp", "TIMESTAMP"}};
    private static final HashMap javaHints = new HashMap();
    private static final HashMap hints = new HashMap();
    private static final HashMap javaToDdic = new HashMap();
    private static final HashMap reverseHints = new HashMap();

    public static String getJavaSqlType(String ddType, int length) {
        if (!ddType.equalsIgnoreCase("string") && !ddType.equalsIgnoreCase("binary")) {
            return (String)jdbc_simple.get(ddType);
        }
        return "";
    }

    public static ArrayList getJdbcTypeInfo(String ddType, int length, DatabaseEnum[] databases) {
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        if (ddType.equalsIgnoreCase("boolean")) {
            list.add(new DtTypeInfoForDatabase("DEFAULT", "", ""));
            return list;
        }
        if (!ddType.equalsIgnoreCase("string") && !ddType.equalsIgnoreCase("binary")) {
            list.add(new DtTypeInfoForDatabase("DEFAULT", (String)jdbc_simple.get(ddType), ""));
            return list;
        }
        return DdMapping.getBestJdbcType(ddType, length, databases);
    }

    public static ArrayList getBestJdbcType(String ddType, int length, DatabaseEnum[] databases) {
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        boolean VAR = true;
        int LONG = 2;
        int LOB = 3;
        int defaultType = 1;
        int defaultTypePerDb = 1;
        HashMap typeNames = new HashMap();
        if (!ddType.equalsIgnoreCase("string") && !ddType.equalsIgnoreCase("binary")) {
            return null;
        }
        if (length == 0) {
            list = new ArrayList();
            if (ddType.equalsIgnoreCase("string")) {
                list.add(new DtTypeInfoForDatabase("DEFAULT", "CLOB", ""));
            }
            if (ddType.equalsIgnoreCase("binary")) {
                list.add(new DtTypeInfoForDatabase("DEFAULT", "BLOB", ""));
            }
            return list;
        }
        HashMap limitsForAllDbs = new HashMap();
        if (ddType.equalsIgnoreCase("string")) {
            limitsForAllDbs = JavaSqlTypeInfo.getStringLimits();
            defaultType = 1;
            typeNames = stringTypeNames;
        }
        if (ddType.equalsIgnoreCase("binary")) {
            limitsForAllDbs = JavaSqlTypeInfo.getBinaryLimits();
            defaultType = 1;
            typeNames = binaryTypeNames;
        }
        ArrayList limits = new ArrayList();
        String databaseName = null;
        int i = 0;
        while (i <= databases.length - 1) {
            databaseName = databases[i].toString().toUpperCase();
            limits = (ArrayList)limitsForAllDbs.get(databaseName);
            if (ddType.equalsIgnoreCase("string")) {
                defaultTypePerDb = 1;
            }
            if (ddType.equalsIgnoreCase("binary")) {
                defaultTypePerDb = 1;
            }
            int limit = 0;
            limit = (Integer)limits.get(0);
            if (length > limit & limit != 0) {
                ++defaultTypePerDb;
            }
            if (length > (limit = ((Integer)limits.get(2)).intValue()) & limit != 0 && defaultType == 1) {
                ++defaultType;
            }
            if (length > (limit = ((Integer)limits.get(1)).intValue()) & limit != 0) {
                if (defaultType == 2) {
                    ++defaultType;
                }
                ++defaultTypePerDb;
            } else if (limit == 0 && defaultTypePerDb == 2) {
                ++defaultTypePerDb;
            }
            if (defaultType == 3 || defaultTypePerDb == 3) {
                list = new ArrayList();
                if (defaultType == 3) {
                    list.add(new DtTypeInfoForDatabase("DEFAULT", (String)typeNames.get(new Integer(defaultType)), ""));
                    return list;
                }
                if (defaultTypePerDb == 3) {
                    list.add(new DtTypeInfoForDatabase("DEFAULT", (String)typeNames.get(new Integer(defaultTypePerDb)), ""));
                    return list;
                }
            }
            list.add(new DtTypeInfoForDatabase(databaseName, (String)typeNames.get(new Integer(defaultTypePerDb)), ""));
            ++i;
        }
        String defaultTypeName = (String)typeNames.get(new Integer(defaultType));
        list.add(new DtTypeInfoForDatabase("DEFAULT", defaultTypeName, ""));
        ListIterator iter = ((AbstractList)list).listIterator();
        DtTypeInfoForDatabase typeInfoForDatabase = null;
        while (iter.hasNext()) {
            typeInfoForDatabase = (DtTypeInfoForDatabase)iter.next();
            if (!typeInfoForDatabase.getJavaSqlTypeName().equalsIgnoreCase(defaultTypeName) || typeInfoForDatabase.getDatabaseName().equalsIgnoreCase("DEFAULT")) continue;
            iter.remove();
        }
        if (list.size() == 1 && (typeInfoForDatabase = (DtTypeInfoForDatabase)list.get(0)).getJavaSqlTypeName().equalsIgnoreCase("VARBINARY")) {
            typeInfoForDatabase.setJavaSqlTypeName("BINARY");
        }
        return list;
    }

    public ArrayList checkJdbcTypesExtended(ArrayList jdbcTypesList) {
        ArrayList<DtTypeInfoForDatabase> list = new ArrayList<DtTypeInfoForDatabase>();
        ListIterator iter = ((AbstractList)jdbcTypesList).listIterator();
        DtTypeInfoForDatabase typeInfoForDatabase = null;
        while (iter.hasNext()) {
            typeInfoForDatabase = (DtTypeInfoForDatabase)iter.next();
            if (typeInfoForDatabase.getJavaSqlTypeName().equalsIgnoreCase("CLOB")) {
                list.add(new DtTypeInfoForDatabase("DEFAULT", "CLOB", ""));
                return list;
            }
            if (!typeInfoForDatabase.getJavaSqlTypeName().equalsIgnoreCase("BLOB")) continue;
            list.add(new DtTypeInfoForDatabase("DEFAULT", "BLOB", ""));
            return list;
        }
        return jdbcTypesList;
    }

    public static ArrayList getAllowedJdbcTypes(String jdbcTypeForDb, DatabaseEnum database) {
        ArrayList<String> list = new ArrayList<String>();
        if (jdbcTypeForDb.equalsIgnoreCase("VARCHAR")) {
            list.add("VARCHAR");
            if (database.toString().toUpperCase().equalsIgnoreCase("INFORMIX")) {
                list.add("LONGVARCHAR");
            }
            list.add("CLOB");
        }
        if (jdbcTypeForDb.equalsIgnoreCase("LONGVARCHAR")) {
            if (database.toString().toUpperCase().equalsIgnoreCase("INFORMIX")) {
                list.add("LONGVARCHAR");
            }
            list.add("CLOB");
        }
        if (jdbcTypeForDb.equalsIgnoreCase("CLOB")) {
            list.add("CLOB");
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    protected static HashMap getHints(String softwareLanguage) {
        return (HashMap)hints.get("java");
    }

    public static Set getJavaTypeFromDdicType(String ddType) {
        return (Set)((HashMap)hints.get("java")).get(ddType);
    }

    public static String getDdicTypeFromJavaType(String javaType) {
        return (String)((HashMap)reverseHints.get("java")).get(javaType);
    }

    public static String getTypeUsingDescription(String javaSqlTypeName) {
        if (javaSqlTypeName.equalsIgnoreCase("LONGVARCHAR")) {
            return "A field with type " + javaSqlTypeName + " can not be used in where-conditions or indexes" + "\n" + "This is possible for strings with length <= 1000";
        }
        if (javaSqlTypeName.equalsIgnoreCase("LONGVARBINARY")) {
            return "A field with type " + javaSqlTypeName + " can not be used in where-conditions or indexes" + "\n" + "This is possible for binary-streams with length <= 255";
        }
        if (javaSqlTypeName.equalsIgnoreCase("CLOB")) {
            return "A long object field with type " + javaSqlTypeName + " can not be used in WHERE conditions or indexes" + "\n" + "This would be possible for strings of length <= 1000";
        }
        if (javaSqlTypeName.equalsIgnoreCase("BLOB")) {
            return "A long object field with type " + javaSqlTypeName + "\n" + "can not be used in WHERE conditions or indexes" + "\n" + "This would be possible for binary-streams of length <= 255";
        }
        return "";
    }

    static {
        int i = 0;
        while (i < DDJDBC.length) {
            jdbc_simple.put(DDJDBC[i][0], DDJDBC[i][1]);
            ++i;
        }
        stringTypeNames.put(new Integer(1), "VARCHAR");
        stringTypeNames.put(new Integer(2), "LONGVARCHAR");
        stringTypeNames.put(new Integer(3), "CLOB");
        binaryTypeNames.put(new Integer(1), "VARBINARY");
        binaryTypeNames.put(new Integer(2), "LONGVARBINARY");
        binaryTypeNames.put(new Integer(3), "BLOB");
        javaHints.put("string", new HashSet<String>(Arrays.asList("java.lang.String")));
        javaHints.put("boolean", new HashSet<String>(Arrays.asList("boolean", "java.lang.Boolean")));
        javaHints.put("short", new HashSet<String>(Arrays.asList("short", "java.lang.Short")));
        javaHints.put("integer", new HashSet<String>(Arrays.asList("int", "java.lang.Integer")));
        javaHints.put("long", new HashSet<String>(Arrays.asList("long", "java.lang.Long")));
        javaHints.put("decimal", new HashSet<String>(Arrays.asList("java.math.BigDecimal")));
        javaHints.put("float", new HashSet<String>(Arrays.asList("float", "java.lang.Float")));
        javaHints.put("double", new HashSet<String>(Arrays.asList("double", "java.lang.Double")));
        javaHints.put("binary", new HashSet<String>(Arrays.asList("byte[]")));
        javaHints.put("date", new HashSet<String>(Arrays.asList("java.sql.Date")));
        javaHints.put("time", new HashSet<String>(Arrays.asList("java.sql.Time")));
        javaHints.put("timestamp", new HashSet<String>(Arrays.asList("java.sql.Timestamp")));
        hints.put("java", javaHints);
        javaToDdic.put("java.lang.String", "string");
        javaToDdic.put("boolean", "boolean");
        javaToDdic.put("java.lang.Boolean", "boolean");
        javaToDdic.put("short", "short");
        javaToDdic.put("java.lang.Short", "short");
        javaToDdic.put("int", "integer");
        javaToDdic.put("java.lang.Integer", "integer");
        javaToDdic.put("long", "long");
        javaToDdic.put("java.lang.Long", "long");
        javaToDdic.put("java.math.BigDecimal", "decimal");
        javaToDdic.put("float", "float");
        javaToDdic.put("java.lang.Float", "float");
        javaToDdic.put("double", "double");
        javaToDdic.put("java.lang.Double", "double");
        javaToDdic.put("byte[]", "binary");
        javaToDdic.put("java.sql.Date", "date");
        javaToDdic.put("java.sql.Time", "time");
        javaToDdic.put("java.sql.Timestamp", "timestamp");
        reverseHints.put("java", javaToDdic);
    }
}

