/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.statistic;

import com.sap.tc.webdynpro.admin.statistic.Sample;

public class SampleBuffer {
    private int freePos;
    private int basePos;
    private int current;
    private Sample[] samples;

    public SampleBuffer(int size) {
        this.samples = new Sample[size];
        int i = 0;
        while (i < this.samples.length) {
            this.samples[i] = new Sample();
            ++i;
        }
        this.basePos = 0;
        this.current = 0;
        this.freePos = 0;
    }

    public synchronized boolean add(long value, long timeStamp, long id) {
        if (this.current < this.samples.length) {
            this.samples[this.freePos].value = value;
            this.samples[this.freePos].timeStamp = timeStamp;
            this.samples[this.freePos].id = id;
            this.freePos = this.next(this.freePos);
            ++this.current;
            return true;
        }
        return false;
    }

    public boolean add(long value, long timeStamp) {
        return this.add(value, timeStamp, 0L);
    }

    public boolean add(long value) {
        return this.add(value, 0L, 0L);
    }

    private synchronized long[] retrieveValues(int num, boolean remove) {
        int pos = this.basePos;
        int n = num >= this.current ? this.current : num;
        long[] res = new long[n];
        int i = 0;
        while (i < res.length) {
            res[i] = this.samples[pos].value;
            pos = this.next(pos);
            ++i;
        }
        if (remove) {
            this.basePos = pos;
            this.current -= res.length;
        }
        return res;
    }

    public long[] removeValues(int num) {
        return this.retrieveValues(num, true);
    }

    public long[] removeAllValues() {
        return this.removeValues(this.getCurrentSize());
    }

    public long[] getAllValues() {
        return this.getValues(this.getCurrentSize());
    }

    public long[] getValues(int num) {
        return this.retrieveValues(num, false);
    }

    private synchronized Sample[] retrieveSamples(int num, boolean remove) {
        int pos = this.basePos;
        int n = num >= this.current ? this.current : num;
        Sample[] res = new Sample[n];
        int i = 0;
        while (i < res.length) {
            res[i] = new Sample(this.samples[pos]);
            pos = this.next(pos);
            ++i;
        }
        if (remove) {
            this.basePos = pos;
            this.current -= res.length;
        }
        return res;
    }

    public Sample[] removeSamples(int num) {
        return this.retrieveSamples(num, true);
    }

    public Sample[] removeAllSamples() {
        return this.removeSamples(this.getCurrentSize());
    }

    public Sample[] getAllSamples() {
        return this.getSamples(this.getCurrentSize());
    }

    public Sample[] getSamples(int num) {
        return this.retrieveSamples(num, false);
    }

    public int getMaxSize() {
        return this.samples.length;
    }

    public int getCurrentSize() {
        return this.current;
    }

    private int next(int pos) {
        return ++pos % this.samples.length;
    }
}

