/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.mbeans.performance;

import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.admin.mbeans.MBeanServerProxy;
import com.sap.tc.webdynpro.admin.mbeans.performance.ClientPerformance;
import com.sap.tc.webdynpro.admin.mbeans.performance.ClientPerformanceMBean;
import com.sap.tc.webdynpro.admin.mbeans.performance.PerformanceAgentMBean;
import com.sap.tc.webdynpro.admin.statistic.Stats;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class PerformanceAgent
implements PerformanceAgentMBean,
MBeanRegistration,
NotificationListener,
NotificationFilter {
    private List clientList;
    private MBeanServer server;
    private ObjectName myName;
    private boolean measurementRunning = false;
    private Date startDate;
    private Date endDate;
    private boolean listenerAdded = false;
    private ObjectName MBEAN_SERVER_DELEGATE;
    private static Location logger = Location.getLocation((String)(class$com$sap$tc$webdynpro$admin$mbeans$performance$PerformanceAgent == null ? (class$com$sap$tc$webdynpro$admin$mbeans$performance$PerformanceAgent = PerformanceAgent.class$("com.sap.tc.webdynpro.admin.mbeans.performance.PerformanceAgent")) : class$com$sap$tc$webdynpro$admin$mbeans$performance$PerformanceAgent).getName());
    static /* synthetic */ Class class$com$sap$tc$webdynpro$admin$mbeans$performance$ClientPerformanceMBean;
    static /* synthetic */ Class class$com$sap$tc$webdynpro$admin$mbeans$performance$PerformanceAgent;

    public PerformanceAgent() {
        try {
            this.MBEAN_SERVER_DELEGATE = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.clientList = Collections.synchronizedList(new LinkedList());
    }

    public boolean isMeasurementRunning() {
        return this.measurementRunning;
    }

    public synchronized void startMeasurement() {
        if (!this.measurementRunning) {
            this.startDate = new Date();
            this.addNotificationListener();
            this.measurementRunning = true;
        }
    }

    public synchronized void stopMeasurement() {
        if (this.measurementRunning) {
            this.endDate = new Date();
            this.measurementRunning = false;
            this.removeNotificationListener();
        }
    }

    public Date[] getMeasurementTimeIntervall() {
        Date[] intervall = this.startDate == null ? new Date[]{} : (this.endDate == null ? new Date[]{this.startDate} : new Date[]{this.startDate, this.endDate});
        return intervall;
    }

    public synchronized void resetMeasurement() {
        if (this.measurementRunning) {
            this.stopMeasurement();
        }
        this.clearClientList();
        this.startDate = null;
        this.endDate = null;
    }

    public ObjectName[] getClientPerformanceMBeans() {
        return this.clientList.toArray(new ObjectName[0]);
    }

    public Stats getClientPerformanceStats() {
        Stats[] s = new Stats[this.clientList.size()];
        int i = 0;
        MBeanServer server = MBeanServerProxy.getServer();
        Iterator it = this.clientList.iterator();
        while (it.hasNext()) {
            ClientPerformanceMBean proxy = (ClientPerformanceMBean)MBeanServerInvocationHandler.newProxyInstance(server, (ObjectName)it.next(), class$com$sap$tc$webdynpro$admin$mbeans$performance$ClientPerformanceMBean == null ? PerformanceAgent.class$("com.sap.tc.webdynpro.admin.mbeans.performance.ClientPerformanceMBean") : class$com$sap$tc$webdynpro$admin$mbeans$performance$ClientPerformanceMBean, false);
            s[i] = proxy.getStats();
            ++i;
        }
        return Stats.aggregate(s);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.server = server;
        this.myName = name;
        return this.myName;
    }

    public void postRegister(Boolean registrationDone) {
        if (registrationDone.booleanValue()) {
            // empty if block
        }
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notification;
            String type = notif.getType();
            if (type.equals("JMX.mbean.registered")) {
                this.clientList.add(notif.getMBeanName());
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.clientList.remove(notif.getMBeanName());
            }
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName name = ((MBeanServerNotification)notification).getMBeanName();
            return ClientPerformance.isValidName(name);
        }
        return false;
    }

    private void addNotificationListener() {
        try {
            if (!this.listenerAdded) {
                this.server.addNotificationListener(this.MBEAN_SERVER_DELEGATE, this, (NotificationFilter)this, null);
                this.listenerAdded = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void removeNotificationListener() {
        try {
            if (this.listenerAdded) {
                this.server.removeNotificationListener(this.MBEAN_SERVER_DELEGATE, this);
                this.listenerAdded = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearClientList() {
        Iterator it = this.clientList.iterator();
        while (it.hasNext()) {
            MBeanServerProxy.unregisterMBean((ObjectName)it.next());
        }
        this.clientList.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.webdynpro").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_admin/java/com/sap/tc/webdynpro/admin/mbeans/performance/PerformanceAgent.java#2 $");
    }
}

