/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.mbeans.client;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.admin.mbeans.MBeanServerProxy;
import com.sap.tc.webdynpro.admin.mbeans.client.ClientPerformance;
import com.sap.tc.webdynpro.admin.mbeans.client.ClientPerformanceMBean;
import com.sap.tc.webdynpro.admin.mbeans.client.PerformanceAgentMBean;
import com.sap.tc.webdynpro.admin.statistic.Stats;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class PerformanceAgent
implements PerformanceAgentMBean,
MBeanRegistration,
NotificationListener,
NotificationFilter {
    private List clientList;
    private MBeanServer server;
    private ObjectName myName;
    private boolean measurementRunning = false;
    private Date startDate;
    private Date endDate;
    private boolean listenerAdded = false;
    private ObjectName MBEAN_SERVER_DELEGATE;
    private static Location logger = Location.getLocation((String)(class$com$sap$tc$webdynpro$admin$mbeans$client$PerformanceAgent == null ? (class$com$sap$tc$webdynpro$admin$mbeans$client$PerformanceAgent = PerformanceAgent.class$("com.sap.tc.webdynpro.admin.mbeans.client.PerformanceAgent")) : class$com$sap$tc$webdynpro$admin$mbeans$client$PerformanceAgent).getName());
    static /* synthetic */ Class class$com$sap$tc$webdynpro$admin$mbeans$client$ClientPerformanceMBean;
    static /* synthetic */ Class class$com$sap$tc$webdynpro$admin$mbeans$client$PerformanceAgent;

    public PerformanceAgent() {
        try {
            this.MBEAN_SERVER_DELEGATE = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception ex) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to create object name for Performance Agent MBean. Web Dynpro Client performance measurement will not work.", (Throwable)ex);
            logger.errorT("Failed to create object name for server delegate");
        }
        this.clientList = Collections.synchronizedList(new LinkedList());
    }

    public boolean isMeasurementRunning() {
        return this.measurementRunning;
    }

    public void startMeasurement() {
        if (!this.measurementRunning) {
            this.startDate = new Date();
            this.addNotificationListener();
            this.measurementRunning = true;
        }
    }

    public void stopMeasurement() {
        if (this.measurementRunning) {
            this.endDate = new Date();
            this.measurementRunning = false;
            this.removeNotificationListener();
        }
    }

    public Date[] getMeasurementTimeIntervall() {
        Date[] intervall = this.startDate == null ? new Date[]{} : (this.endDate == null ? new Date[]{this.startDate} : new Date[]{this.startDate, this.endDate});
        return intervall;
    }

    public void resetMeasurement() {
        if (this.measurementRunning) {
            this.stopMeasurement();
        }
        this.clearClientList();
        this.startDate = null;
        this.endDate = null;
    }

    public ObjectName[] getClientPerformanceMBeans() {
        return this.clientList.toArray(new ObjectName[0]);
    }

    public String[] getClientTypes() {
        List proxies = this.getClientProxies();
        HashSet<String> types = new HashSet<String>();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            ClientPerformanceMBean mbean = (ClientPerformanceMBean)iter.next();
            types.add(mbean.getClientType());
        }
        return types.toArray(new String[0]);
    }

    public int getNumberOfClients(String clientType) {
        int n = 0;
        List proxies = this.getClientProxies();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            ClientPerformanceMBean mbean = (ClientPerformanceMBean)iter.next();
            if (!mbean.getClientType().equals(clientType)) continue;
            ++n;
        }
        return n;
    }

    public Stats getClientPerformanceStats(String clientType) {
        List proxies = this.getClientProxies();
        ArrayList<Stats> stats = new ArrayList<Stats>();
        Iterator iter = proxies.iterator();
        while (iter.hasNext()) {
            ClientPerformanceMBean mbean = (ClientPerformanceMBean)iter.next();
            if (!mbean.getClientType().equals(clientType)) continue;
            stats.add(mbean.getStats());
        }
        return Stats.aggregate(stats.toArray(new Stats[0]));
    }

    public void postDeregister() {
    }

    public void postRegister(Boolean arg0) {
    }

    public void preDeregister() throws Exception {
    }

    public ObjectName preRegister(MBeanServer aServer, ObjectName aName) throws Exception {
        this.server = aServer;
        this.myName = aName;
        return this.myName;
    }

    public void handleNotification(Notification notification, Object handback) {
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification notif = (MBeanServerNotification)notification;
            String type = notif.getType();
            if (type.equals("JMX.mbean.registered")) {
                this.clientList.add(notif.getMBeanName());
            } else if (type.equals("JMX.mbean.unregistered")) {
                this.clientList.remove(notif.getMBeanName());
            }
        }
    }

    public boolean isNotificationEnabled(Notification notification) {
        if (notification instanceof MBeanServerNotification) {
            ObjectName name = ((MBeanServerNotification)notification).getMBeanName();
            return ClientPerformance.isValidName(name);
        }
        return false;
    }

    private void addNotificationListener() {
        try {
            if (!this.listenerAdded) {
                this.server.addNotificationListener(this.MBEAN_SERVER_DELEGATE, this, (NotificationFilter)this, null);
                this.listenerAdded = true;
            }
        }
        catch (Exception ex) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to register Performance Agent MBean as notification listener. Web Dynpro Client performance measurement will not work.", (Throwable)ex);
        }
    }

    private void removeNotificationListener() {
        try {
            if (this.listenerAdded) {
                this.server.removeNotificationListener(this.MBEAN_SERVER_DELEGATE, this);
                this.listenerAdded = false;
            }
        }
        catch (Exception ex) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to deregister Performance Agent MBean as notification listener. Web Dynpro Client performance measurement will not work.", (Throwable)ex);
        }
    }

    private void clearClientList() {
        Iterator it = this.clientList.iterator();
        while (it.hasNext()) {
            MBeanServerProxy.unregisterMBean((ObjectName)it.next());
        }
        this.clientList.clear();
    }

    private List getClientProxies() {
        ArrayList<ClientPerformanceMBean> proxies = new ArrayList<ClientPerformanceMBean>();
        MBeanServer server = MBeanServerProxy.getServer();
        Iterator it = this.clientList.iterator();
        while (it.hasNext()) {
            ClientPerformanceMBean proxy = (ClientPerformanceMBean)MBeanServerInvocationHandler.newProxyInstance(server, (ObjectName)it.next(), class$com$sap$tc$webdynpro$admin$mbeans$client$ClientPerformanceMBean == null ? PerformanceAgent.class$("com.sap.tc.webdynpro.admin.mbeans.client.ClientPerformanceMBean") : class$com$sap$tc$webdynpro$admin$mbeans$client$ClientPerformanceMBean, false);
            proxies.add(proxy);
        }
        return proxies;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Location.getLocation((String)"ID.com.sap.tc.webdynpro").infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_admin/java/com/sap/tc/webdynpro/admin/mbeans/client/PerformanceAgent.java#1 $");
    }
}

