/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.webdynpro.admin.mbeans;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.webdynpro.services.sal.admin.core.MBeanServiceInternal;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MBeanServerProxy {
    private static MBeanServer server = null;
    private static Location logger = Location.getLocation((Class)(class$com$sap$tc$webdynpro$admin$mbeans$MBeanServerProxy == null ? (class$com$sap$tc$webdynpro$admin$mbeans$MBeanServerProxy = MBeanServerProxy.class$("com.sap.tc.webdynpro.admin.mbeans.MBeanServerProxy")) : class$com$sap$tc$webdynpro$admin$mbeans$MBeanServerProxy));
    private static final String CATEGORY = "type";
    private static final String ID = "name";
    private static final String CATPREFIX = "Webdynpro";
    static /* synthetic */ Class class$com$sap$tc$webdynpro$admin$mbeans$MBeanServerProxy;

    public MBeanServerProxy() {
        logger.infoT("$Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_admin/java/com/sap/tc/webdynpro/admin/mbeans/MBeanServerProxy.java#2 $");
    }

    public static ObjectName getObjectName(String category, String name) {
        ObjectName obj = null;
        try {
            StringBuffer s = new StringBuffer(30);
            s.append(':');
            s.append(CATEGORY);
            s.append('=');
            s.append(CATPREFIX);
            s.append(category);
            s.append(',');
            s.append(ID);
            s.append('=');
            s.append(name);
            obj = new ObjectName(s.toString());
        }
        catch (Exception ex) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to create a MBean object name", (Throwable)ex);
        }
        return obj;
    }

    public static boolean hasCategory(ObjectName name, String category) {
        String value = name.getKeyProperty(CATEGORY);
        return value.endsWith(category);
    }

    public static ObjectInstance registerMBean(Object obj, ObjectName objName, boolean force) {
        if (logger.beLogged(100)) {
            logger.debugT("registerMBean", obj == null ? "null" : objName.toString());
        }
        if (obj == null) {
            Category.SYS_USER_INTERFACE.errorT(logger, "Failed to register a MBean.");
            logger.debugT("registerMBean failed: parameter mbean == null");
            return null;
        }
        if (objName == null) {
            Category.SYS_USER_INTERFACE.errorT(logger, "Failed to register a MBean.");
            logger.debugT("registerMBean failed: parameter objectName == null");
            return null;
        }
        if (MBeanServerProxy.getServer() == null) {
            Category.SYS_USER_INTERFACE.errorT(logger, "Failed to register a MBean.");
            logger.debugT("registerMBean failed: server == null");
            return null;
        }
        return MBeanServiceInternal.registerMBean((Object)obj, (ObjectName)objName);
    }

    public static ObjectInstance registerMBean(Object obj, ObjectName objName) {
        return MBeanServerProxy.registerMBean(obj, objName, true);
    }

    public static ObjectInstance registerMBean(Object obj, String category, String name) {
        ObjectName objName = MBeanServerProxy.getObjectName(category, name);
        return MBeanServerProxy.registerMBean(obj, objName);
    }

    public static ObjectInstance registerMBean(Object mBeanImplementation, Class mBeanInterfaceClass, ObjectName objName) {
        try {
            StandardMBean mBean = new StandardMBean(mBeanImplementation, mBeanInterfaceClass);
            return MBeanServerProxy.registerMBean(mBean, objName);
        }
        catch (NotCompliantMBeanException e) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to register a Standard MBean.", (Throwable)e);
            return null;
        }
    }

    public static void unregisterMBean(ObjectName name) {
        MBeanServiceInternal.unregisterMBean((ObjectName)name);
    }

    public static MBeanServer getServer() {
        if (server != null) {
            return server;
        }
        try {
            InitialContext initialContext = new InitialContext();
            server = (MBeanServer)initialContext.lookup("jmx");
        }
        catch (NamingException e) {
            Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to lookup MBean server of J2EE Engine. A local MBean server will be created instead.", (Throwable)e);
        }
        if (server == null) {
            try {
                server = MBeanServerFactory.createMBeanServer();
            }
            catch (Exception ex) {
                Category.SYS_USER_INTERFACE.logThrowableT(500, logger, "Failed to create a local MBean server.", (Throwable)ex);
            }
        }
        return server;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

