/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import java.util.Arrays;
import java.util.Comparator;
import org.xml.sax.Attributes;

final class AttributeSorter
implements Comparator {
    private int capacity;
    private Attributes attributes = null;
    private Integer[] ordinals;
    private Integer[] permutation;
    private String[] sortKeys = null;

    AttributeSorter(int initialCapacity) {
        this.ordinals = new Integer[initialCapacity];
        this.permutation = new Integer[initialCapacity];
        int i = 0;
        while (i < initialCapacity) {
            this.ordinals[i] = new Integer(i);
            ++i;
        }
        this.sortKeys = new String[initialCapacity];
        this.capacity = initialCapacity;
    }

    private void ensureCapacity(int n) {
        if (n > this.capacity) {
            Integer[] oldOrdinals = this.ordinals;
            this.ordinals = new Integer[n];
            this.permutation = new Integer[n];
            this.sortKeys = new String[n];
            System.arraycopy(oldOrdinals, 0, this.ordinals, 0, this.capacity);
            int i = this.capacity;
            while (i < n) {
                this.ordinals[i] = new Integer(i);
                ++i;
            }
            this.capacity = n;
        }
    }

    void process(Attributes attributes, boolean performSort, boolean useLocalNamesAsKeys) {
        this.attributes = attributes;
        int n = attributes.getLength();
        this.ensureCapacity(n);
        System.arraycopy(this.ordinals, 0, this.permutation, 0, n);
        if (performSort) {
            if (useLocalNamesAsKeys) {
                int i = 0;
                while (i < n) {
                    String k = attributes.getLocalName(i);
                    this.sortKeys[i] = k == null || k.equals("") ? attributes.getQName(i) : k;
                    ++i;
                }
            } else {
                int i = 0;
                while (i < n) {
                    this.sortKeys[i] = attributes.getQName(i);
                    ++i;
                }
            }
            Arrays.sort(this.permutation, 0, n, this);
        }
    }

    String getURI(int index) {
        return this.attributes.getURI(this.permutation[index]);
    }

    String getLocalName(int index) {
        return this.attributes.getLocalName(this.permutation[index]);
    }

    String getQName(int index) {
        return this.attributes.getQName(this.permutation[index]);
    }

    String getValue(int index) {
        return this.attributes.getValue(this.permutation[index]);
    }

    public int compare(Object a, Object b) {
        int ia = (Integer)a;
        int ib = (Integer)b;
        String sa = this.sortKeys[ia];
        String sb = this.sortKeys[ib];
        return sa.compareTo(sb);
    }

    public boolean equals(Object object) {
        return object == this;
    }
}

