/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XSLText
extends XSLNode {
    private boolean disableOutputEscaping = false;
    private CharArray data = null;
    public static final String[] REQPAR = new String[0];
    public static final String[] OPTPAR = new String[]{"disable-output-escaping"};

    public XSLText(XSLStylesheet owner, XSLNode parent, String data, boolean disesc) throws XSLException {
        super(owner, parent);
        this.data = new CharArray(data);
        this.disableOutputEscaping = disesc;
    }

    public XSLText(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLText(XSLStylesheet owner, XSLNode parent, String data) throws XSLException {
        super(owner, parent);
        this.data = new CharArray(data);
    }

    public XSLText(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent);
        this.data = new CharArray("");
        if (el.getAttribute("disable-output-escaping") != null) {
            this.disableOutputEscaping = el.getAttribute("disable-output-escaping").equals("yes");
        }
        NodeList nl = el.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            short type = nl.item(i).getNodeType();
            if (type == 3 || type == 4) {
                this.data.append(((Text)nl.item(i)).getData());
            }
            ++i;
        }
        if (this.data.length() > 0 && (Symbols.isWhitespace(this.data.charAt(0)) || Symbols.isWhitespace(this.data.charAt(this.data.length() - 1)))) {
            owner.setIsIndentAllowed(false);
        }
    }

    public void init(Element el) throws XSLException {
        if (el.getAttribute("disable-output-escaping") != null) {
            this.disableOutputEscaping = el.getAttribute("disable-output-escaping").equals("yes");
        }
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.owner.getOutputProcessor().characters(this.data, this.disableOutputEscaping);
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLText: data = '" + this.data + "'");
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

