/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.AttributeValueTemplateHandler;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import org.w3c.dom.Element;

public final class XSLAttribute
extends XSLContentNode {
    private CharArray name = new CharArray();
    private CharArray namespace = new CharArray();
    private CharArray value = new CharArray(20);
    private CharArray instName = new CharArray();
    private boolean processed = false;
    private boolean bInsideValue = false;
    private boolean bProcessByElement = false;
    private QName instQName = new QName();
    private AttributeValueTemplateHandler nameTemplate = new AttributeValueTemplateHandler();
    private AttributeValueTemplateHandler valueTemplate = new AttributeValueTemplateHandler();
    private AttributeValueTemplateHandler namespaceTemplate = new AttributeValueTemplateHandler();
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[]{"namespace"};

    public XSLAttribute(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLAttribute(XSLStylesheet owner, XSLNode parent, Element el) throws XSLException {
        super(owner, parent, el);
        if (this.name == null) {
            this.name = new CharArray();
        }
        this.name.set(el.getNodeName());
        this.name.trim();
        this.namespace.set(el.getNamespaceURI());
        this.namespace.trim();
        if (el.getNamespaceURI() != null && el.getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") && el.getLocalName() != null && el.getLocalName().equals("attribute")) {
            this.name.set(el.getAttribute("name"));
            this.name.trim();
            if (el.getAttribute("namespace").length() > 0) {
                this.namespace.set(el.getAttribute("namespace"));
                this.namespace.trim();
            } else {
                this.namespace.clear();
            }
            this.nameTemplate.init(this.name, owner.etBuilder);
            this.namespaceTemplate.init(this.namespace, owner.etBuilder);
            if (this.nameTemplate.countTokens() == 1 && this.name.indexOf(':') > -1) {
                String sname = this.name.toString();
                String prf = sname.substring(0, sname.indexOf(58));
                if (this.namespaceTemplate.countTokens() == 0) {
                    this.namespaceTemplate.init(owner.getNamespaceHandler().get(new CharArray(prf)), owner.etBuilder);
                }
            }
        }
        this.instName.set(this.name);
    }

    public XSLAttribute(XSLStylesheet owner, XSLNode parent, Object uri, Object name, String value) throws XSLException {
        super(owner, parent, null);
        if (this.name == null) {
            this.name = new CharArray();
        }
        if (this.namespace == null) {
            this.namespace = new CharArray();
        }
        if (name instanceof CharArray) {
            this.name.set((CharArray)name);
        } else if (name instanceof String) {
            this.name.set((String)name);
        } else {
            throw new IllegalArgumentException("name must be either CharArray or String");
        }
        if (uri instanceof CharArray) {
            this.namespace.set((CharArray)uri);
        } else if (uri instanceof String) {
            this.namespace.set((String)uri);
        } else if (uri == null) {
            this.namespace.clear();
        } else {
            throw new IllegalArgumentException("uri must be either CharArray or String");
        }
        this.nameTemplate.init(this.name, owner.etBuilder);
        this.namespaceTemplate.init(this.namespace, owner.etBuilder);
        this.instName.set(this.name);
        this.bInsideValue = true;
        this.valueTemplate.init(new CharArray(value), owner.etBuilder);
    }

    public CharArray getName() {
        return this.instName;
    }

    public QName getQName() {
        return this.instQName;
    }

    public CharArray getValue() throws XSLException {
        return this.value;
    }

    public CharArray getNamespaceURI() {
        return this.namespace;
    }

    public void setProcessByElement() {
        this.bProcessByElement = true;
    }

    public void clearProcessByElement() {
        this.bProcessByElement = false;
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.nameTemplate.processTo(this.instName, this.owner.getXPathProcessor(), xcont, this.varContext);
        this.namespaceTemplate.processTo(this.namespace, this.owner.getXPathProcessor(), xcont, this.varContext);
        this.instQName.reuse(this.instName);
        this.instQName.uri = this.namespace;
        if (!this.bInsideValue) {
            this.value.clear();
            this.owner.getOutputProcessor().startAttributeValueProcessing(this.value);
            this.owner.getOutputProcessor().setDisableOutputEscaping(true);
            this.processFromFirst(xcont, node);
            this.owner.getOutputProcessor().setDisableOutputEscaping(false);
            this.owner.getOutputProcessor().stopAttributeValueProcessing();
        } else {
            this.owner.getOutputProcessor().setDisableOutputEscaping(true);
            this.valueTemplate.processTo(this.value, this.owner.getXPathProcessor(), xcont, this.varContext);
            this.owner.getOutputProcessor().setDisableOutputEscaping(false);
        }
        if (!this.bProcessByElement) {
            this.owner.getOutputProcessor().addAttribute(this.namespace, this.instQName.getPrefix(), this.instName, this.instQName.getlocalname(), this.value);
        } else {
            this.setProcessNext(false);
        }
        this.processed = true;
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLAttribute: name = " + this.name);
        if (this.getFirst() != null) {
            this.getFirst().print(ind + "  ");
        }
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

