/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.xobjects;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.jaxp.TransformerFactoryImpl;
import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XJavaObject
extends XObject
implements ETItem {
    public static final int TYPE = 6;
    private XPathContext context = null;
    private Object object = null;
    private XNodeSet set = null;
    private DTM dtm = null;

    protected XJavaObject reuse(Object o) {
        this.object = o;
        this.dtm = null;
        return this;
    }

    public Object getObject() {
        return this.object;
    }

    public XObject evaluate(XPathContext x) throws XPathException {
        return this;
    }

    public boolean match(XPathContext x) throws XPathException {
        throw new XPathException("Objects of type XJavaObject cannot be matched agains a XPathContext");
    }

    public boolean isNodeOrNodeList() {
        return this.object instanceof NodeList || this.object instanceof Node;
    }

    public XNodeSet toXNodeSet() throws XPathException {
        if (this.context == null) {
            throw new XPathException("Cannot get a nodeset from a java object without context.");
        }
        if (this.object instanceof DocumentFragment) {
            this.getDTM((Node)this.object);
            int node = this.getNode((Node)this.object, this.dtm);
            this.set = this.factory.getXNodeSet(this.dtm, node);
            return this.set;
        }
        if (this.object instanceof NodeList) {
            int length = ((NodeList)this.object).getLength();
            if (length > 0) {
                this.getDTM(((NodeList)this.object).item(0).getOwnerDocument());
            }
            this.set.reuse(this.dtm);
            int i = 0;
            while (i < length) {
                this.set.add(this.getNode(((NodeList)this.object).item(i), this.dtm));
                ++i;
            }
            return this.set;
        }
        if (this.object instanceof Node) {
            this.getDTM(((Node)this.object).getOwnerDocument());
            return this.set.reuse(this.factory.getXNodeSet(this.dtm, this.getNode((Node)this.object, this.dtm)));
        }
        if (this.object == null) {
            return this.set.reuse(this.dtm);
        }
        throw new XPathException("Cannot get a nodeset from java object that is neither a Node nor a NodeList.");
    }

    private void getDTM(Node node) throws XPathException {
        if (this.dtm != null) {
            return;
        }
        try {
            DTM dtm = new DTM();
            NamespaceManager nm = new NamespaceManager();
            DTMFactory fact = new DTMFactory();
            fact.initialize(dtm, nm);
            TransformerImpl tr = (TransformerImpl)new TransformerFactoryImpl().newTransformer();
            DOMSource source = new DOMSource(node);
            DocHandlerResult res = new DocHandlerResult(fact);
            tr.transform(source, res);
            this.dtm = dtm;
        }
        catch (TransformerConfigurationException e) {
            throw new XPathException(e.toString(), e);
        }
        catch (TransformerException e) {
            throw new XPathException(e.toString(), e);
        }
    }

    private int getNode(Node node, DTM dtm) {
        int[] ancestry = XNodeSet.getAncestry((Node)this.object);
        int n = XNodeSet.getNodeFromAncestry(dtm, ancestry);
        return n;
    }

    public void setContext(XPathContext context) {
        this.context = context;
        this.set = context.getXFactCurrent().getXNodeSet();
    }

    public int getType() {
        return 6;
    }

    public void print(int i) {
    }

    public XString toXString() {
        if (this.object == null) {
            return this.factory.getXString("");
        }
        if (this.object.toString() == null) {
            return this.factory.getXString("");
        }
        return this.factory.getXString(this.object.toString());
    }

    public XJavaObject toXJavaObject() throws XPathException {
        return this;
    }
}

