/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.CoreFunctionLibrary;
import com.sap.engine.lib.xsl.xpath.FunctionLibrary;
import com.sap.engine.lib.xsl.xpath.JLBLibrary;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XercesStyleFunctionLibrary;
import com.sap.engine.lib.xsl.xslt.QName;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.Enumeration;
import java.util.Hashtable;

public class LibraryManager {
    private Hashtable libraries = new Hashtable();
    private CharArray crtmp = new CharArray();
    private XSLStylesheet parent;
    private static CharArray crJAVA = new CharArray("java:");
    private static CharArray crXALAN = new CharArray("xalan:");

    public LibraryManager() {
        this(null);
    }

    public LibraryManager(XSLStylesheet parent) {
        this.parent = parent;
        this.registerLibrary(new CoreFunctionLibrary());
        this.registerLibrary(new XercesStyleFunctionLibrary(parent));
        this.parent = parent;
    }

    public void reuse() {
        this.libraries.clear();
        this.registerLibrary(new CoreFunctionLibrary());
        this.registerLibrary(new XercesStyleFunctionLibrary(this.parent));
    }

    public void registerLibrary(FunctionLibrary lib) {
        this.libraries.put(lib.getName(), lib);
    }

    public FunctionLibrary getLibrary(CharArray name) {
        if (name == null || name.length() == 0) {
            name = CoreFunctionLibrary.NAME;
        }
        return (FunctionLibrary)this.libraries.get(name);
    }

    public XFunction getFunction(QName name) throws XPathException {
        FunctionLibrary lib = this.getLibrary(name.uri);
        if (lib == null) {
            lib = this.getLibrary(this.checkClass(name.uri));
        }
        if (lib == null) {
            try {
                lib = new JLBLibrary(name.uri.toString(), this.parent.getExtClassLoader());
                this.registerLibrary(lib);
            }
            catch (ClassNotFoundException e) {
                throw new XPathException("Could not load class: " + name.uri + " required for extension library.", e);
            }
        }
        return lib.getFunction(name.localname);
    }

    public JLBLibrary getByClassName(String className) {
        Enumeration enumeration = this.libraries.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof JLBLibrary) || !((JLBLibrary)o).getClassName().equals(className)) continue;
            return (JLBLibrary)o;
        }
        try {
            ClassLoader cl = null;
            if (this.parent != null) {
                cl = this.parent.getExtClassLoader();
            }
            JLBLibrary lib = new JLBLibrary(className, cl);
            this.registerLibrary(lib);
            return lib;
        }
        catch (ClassNotFoundException classnotfoundexception) {
            return null;
        }
    }

    public CharArray checkClass(CharArray cl) {
        this.crtmp.set(cl);
        if (cl.startsWith(crJAVA)) {
            this.crtmp.substring(cl, 5);
        } else if (cl.startsWith(crXALAN)) {
            this.crtmp.substring(cl, 6);
        } else {
            this.crtmp.set(cl);
        }
        while (this.crtmp.length() > 0 && this.crtmp.charAt(0) == '/') {
            this.crtmp.substring(this.crtmp, 1);
        }
        return this.crtmp;
    }
}

