/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform;

import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.algorithms.Base64;
import com.sap.engine.lib.xml.signature.transform.algorithms.BinaryDecryptTransformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.DecryptTransformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.ExclusiveCanonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.XSLTTransformation;
import java.util.HashMap;
import java.util.Hashtable;

public abstract class Transformation
implements Cloneable {
    public String uri = null;
    public Object[] additionalArgs = null;
    public HashMap dataHashmap = null;

    public String toString() {
        return this.uri.concat(this.additionalArgs());
    }

    String additionalArgs() {
        if (this.additionalArgs == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(' ');
        int i = 0;
        while (i < this.additionalArgs.length) {
            Object arg = this.additionalArgs[i];
            if (arg instanceof String[]) {
                String[] arr = (String[])arg;
                int j = 0;
                while (j < arr.length) {
                    buf.append(arr[j]).append(' ');
                    ++j;
                }
            } else {
                buf.append(arg);
            }
            buf.append('|');
            ++i;
        }
        return buf.toString();
    }

    protected Transformation(Object[] additionalArgs) {
        this.additionalArgs = additionalArgs;
    }

    protected Transformation(Object[] additionalArgs, HashMap dataHashmap) {
        this.additionalArgs = additionalArgs;
        this.dataHashmap = dataHashmap;
    }

    public abstract void transform(Data var1) throws SignatureException;

    public static Transformation getInstance(String uri, Object[] additionalArgs) throws SignatureException {
        if (uri.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            ExclusiveCanonicalization xc = new ExclusiveCanonicalization(additionalArgs, false);
            xc.uri = uri;
            return xc;
        }
        if (uri.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            ExclusiveCanonicalization xc = new ExclusiveCanonicalization(additionalArgs, true);
            xc.uri = uri;
            return xc;
        }
        if (uri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            Canonicalization c = new Canonicalization(additionalArgs, false);
            c.uri = uri;
            return c;
        }
        if (uri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) {
            Canonicalization c = new Canonicalization(additionalArgs, true);
            c.uri = uri;
            return c;
        }
        if (uri.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            XPathTransformation xp = new XPathTransformation(additionalArgs);
            xp.uri = uri;
            return xp;
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
            Hashtable<String, String> mapping = new Hashtable<String, String>();
            mapping.put("dsig", "http://www.w3.org/2000/09/xmldsig#");
            XPathTransformation xp = new XPathTransformation(new Object[]{"not(ancestor-or-self::dsig:Signature)", mapping});
            xp.uri = uri;
            return xp;
        }
        if (uri.equals("http://www.w3.org/2000/09/xmldsig#base64")) {
            Base64 b64 = new Base64(additionalArgs);
            return b64;
        }
        if (uri.equals("http://www.w3.org/TR/1999/REC-xslt-19991116")) {
            XSLTTransformation xslt = new XSLTTransformation(additionalArgs);
            xslt.uri = uri;
            return xslt;
        }
        if (uri.equals("http://www.w3.org/2002/07/decrypt#XML")) {
            DecryptTransformation decrypt = new DecryptTransformation(additionalArgs);
            decrypt.uri = uri;
            return decrypt;
        }
        if (uri.equals("http://www.w3.org/2002/07/decrypt#Binary")) {
            BinaryDecryptTransformation decrypt = new BinaryDecryptTransformation(additionalArgs);
            decrypt.uri = uri;
            return decrypt;
        }
        if (uri.equals("http://www.w3.org/2001/04/decrypt#")) {
            DecryptTransformation decrypt = new DecryptTransformation(additionalArgs);
            decrypt.uri = uri;
            return decrypt;
        }
        throw new SignatureException("Unrecognized transformation uri: " + uri, new Object[]{uri, additionalArgs});
    }

    public abstract Transformation defineFrom(GenericElement var1, HashMap var2) throws SignatureException;

    public Transformation defineFrom(Object[] additionalArguments, HashMap $dataHashmap) throws SignatureException {
        this.additionalArgs = additionalArguments;
        this.dataHashmap = $dataHashmap;
        return this;
    }
}

