/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.xml.signature.SignatureException;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CryptographicProvider {
    String name = null;
    String jceString = null;
    Hashtable signatureAlgorithms = new Hashtable(4);
    Hashtable signatureAlgorithmsReversed = new Hashtable(4);
    Hashtable cipherAlgorithms = new Hashtable(8);
    Hashtable cipherAlgorithmsReversed = new Hashtable(8);
    Hashtable digestAlgorithms = new Hashtable(4);
    Hashtable digestAlgorithmsReversed = new Hashtable(4);
    Hashtable ivLengths = new Hashtable(4);

    public CryptographicProvider(Node provider) {
        NamedNodeMap nnm = provider.getAttributes();
        Node uri = nnm.getNamedItem("name");
        Node jce = nnm.getNamedItem("jceString");
        this.name = uri != null ? uri.getNodeValue() : null;
        this.jceString = jce != null ? jce.getNodeValue() : null;
        NodeList childs = provider.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node n = childs.item(i);
            String nameValue = n.getNodeName();
            if ("CipherAlgorithms".equals(nameValue)) {
                this.init(n, this.cipherAlgorithms, this.cipherAlgorithmsReversed);
            } else if ("MessageDigestAlgorithms".equals(nameValue)) {
                this.init(n, this.digestAlgorithms, this.digestAlgorithmsReversed);
            } else if ("SignatureAlgorithms".equals(nameValue)) {
                this.init(n, this.signatureAlgorithms, this.signatureAlgorithmsReversed);
            }
            ++i;
        }
    }

    private void init(Node n, Hashtable mapping, Hashtable reversedMapping) {
        NodeList childs = n.getChildNodes();
        int i = 0;
        while (i < childs.getLength()) {
            Node child = childs.item(i);
            String nodeName = child.getNodeName();
            if ("Algorithm".equals(nodeName)) {
                NamedNodeMap nnm = child.getAttributes();
                nnm.getNamedItem("name");
                Node uri = nnm.getNamedItem("uri");
                Node jce = nnm.getNamedItem("jce");
                Node ivLen = nnm.getNamedItem("ivlen");
                if (uri != null && jce != null) {
                    String uriValue = uri.getNodeValue();
                    String jceValue = jce.getNodeValue();
                    mapping.put(uriValue, jceValue);
                    reversedMapping.put(jceValue, uriValue);
                    if (ivLen != null) {
                        String iv = ivLen.getNodeValue();
                        try {
                            this.ivLengths.put(uriValue, new Integer(iv));
                        }
                        catch (NumberFormatException nfe) {
                            new SignatureException("Number format exception", new Object[]{n.getOwnerDocument(), uriValue, iv}, nfe);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected CryptographicProvider() {
    }

    static void initConstants(Hashtable providers) {
        providers.clear();
        CryptographicProvider IAIK = new CryptographicProvider();
        IAIK.name = "IAIK";
        IAIK.jceString = "IAIK";
        IAIK.digestAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#md5", "MD5");
        IAIK.digestAlgorithms.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA-1");
        IAIK.digestAlgorithmsReversed.put("MD5", "http://www.w3.org/2001/04/xmldsig-more#md5");
        IAIK.digestAlgorithmsReversed.put("SHA-1", "http://www.w3.org/2000/09/xmldsig#sha1");
        IAIK.signatureAlgorithms.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "SHA-1/DSA");
        IAIK.signatureAlgorithms.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA-1/RSA");
        IAIK.signatureAlgorithmsReversed.put("SHA-1/DSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        IAIK.signatureAlgorithmsReversed.put("SHA-1/RSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        IAIK.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "3DES");
        IAIK.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "Rijndael");
        IAIK.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "Rijndael-256");
        IAIK.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA");
        IAIK.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "RSA");
        IAIK.cipherAlgorithmsReversed.put("3DES", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        IAIK.cipherAlgorithmsReversed.put("Rijndael", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        IAIK.cipherAlgorithmsReversed.put("Rijndael-256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        IAIK.cipherAlgorithmsReversed.put("RSA", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        IAIK.ivLengths.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Integer("8"));
        IAIK.ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Integer("16"));
        IAIK.ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new Integer("32"));
        CryptographicProvider BC = new CryptographicProvider();
        BC.name = "BouncyCastle";
        BC.jceString = "BC";
        BC.digestAlgorithms.put("http://www.w3.org/2001/04/xmldsig-more#md5", "MD5");
        BC.digestAlgorithms.put("http://www.w3.org/2000/09/xmldsig#sha1", "SHA1");
        BC.digestAlgorithmsReversed.put("MD5", "http://www.w3.org/2001/04/xmldsig-more#md5");
        BC.digestAlgorithmsReversed.put("SHA1", "http://www.w3.org/2000/09/xmldsig#sha1");
        BC.signatureAlgorithms.put("http://www.w3.org/2000/09/xmldsig#dsa-sha1", "DSA");
        BC.signatureAlgorithms.put("http://www.w3.org/2000/09/xmldsig#rsa-sha1", "SHA1WithRSAEncryption");
        BC.signatureAlgorithmsReversed.put("DSA", "http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        BC.signatureAlgorithmsReversed.put("SHA1WithRSAEncryption", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        BC.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", "DESEDE");
        BC.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "AES");
        BC.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", "AES-256");
        BC.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#rsa-1_5", "RSA");
        BC.cipherAlgorithms.put("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", "RSA");
        BC.cipherAlgorithmsReversed.put("DESEDE", "http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        BC.cipherAlgorithmsReversed.put("AES", "http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        BC.cipherAlgorithmsReversed.put("AES-256", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        BC.cipherAlgorithmsReversed.put("RSA", "http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        BC.ivLengths.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Integer("8"));
        BC.ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Integer("16"));
        BC.ivLengths.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", new Integer("32"));
        providers.put(BC.getJceString(), BC);
        providers.put(IAIK.getJceString(), IAIK);
    }

    public Map getCipherAlgorithms() {
        return Collections.unmodifiableMap(this.cipherAlgorithms);
    }

    public Map getSignatureAlgorithms() {
        return Collections.unmodifiableMap(this.signatureAlgorithms);
    }

    public Map getDigestAlgorithms() {
        return Collections.unmodifiableMap(this.digestAlgorithms);
    }

    public Map getIVLengths() {
        return Collections.unmodifiableMap(this.ivLengths);
    }

    public int getIVLength(String algorithmURI) {
        Integer i = (Integer)this.ivLengths.get(algorithmURI);
        if (i == null) {
            return 0;
        }
        return i;
    }

    public String getDigestURIFromJCE(String jceName) {
        return (String)this.digestAlgorithmsReversed.get(jceName);
    }

    public String getSignatureURIFromJCE(String jceName) {
        return (String)this.signatureAlgorithmsReversed.get(jceName);
    }

    public String getCipherURIFromJCE(String jceName) {
        return (String)this.cipherAlgorithmsReversed.get(jceName);
    }

    public String getDigestAlgorithm(String uri) {
        return (String)this.digestAlgorithms.get(uri);
    }

    public String getSignatureAlgorithm(String uri) {
        return (String)this.signatureAlgorithms.get(uri);
    }

    public String getCipherAlgorithm(String uri) {
        return (String)this.cipherAlgorithms.get(uri);
    }

    public String getJceString() {
        return this.jceString;
    }

    public String getName() {
        return this.name;
    }
}

