/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.binary.util;

import com.sap.engine.lib.xml.parser.binary.util.IntHashHolder;
import com.sap.engine.lib.xml.parser.binary.util.IntHashHolderImpl;
import com.sap.engine.lib.xml.parser.binary.util.PrimeGenerator;
import com.sap.engine.lib.xml.parser.binary.util.PrimitiveTypeDataStructure;

public class HashMapObjectIntPositive
extends PrimitiveTypeDataStructure {
    public static final int GROW_STEP = 2;
    public static final int INITIAL_CAPACITY = 13;
    protected static final int LAST = -1;
    public static final float LOAD_FACTOR = 0.75f;
    protected int capacity;
    protected transient int[] elements;
    protected int growSimpl;
    protected int growStep;
    protected IntHashHolder hasher;
    protected transient Object[] keys;
    protected int limit;
    protected float loadFactor;
    protected transient int nextFree;
    protected transient int[] nextPtr;
    protected int simplIndex;

    public HashMapObjectIntPositive() {
        this(13, 2, 0.75f, new IntHashHolderImpl());
    }

    public HashMapObjectIntPositive(int initialCapacity, int growStep, float loadFactor, IntHashHolder hasher) {
        if ((double)loadFactor > 1.0 || loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Load Factor = " + loadFactor);
        }
        if (growStep <= 1) {
            throw new IllegalArgumentException("Grow step = " + growStep);
        }
        this.growStep = growStep;
        this.growSimpl = growStep == 2 ? 4 : (growStep < 10 ? growStep + 4 : 13);
        this.loadFactor = loadFactor;
        this.hasher = hasher;
        this.simplIndex = 0;
        this.init(initialCapacity);
    }

    public void clear() {
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        int i3 = 0;
        while (i3 < this.elements.length) {
            this.keys[i3] = null;
            ++i3;
        }
        this.nextFree = this.capacity;
        this.count = 0;
    }

    protected void init(int initialCapacity) {
        if (this.growStep > 17) {
            this.capacity = (int)PrimeGenerator.getClosestPrime(initialCapacity);
        } else {
            long l = PrimeGenerator.getClosestPrime(initialCapacity, this.simplIndex);
            this.simplIndex = (int)(l >> 32) + this.growSimpl;
            this.capacity = (int)l;
        }
        this.limit = (int)((float)this.capacity * this.loadFactor);
        this.nextPtr = new int[this.capacity + this.limit];
        int i = 0;
        while (i < this.capacity) {
            this.nextPtr[i] = -1;
            ++i;
        }
        int i2 = this.capacity;
        while (i2 < this.nextPtr.length) {
            this.nextPtr[i2++] = i2;
        }
        this.keys = new Object[this.limit];
        this.elements = new int[this.limit];
        this.nextFree = this.capacity;
        this.count = 0;
    }

    public int put(Object key, int value) {
        int index;
        if (this.count == this.limit) {
            this.rehash();
        }
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            index = (pos = this.nextPtr[pos]) - this.capacity;
            if (!this.keys[index].equals(key)) continue;
            int temp = this.elements[index];
            this.elements[index] = value;
            return temp;
        }
        index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
        return -1;
    }

    protected void putQuick(Object key, int value) {
        int pos = this.hasher.hash(key.hashCode()) % this.capacity;
        while (this.nextPtr[pos] != -1) {
            pos = this.nextPtr[pos];
        }
        int index = this.nextFree - this.capacity;
        this.nextPtr[pos] = this.nextFree;
        this.keys[index] = key;
        this.elements[index] = value;
        this.nextFree = this.nextPtr[this.nextFree];
        this.nextPtr[this.nextPtr[pos]] = -1;
        ++this.count;
    }

    protected void rehash() {
        Object[] oldKeys = this.keys;
        int[] oldElements = this.elements;
        this.init(this.capacity * this.growStep);
        int i = 0;
        while (i < oldKeys.length) {
            this.putQuick(oldKeys[i], oldElements[i]);
            ++i;
        }
    }

    public int remove(Object key) {
        int prevPos = this.hasher.hash(key.hashCode()) % this.capacity;
        int pos = this.nextPtr[prevPos];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                int result = this.elements[index];
                this.keys[index] = null;
                this.nextPtr[prevPos] = this.nextPtr[pos];
                this.nextPtr[pos] = this.nextFree;
                this.nextFree = pos;
                --this.count;
                return result;
            }
            prevPos = pos;
            pos = this.nextPtr[pos];
        }
        return -1;
    }

    public int get(Object key) {
        int pos = this.nextPtr[this.hasher.hash(key.hashCode()) % this.capacity];
        while (pos != -1) {
            int index = pos - this.capacity;
            if (this.keys[index].equals(key)) {
                return this.elements[index];
            }
            pos = this.nextPtr[pos];
        }
        return -1;
    }
}

