/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.validator.identity;

import com.sap.engine.lib.schema.components.IdentityConstraintDefinition;
import com.sap.engine.lib.schema.components.TypeDefinitionBase;
import com.sap.engine.lib.schema.exception.SchemaException;
import com.sap.engine.lib.schema.validator.ValidationContext;
import com.sap.engine.lib.schema.validator.identity.AbstractIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.KeyIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.KeyrefIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.identity.UniqueIdentityConstraintDefinitionValidator;
import com.sap.engine.lib.schema.validator.xpath.XPathObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IdentityConstraintDefinitionsValidator {
    protected Hashtable activeValidators = new Hashtable();
    protected Hashtable inactiveValidators = new Hashtable();

    public IdentityConstraintDefinitionsValidator(IdentityConstraintDefinition[] identityCostrDefs, ValidationContext context) {
        KeyIdentityConstraintDefinitionValidator referedKeyIdentityCostrDefProcessor;
        IdentityConstraintDefinition referedKeyIdentityConstDef;
        Vector<IdentityConstraintDefinition> keyrefIdentConstrDefsCollector = new Vector<IdentityConstraintDefinition>();
        int i = 0;
        while (i < identityCostrDefs.length) {
            IdentityConstraintDefinition identityCostrDef = identityCostrDefs[i];
            AbstractIdentityConstraintDefinitionValidator processor = null;
            if (identityCostrDef.isIdentityConstraintCategoryKey()) {
                processor = new KeyIdentityConstraintDefinitionValidator(identityCostrDef, context);
            } else if (identityCostrDef.isIdentityConstraintCategoryUnique()) {
                processor = new UniqueIdentityConstraintDefinitionValidator(identityCostrDef, context);
            } else {
                referedKeyIdentityConstDef = identityCostrDef.getReferencedKey();
                referedKeyIdentityCostrDefProcessor = (KeyIdentityConstraintDefinitionValidator)this.inactiveValidators.get(referedKeyIdentityConstDef.getQualifiedKey());
                if (referedKeyIdentityCostrDefProcessor != null) {
                    processor = new KeyrefIdentityConstraintDefinitionValidator(identityCostrDef, referedKeyIdentityCostrDefProcessor, context);
                } else {
                    keyrefIdentConstrDefsCollector.add(identityCostrDef);
                }
            }
            if (processor != null) {
                this.inactiveValidators.put(processor.identityConstrDef.getQualifiedKey(), processor);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < keyrefIdentConstrDefsCollector.size()) {
            IdentityConstraintDefinition keyrefIdentityCostrDef = (IdentityConstraintDefinition)keyrefIdentConstrDefsCollector.get(i2);
            referedKeyIdentityConstDef = keyrefIdentityCostrDef.getReferencedKey();
            referedKeyIdentityCostrDefProcessor = (KeyIdentityConstraintDefinitionValidator)this.inactiveValidators.get(referedKeyIdentityConstDef.getQualifiedKey());
            KeyrefIdentityConstraintDefinitionValidator processor = new KeyrefIdentityConstraintDefinitionValidator(keyrefIdentityCostrDef, referedKeyIdentityCostrDefProcessor, context);
            this.inactiveValidators.put(processor.identityConstrDef.getQualifiedKey(), processor);
            ++i2;
        }
    }

    public void activate(String key, XPathObject xPathObj) {
        AbstractIdentityConstraintDefinitionValidator processor = (AbstractIdentityConstraintDefinitionValidator)this.inactiveValidators.get(key);
        if (processor != null) {
            this.inactiveValidators.remove(key);
            processor.setContextXPathObject(xPathObj.cloneXPathObject());
            this.activeValidators.put(key, processor);
        }
    }

    public void inactivate(String key) {
        AbstractIdentityConstraintDefinitionValidator processor = (AbstractIdentityConstraintDefinitionValidator)this.activeValidators.get(key);
        if (processor != null) {
            this.activeValidators.remove(key);
            this.inactiveValidators.put(key, processor);
            processor.clear();
        }
    }

    public void addStructure(TypeDefinitionBase typeDefBase, String value, XPathObject xPathObj, boolean isNillable) throws SchemaException {
        Enumeration enumeration = this.activeValidators.elements();
        while (enumeration.hasMoreElements()) {
            AbstractIdentityConstraintDefinitionValidator processor = (AbstractIdentityConstraintDefinitionValidator)enumeration.nextElement();
            processor.add(typeDefBase, value, xPathObj, isNillable);
        }
    }

    public boolean validate(IdentityConstraintDefinition[] identConstrDefinitions) {
        int i = 0;
        while (i < identConstrDefinitions.length) {
            IdentityConstraintDefinition identConstrDef = identConstrDefinitions[i];
            String key = identConstrDef.getQualifiedKey();
            AbstractIdentityConstraintDefinitionValidator processor = (AbstractIdentityConstraintDefinitionValidator)this.activeValidators.get(key);
            if (!processor.validate()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

