/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.util;

import java.util.Vector;

public abstract class Tokenizer {
    protected Vector tokensCollector = new Vector();
    protected int index = 0;

    public Tokenizer(String target, String[] delimiters) {
        if (delimiters != null) {
            this.sort(delimiters);
        }
        this.processTarget(target, delimiters);
    }

    private void sort(String[] delimiters) {
        int i = 0;
        while (i < delimiters.length) {
            String delimiter = delimiters[i];
            int replacementIndex = 0;
            int j = i + 1;
            while (j < delimiters.length) {
                String delimiterToCmpWith = delimiters[j];
                if (delimiter.length() < delimiterToCmpWith.length()) {
                    delimiter = delimiterToCmpWith;
                    replacementIndex = j;
                }
                ++j;
            }
            if (replacementIndex != 0) {
                String hlpDelimiter = delimiters[i];
                delimiters[i] = delimiter;
                delimiters[replacementIndex] = hlpDelimiter;
            }
            ++i;
        }
    }

    protected abstract void processTarget(String var1, String[] var2);

    public String next() {
        String result = null;
        if (this.index < this.tokensCollector.size()) {
            result = (String)this.tokensCollector.get(this.index++);
        }
        return result;
    }

    public String peek() {
        String result = this.next();
        if (result != null) {
            --this.index;
        }
        return result;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.tokensCollector.size()) {
            throw new IllegalArgumentException("Illegal index : " + index);
        }
        this.index = index;
    }
}

