/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.schema.components.impl.structures;

import com.sap.engine.lib.schema.components.AttributeDeclaration;
import com.sap.engine.lib.schema.components.Base;
import com.sap.engine.lib.schema.components.impl.BaseInfo;
import com.sap.engine.lib.schema.components.impl.SchemaStructuresFactory;
import com.sap.engine.lib.schema.components.impl.structures.BaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.InfoItemDeclarationBaseImpl;
import com.sap.engine.lib.schema.components.impl.structures.TypeDefinitionBaseImpl;
import com.sap.engine.lib.schema.exception.SchemaComponentException;
import com.sap.engine.lib.xml.dom.DOM;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AttributeDeclarationImpl
extends InfoItemDeclarationBaseImpl
implements AttributeDeclaration {
    protected boolean isProhibited;
    protected boolean isRequired;

    public AttributeDeclarationImpl() {
        this(null, null);
    }

    public AttributeDeclarationImpl(Node associatedNode, BaseInfo baseInfo) {
        this(associatedNode, baseInfo, false);
    }

    public AttributeDeclarationImpl(Node associatedNode, BaseInfo baseInfo, boolean isTopLevel) {
        super(associatedNode, baseInfo, isTopLevel);
    }

    public boolean isProhibited() {
        return this.isProhibited;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public int getTypeOfComponent() {
        return 4;
    }

    public boolean match(Base attribDeclr) {
        return super.match(attribDeclr);
    }

    public void load() throws SchemaComponentException {
        if (this.associatedNode != null) {
            String useAttribValue;
            this.defaultValue = this.loadAttribsCollector.getProperty("default");
            this.fixedValue = this.loadAttribsCollector.getProperty("fixed");
            this.id = this.loadAttribsCollector.getProperty("id");
            String typeDefAttribValue = this.loadAttribsCollector.getProperty("type");
            if (typeDefAttribValue != null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.getTopLevelBase(this.associatedNode, typeDefAttribValue, 16);
                SchemaStructuresFactory.loadBase(this.typeDefinition);
            }
            if ((useAttribValue = this.loadAttribsCollector.getProperty("use")) != null) {
                if (useAttribValue.equals("prohibited")) {
                    this.isProhibited = true;
                } else if (useAttribValue.equals("required")) {
                    this.isRequired = true;
                }
            }
            NodeList nodeList = this.associatedNode.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                String nodeUri;
                Node node = nodeList.item(i);
                if (node instanceof Element && (nodeUri = node.getNamespaceURI()) != null && nodeUri.equals("http://www.w3.org/2001/XMLSchema")) {
                    String nodeLocalName = node.getLocalName();
                    if (nodeLocalName.equals("simpleType")) {
                        if (this.typeDefinition != null) {
                            throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration " + DOM.toXPath(this.associatedNode) + " is not correct. 'type' and <simpleType> are exclusive.");
                        }
                        this.typeDefinition = SchemaStructuresFactory.createSimpleTypeDefinition(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.typeDefinition);
                    } else if (nodeLocalName.equals("annotation")) {
                        this.annotation = SchemaStructuresFactory.createAnnotation(node, this.baseInfo);
                        SchemaStructuresFactory.loadBase(this.annotation);
                    }
                }
                ++i;
            }
            if (this.defaultValue != null && (this.isProhibited || this.isRequired)) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration '" + DOM.toXPath(this.associatedNode) + "' is not correct. If default and use are both present, use must have the actual value 'optional'.");
            }
            if (this.name.equals("xmlns")) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration '" + DOM.toXPath(this.associatedNode) + "' is not correct. The {name} of an attribute declaration must not match 'xmlns'.");
            }
            if (this.targetNamespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                throw new SchemaComponentException("[location : '" + this.baseInfo.getLocation() + "'] ERROR : Definition of attribute declaration '" + DOM.toXPath(this.associatedNode) + "' is not correct. The {target namespace} of an attribute declaration, whether local or top-level, must not match http://www.w3.org/2001/XMLSchema-instance.");
            }
            if (this.typeDefinition == null) {
                this.typeDefinition = (TypeDefinitionBaseImpl)this.baseInfo.getSchema().getTopLevelTypeDefinition("http://www.w3.org/2001/XMLSchema", "anySimpleType");
            }
            this.checkValueConstraint();
            this.baseInfo.getSchema().allComponentsCollector.add(this);
        }
    }

    protected BaseImpl initializeBase(BaseImpl base, Hashtable typesCollector) {
        AttributeDeclarationImpl result = (AttributeDeclarationImpl)super.initializeBase(base, typesCollector);
        result.isProhibited = this.isProhibited;
        result.isRequired = this.isRequired;
        return result;
    }
}

