/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.xml.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.EmptyStackException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class URLLoaderBase
implements EntityResolver {
    public static final String CACHE_INDEX_FILE_NAME = "index.properties";
    public static final String CACHED_FILE_EXTENSION = ".cached";
    private Stack stack = new Stack();
    private URL stackTop = null;
    private String proxyHost = null;
    private int proxyPort = -1;
    private boolean useProxy = false;
    private String cacheDirName = null;
    private File cacheDir = null;
    private String cacheIndexFileName = null;
    private File cacheIndexFile = null;
    private boolean useCache = false;
    private Properties cacheIndex = new Properties();
    private byte[] buffer = new byte[1000];

    public URLLoaderBase() {
        this.init();
    }

    public void init() {
        this.stack.clear();
        this.stackTop = null;
        this.proxyHost = null;
        this.proxyPort = -1;
        this.useProxy = false;
        this.cacheDirName = null;
        this.cacheDir = null;
        this.cacheIndexFileName = null;
        this.cacheIndexFile = null;
        this.useCache = false;
        try {
            this.loadAndPush(new File("").getAbsolutePath().toString() + "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URL load(String s) throws IOException {
        URL url = this.load(this.stackTop, s);
        return url;
    }

    public URL loadAndPush(String s) throws IOException {
        URL url = this.loadAndPush(this.stackTop, s);
        return url;
    }

    public URL load(URL base, String s) throws IOException {
        URL url = URLLoaderBase.fileOrURLToURL(base, s);
        if (this.useCache) {
            url = this.passThroughCache(url);
        } else if (this.useProxy) {
            url = this.passThroughProxy(url);
        }
        return url;
    }

    public URL loadAndPush(URL base, String s) throws IOException {
        URL url = URLLoaderBase.fileOrURLToURL(base, s);
        this.push(url);
        if (this.useCache) {
            url = this.passThroughCache(url);
        } else if (this.useProxy) {
            url = this.passThroughProxy(url);
        }
        return url;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        URL external = this.loadAndPush(systemId);
        systemId = external.toString();
        InputSource is = new InputSource();
        is.setSystemId(systemId);
        is.setPublicId(publicId);
        is.setByteStream(new URL(systemId).openStream());
        return is;
    }

    public void push(URL url) {
        this.stack.push(url);
        this.stackTop = url;
    }

    public void pushTheSame() {
        try {
            this.stack.push(this.stack.peek());
        }
        catch (EmptyStackException e) {
            this.stack.push(null);
        }
    }

    public void pop() {
        try {
            URL u = (URL)this.stack.pop();
            this.stackTop = !this.stack.empty() ? (URL)this.stack.peek() : null;
        }
        catch (EmptyStackException e) {
            throw new RuntimeException("URLLoader's stack is empty.");
        }
    }

    public URL peek() {
        try {
            return (URL)this.stack.peek();
        }
        catch (EmptyStackException e) {
            throw new RuntimeException("URLLoader's stack is empty.");
        }
    }

    private URL passThroughProxy(URL url) throws IOException {
        return url;
    }

    private URL passThroughCache(URL url) throws IOException {
        int b;
        if (!this.useCache || !url.getProtocol().equals("http")) {
            return url;
        }
        String externalForm = url.toExternalForm();
        String s = this.cacheIndex.getProperty(externalForm);
        if (s != null) {
            return new URL("file:" + this.cacheDirName + "\\" + s);
        }
        s = this.createCachedFileName(url);
        url = this.passThroughProxy(url);
        InputStream in = url.openStream();
        new File(this.cacheDirName + "\\" + s).createNewFile();
        FileOutputStream out = new FileOutputStream(this.cacheDirName + "\\" + s);
        while ((b = in.read(this.buffer)) != -1) {
            out.write(this.buffer, 0, b);
        }
        out.close();
        this.cacheIndex.setProperty(externalForm, s);
        this.storeIndex();
        url = new URL("file:" + this.cacheDirName + "\\" + s);
        return url;
    }

    private String createCachedFileName(URL url) {
        String s = "_" + url.toExternalForm().replace('/', '_').replace('\\', '_').replace(':', '_').replace('?', '_').replace('~', '_').replace('#', '_');
        return "t" + System.currentTimeMillis() + s + CACHED_FILE_EXTENSION;
    }

    public void storeIndex() throws IOException {
        if (this.cacheIndexFile != null) {
            if (!this.cacheIndexFile.exists()) {
                File parentDir = this.cacheIndexFile.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                this.cacheIndexFile.createNewFile();
            }
            this.cacheIndex.store(new FileOutputStream(this.cacheIndexFileName), "Index file for the caching system of the XML parser.");
        }
    }

    public void setProxyHost(String s) {
        this.proxyHost = s;
    }

    public void setProxyPort(int p) {
        this.proxyPort = p;
    }

    public void setUseProxy(boolean b) {
        this.useProxy = b;
    }

    public void setCacheDir(String s) {
        if (s.startsWith("file:")) {
            s = s.substring(5);
        }
        this.cacheDirName = s;
        this.cacheDir = new File(s);
        this.cacheIndexFile = new File(this.cacheDir, CACHE_INDEX_FILE_NAME);
        this.cacheIndexFileName = this.cacheIndexFile.toString();
        ((Hashtable)this.cacheIndex).clear();
        try {
            this.cacheIndex.load(new FileInputStream(this.cacheIndexFileName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setUseCache(boolean b) {
        this.useCache = b;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public boolean getUseProxy() {
        return this.useProxy;
    }

    public String getCacheDir() {
        return this.cacheDirName;
    }

    public boolean getUseCache() {
        return this.useCache;
    }

    public void printStack() {
        System.out.println("URLLoader stack = " + this.stack);
    }

    public void clearStack() {
        this.stack.clear();
    }

    public static URL fileOrURLToURL(URL base, String s) throws IOException {
        if (s == null) {
            return null;
        }
        if (base == null) {
            base = new URL("file:");
        }
        s = s.replace('\\', '/');
        try {
            if (s.charAt(1) == ':' || s.charAt(0) == '/' || s.charAt(0) == '\\') {
                s = new File(s).toURL().toExternalForm();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        if (s.startsWith("file:") && s.length() > 5 && s.charAt(5) != '/') {
            s = "file:/" + s.substring(5);
        } else if (s.startsWith("file://") && !s.startsWith("file:////") && !s.startsWith("file://localhost/")) {
            s = "file:////" + s.substring("file://".length());
        }
        URL url = new URL(base, s);
        return url;
    }
}

