/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.util;

import com.inqmy.lib.xml.parser.helpers.CharArray;

public final class ListTokenizer {
    private CharArray list;
    private CharArray token;
    private char[] data;
    private int pointer;
    private int end;
    private boolean hm;

    public void init(CharArray list, CharArray token) {
        this.list = list;
        this.token = token;
        this.pointer = list.getOffset();
        this.data = list.getData();
        this.end = this.pointer + list.length();
        this.hm = true;
        this.next();
    }

    public void next() {
        while (true) {
            if (this.pointer >= this.end) {
                this.hm = false;
                this.token.clear();
                return;
            }
            if (!this.isWS(this.data[this.pointer])) {
                int q = this.pointer++;
                while (this.pointer < this.end && !this.isWS(this.data[this.pointer])) {
                    ++this.pointer;
                }
                this.token.substring(this.list, q, this.pointer);
                return;
            }
            ++this.pointer;
        }
    }

    public boolean hasMore() {
        return this.hm;
    }

    private boolean isWS(char ch) {
        return ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t';
    }

    public static void main(String[] args) throws Exception {
        CharArray a = new CharArray("   the    \r big brown \r\n      fox     ");
        CharArray b = new CharArray();
        ListTokenizer t = new ListTokenizer();
        int i = 0;
        t.init(a, b);
        while (t.hasMore()) {
            System.out.println("   [" + i + "] = '" + b + "'");
            ++i;
            t.next();
        }
        System.out.println("");
    }
}

