/*
 * Decompiled with CFR 0.152.
 */
package com.inqmy.lib.schema.generator;

import com.inqmy.lib.schema.Schema;
import com.inqmy.lib.schema.generator.Codes;
import com.inqmy.lib.schema.generator.TreeWalker;
import java.io.OutputStream;
import java.io.PrintStream;

public final class SchemaDecompiler {
    private static boolean STRING_HEADERS = true;
    private static boolean AS_INTEGERS = false;
    private static boolean WARNINGS = true;
    private static boolean DECOMPILE_LINEAR = true;
    private static boolean DECOMPILE_TREE = true;
    private static final int INDENT_INITIAL = 0;
    private static final int INDENT_STEP = 5;
    private TreeWalker walker;
    private PrintStream out;
    private char[] code;

    public void decompile(Schema s, OutputStream out0) {
        try {
            this.out = out0 instanceof PrintStream ? (PrintStream)out0 : new PrintStream(out0);
            this.code = s.getCode();
            this.walker = s.getWalker();
            if (DECOMPILE_LINEAR) {
                this.decompileLinear(s.getCode(), 0, s.getCodeSize());
                this.out.println();
                this.out.println();
            }
            if (DECOMPILE_TREE) {
                this.decompileAsTree(s);
                this.out.println();
                this.out.println();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void decompileLinear(char[] code, int start, int end) {
        if (code[0] != '\uf0b1' || code[1] != '\ua666' || code[3] != '\u0000') {
            this.warn("Bad magic number");
        }
        this.out.println("    code[0]:  MAGIC_H MAGIC_L #" + (short)code[2] + " END");
        int i = start + 4;
        while (true) {
            if (i >= end) {
                this.out.println();
                return;
            }
            int iSave = i;
            if (i < 10) {
                this.out.print(' ');
            }
            if (i < 100) {
                this.out.print(' ');
            }
            if (i < 1000) {
                this.out.print(' ');
            }
            this.out.print(" code[" + i + "]: ");
            if (code[i] == '\u0004') {
                this.out.print(" ROOT");
                ++i;
                while (code[i] != '\u0001') {
                    this.out.print(" #" + code[i]);
                    this.out.print(" #" + code[++i]);
                    ++i;
                }
                ++i;
                this.out.println(" END");
            } else if (code[i] == '\u0002') {
                int j = ++i;
                while (code[j] != '\u0000') {
                    ++j;
                }
                if (STRING_HEADERS) {
                    this.out.println(" STRING \"" + new String(code, i, j - i) + "\" ZERO");
                } else {
                    this.out.println(" \"" + new String(code, i, j - i) + "\"");
                }
                i = j + 1;
            } else if (code[i] == '\u0003') {
                this.out.println(" QNAME #" + (short)code[i + 1] + " #" + (short)code[i + 2] + " END");
                if (code[i + 3] != '\u0001') {
                    this.warn("QNAME not closed with END, but with #" + (short)code[i + 3]);
                }
                i += 4;
            } else {
                boolean ok = true;
                while (code[i] != '\u0001') {
                    if (code[i] == '\u00c8') {
                        this.out.print(" PTR #" + (short)code[i + 1]);
                        ++i;
                    } else {
                        this.out.flush();
                        String s = Codes.MNEMONIC[code[i]];
                        if (s == null) {
                            s = "???(" + (short)code[i] + ")";
                            ok = false;
                        }
                        this.out.print(" " + s);
                        if (Codes.isMark(code[i])) {
                            this.out.print(" #" + (short)code[++i]);
                        }
                    }
                    ++i;
                }
                ++i;
                this.out.println(" END");
                if (!ok) {
                    this.warn("Unrecognized instruction.");
                }
            }
            if (AS_INTEGERS) {
                this.out.print("                                                                             -> ");
                int k = iSave;
                while (k < i) {
                    this.out.print(" " + (short)code[k]);
                    ++k;
                }
                this.out.println("");
            }
            this.out.flush();
        }
    }

    private void decompileAsTree(Schema schema) throws Exception {
        this.decompileAsTree0(this.code[2], 0);
        this.out.flush();
    }

    private void decompileAsTree0(int p, int indent) {
        int i = 0;
        while (i < indent) {
            this.out.print(' ');
            ++i;
        }
        this.out.print(Codes.MNEMONIC[this.code[p]]);
        this.out.println(" (@" + p + ")");
        if (this.code[p] == '\u0004') {
            int q = p + 1;
            while (this.code[q] != '\u0001') {
                int i2 = 0;
                while (i2 < indent + 5) {
                    this.out.print(' ');
                    ++i2;
                }
                this.out.println("[With target namespace:] " + this.walker.getString(this.code[q]));
                this.decompileAsTree0(this.code[q + 1], indent + 5);
                q += 2;
            }
            return;
        }
        int q = p + 1;
        while (this.code[q] != '\u0001') {
            char m = this.code[q];
            if (m == '\u00c8') {
                this.decompileAsTree0(this.code[q + 1], indent + 5);
            } else {
                int i3 = 0;
                while (i3 < indent + 5) {
                    this.out.print(' ');
                    ++i3;
                }
                if (Codes.requiresString(m)) {
                    this.out.println("[" + Codes.MNEMONIC[m] + "] \"" + this.walker.getString(this.code[q + 1]) + "\"");
                } else if (Codes.requiresQName(m)) {
                    this.out.println("[" + Codes.MNEMONIC[m] + "] " + this.walker.getQName(this.code[q + 1]));
                } else {
                    this.out.flush();
                    this.out.println("[" + Codes.MNEMONIC[m] + "] [" + this.code[q + 1] + "]");
                }
            }
            q += 2;
        }
    }

    private void warn(String s) {
        if (WARNINGS) {
            this.out.println("!!! Decompiler warning: " + s);
        }
    }
}

