/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import com.sun.mail.util.BEncoderStream;
import com.sun.mail.util.LineInputStream;
import com.sun.mail.util.QDecoderStream;
import com.sun.mail.util.QEncoderStream;
import com.sun.mail.util.QPDecoderStream;
import com.sun.mail.util.QPEncoderStream;
import com.sun.mail.util.UUDecoderStream;
import com.sun.mail.util.UUEncoderStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.AsciiOutputStream;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class MimeUtility {
    public static final int ALL = -1;
    private static String defaultJavaCharset;
    private static String defaultMIMECharset;
    private static Hashtable mime2java;
    private static Hashtable java2mime;
    static final int ALL_ASCII = 1;
    static final int MOSTLY_ASCII = 2;
    static final int MOSTLY_NONASCII = 3;
    static /* synthetic */ Class class$javax$mail$internet$MimeUtility;

    private MimeUtility() {
    }

    public static String getEncoding(DataSource dataSource) {
        ContentType contentType = null;
        InputStream inputStream = null;
        String string = null;
        try {
            contentType = new ContentType(dataSource.getContentType());
            inputStream = dataSource.getInputStream();
        }
        catch (Exception exception) {
            return "base64";
        }
        if (contentType.match("text/*")) {
            int n2 = MimeUtility.checkAscii(inputStream, -1, false);
            switch (n2) {
                case 1: {
                    string = "7bit";
                    break;
                }
                case 2: {
                    string = "quoted-printable";
                    break;
                }
                default: {
                    string = "base64";
                    break;
                }
            }
        } else {
            string = MimeUtility.checkAscii(inputStream, -1, true) == 1 ? "7bit" : "base64";
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static String getEncoding(DataHandler dataHandler) {
        ContentType contentType = null;
        String string = null;
        if (dataHandler.getName() != null) {
            return MimeUtility.getEncoding(dataHandler.getDataSource());
        }
        try {
            contentType = new ContentType(dataHandler.getContentType());
        }
        catch (Exception exception) {
            return "base64";
        }
        if (contentType.match("text/*")) {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(false);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {}
            switch (asciiOutputStream.getAscii()) {
                case 1: {
                    string = "7bit";
                    break;
                }
                case 2: {
                    string = "quoted-printable";
                    break;
                }
                default: {
                    string = "base64";
                    break;
                }
            }
        } else {
            AsciiOutputStream asciiOutputStream = new AsciiOutputStream(true);
            try {
                dataHandler.writeTo((OutputStream)asciiOutputStream);
            }
            catch (IOException iOException) {}
            string = asciiOutputStream.getAscii() == 1 ? "7bit" : "base64";
        }
        return string;
    }

    public static InputStream decode(InputStream inputStream, String string) throws MessagingException {
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64DecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode")) {
            return new UUDecoderStream(inputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return inputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static OutputStream encode(OutputStream outputStream, String string) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode")) {
            return new UUEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static OutputStream encode(OutputStream outputStream, String string, String string2) throws MessagingException {
        if (string == null) {
            return outputStream;
        }
        if (string.equalsIgnoreCase("base64")) {
            return new BASE64EncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("quoted-printable")) {
            return new QPEncoderStream(outputStream);
        }
        if (string.equalsIgnoreCase("uuencode") || string.equalsIgnoreCase("x-uuencode")) {
            return new UUEncoderStream(outputStream, string2);
        }
        if (string.equalsIgnoreCase("binary") || string.equalsIgnoreCase("7bit") || string.equalsIgnoreCase("8bit")) {
            return outputStream;
        }
        throw new MessagingException("Unknown encoding: " + string);
    }

    public static String encodeText(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeText(string, null, null);
    }

    public static String encodeText(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, false);
    }

    public static String decodeText(String string) throws UnsupportedEncodingException {
        String string2 = " \t\n\r";
        if (string.indexOf("=?") == -1) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            char c2 = string4.charAt(0);
            if (c2 == ' ' || c2 == '\t' || c2 == '\r' || c2 == '\n') {
                stringBuffer2.append(c2);
                continue;
            }
            try {
                string3 = MimeUtility.decodeWord(string4);
                if (!bl && stringBuffer2.length() > 0) {
                    stringBuffer.append((Object)stringBuffer2);
                }
                bl = true;
            }
            catch (ParseException parseException) {
                string3 = string4;
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append((Object)stringBuffer2);
                }
                bl = false;
            }
            stringBuffer.append(string3);
            stringBuffer2.setLength(0);
        }
        return stringBuffer.toString();
    }

    public static String encodeWord(String string) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, null, null);
    }

    public static String encodeWord(String string, String string2, String string3) throws UnsupportedEncodingException {
        return MimeUtility.encodeWord(string, string2, string3, true);
    }

    private static String encodeWord(String string, String string2, String string3, boolean bl) throws UnsupportedEncodingException {
        boolean bl2;
        String string4;
        if (MimeUtility.checkAscii(string) == 1) {
            return string;
        }
        if (string2 == null) {
            string4 = MimeUtility.getDefaultJavaCharset();
            string2 = MimeUtility.getDefaultMIMECharset();
        } else {
            string4 = MimeUtility.javaCharset(string2);
        }
        if (string3 == null) {
            byte[] byArray = string.getBytes(string4);
            string3 = MimeUtility.checkAscii(byArray) != 3 ? "Q" : "B";
        }
        if (string3.equalsIgnoreCase("B")) {
            bl2 = true;
        } else if (string3.equalsIgnoreCase("Q")) {
            bl2 = false;
        } else {
            throw new UnsupportedEncodingException("Unknown transfer encoding: " + string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        MimeUtility.doEncode(string, bl2, string4, 68 - string2.length(), "=?" + string2 + "?" + string3 + "?", true, bl, stringBuffer);
        return stringBuffer.toString();
    }

    private static void doEncode(String string, boolean bl, String string2, int n2, String string3, boolean bl2, boolean bl3, StringBuffer stringBuffer) throws UnsupportedEncodingException {
        int n3;
        byte[] byArray = string.getBytes(string2);
        int n4 = bl ? BEncoderStream.encodedLength(byArray) : QEncoderStream.encodedLength(byArray, bl3);
        if (n4 > n2 && (n3 = string.length()) > 1) {
            MimeUtility.doEncode(string.substring(0, n3 / 2), bl, string2, n2, string3, bl2, bl3, stringBuffer);
            MimeUtility.doEncode(string.substring(n3 / 2, n3), bl, string2, n2, string3, false, bl3, stringBuffer);
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FilterOutputStream filterOutputStream = bl ? new BEncoderStream(byteArrayOutputStream) : new QEncoderStream((OutputStream)byteArrayOutputStream, bl3);
        try {
            ((OutputStream)filterOutputStream).write(byArray);
            ((OutputStream)filterOutputStream).close();
        }
        catch (IOException iOException) {}
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        if (!bl2) {
            stringBuffer.append("\r\n ");
        }
        stringBuffer.append(string3);
        int n5 = 0;
        while (n5 < byArray2.length) {
            stringBuffer.append((char)byArray2[n5]);
            ++n5;
        }
        stringBuffer.append("?=");
    }

    public static String decodeWord(String string) throws ParseException, UnsupportedEncodingException {
        if (!string.startsWith("=?")) {
            throw new ParseException();
        }
        int n2 = 2;
        int n3 = string.indexOf(63, n2);
        if (n3 == -1) {
            throw new ParseException();
        }
        String string2 = MimeUtility.javaCharset(string.substring(n2, n3));
        n2 = n3 + 1;
        if ((n3 = string.indexOf(63, n2)) == -1) {
            throw new ParseException();
        }
        String string3 = string.substring(n2, n3);
        n2 = n3 + 1;
        if ((n3 = string.indexOf("?=", n2)) == -1) {
            throw new ParseException();
        }
        String string4 = string.substring(n2, n3);
        try {
            FilterInputStream filterInputStream;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ASCIIUtility.getBytes(string4));
            if (string3.equalsIgnoreCase("B")) {
                filterInputStream = new BASE64DecoderStream(byteArrayInputStream);
            } else if (string3.equalsIgnoreCase("Q")) {
                filterInputStream = new QDecoderStream(byteArrayInputStream);
            } else {
                throw new UnsupportedEncodingException("unknown encoding: " + string3);
            }
            int n4 = byteArrayInputStream.available();
            byte[] byArray = new byte[n4];
            n4 = ((InputStream)filterInputStream).read(byArray, 0, n4);
            return new String(byArray, 0, n4, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
        catch (IOException iOException) {
            throw new ParseException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedEncodingException();
        }
    }

    public static String quote(String string, String string2) {
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            if (c2 == '\"' || c2 == '\\' || c2 == '\r' || c2 == '\n') {
                StringBuffer stringBuffer = new StringBuffer(n2 + 3);
                stringBuffer.append('\"');
                int n4 = 0;
                while (n4 < n2) {
                    char c3 = string.charAt(n4);
                    if (c3 == '\"' || c3 == '\\' || c3 == '\r' || c3 == '\n') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c3);
                    ++n4;
                }
                stringBuffer.append('\"');
                return stringBuffer.toString();
            }
            if (c2 < ' ' || c2 >= '\u007f' || string2.indexOf(c2) >= 0) {
                bl = true;
            }
            ++n3;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n2 + 2);
            stringBuffer.append('\"').append(string).append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    public static String javaCharset(String string) {
        if (mime2java == null || string == null) {
            return string;
        }
        String string2 = (String)mime2java.get(string.toLowerCase());
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String mimeCharset(String string) {
        if (java2mime == null || string == null) {
            return string;
        }
        String string2 = (String)java2mime.get(string.toLowerCase());
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public static String getDefaultJavaCharset() {
        block2: {
            if (defaultJavaCharset != null) break block2;
            try {
                defaultJavaCharset = System.getProperty("file.encoding", "8859_1");
            }
            catch (SecurityException securityException) {
                InputStreamReader inputStreamReader = new InputStreamReader(new 1.NullInputStream());
                defaultJavaCharset = inputStreamReader.getEncoding();
                if (defaultJavaCharset != null) break block2;
                defaultJavaCharset = "8859_1";
            }
        }
        return defaultJavaCharset;
    }

    static String getDefaultMIMECharset() {
        if (defaultMIMECharset == null) {
            defaultMIMECharset = System.getProperty("mail.mime.charset");
        }
        if (defaultMIMECharset == null) {
            defaultMIMECharset = MimeUtility.mimeCharset(MimeUtility.getDefaultJavaCharset());
        }
        return defaultMIMECharset;
    }

    private static void loadMappings(LineInputStream lineInputStream, Hashtable hashtable) {
        while (true) {
            String string;
            try {
                string = lineInputStream.readLine();
            }
            catch (IOException iOException) {
                return;
            }
            if (string == null || string.startsWith("--") && string.endsWith("--")) break;
            if (string.trim().length() == 0 || string.startsWith("#")) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            try {
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                hashtable.put(string2.toLowerCase(), string3);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    static int checkAscii(String string) {
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            if (MimeUtility.nonascii(string.charAt(n3))) {
                return 3;
            }
            ++n3;
        }
        return 1;
    }

    static int checkAscii(byte[] byArray) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length) {
            if (MimeUtility.nonascii(byArray[n4] & 0xFF)) {
                ++n3;
            } else {
                ++n2;
            }
            ++n4;
        }
        if (n3 == 0) {
            return 1;
        }
        if (n2 > n3) {
            return 2;
        }
        return 3;
    }

    static int checkAscii(InputStream inputStream, int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 4096;
        int n6 = 0;
        boolean bl2 = false;
        byte[] byArray = null;
        if (n2 != 0) {
            n5 = n2 == -1 ? 4096 : Math.min(n2, 4096);
            byArray = new byte[n5];
        }
        while (n2 != 0) {
            int n7;
            try {
                n7 = inputStream.read(byArray, 0, n5);
                if (n7 == -1) break;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = byArray[n8] & 0xFF;
                    if (n9 == 13 || n9 == 10) {
                        n6 = 0;
                    } else if (++n6 > 998) {
                        bl2 = true;
                    }
                    if (MimeUtility.nonascii(n9)) {
                        if (bl) {
                            return 3;
                        }
                        ++n4;
                    } else {
                        ++n3;
                    }
                    ++n8;
                }
            }
            catch (IOException iOException) {
                break;
            }
            if (n2 == -1) continue;
            n2 -= n7;
        }
        if (n2 == 0 && bl) {
            return 3;
        }
        if (n4 == 0) {
            if (bl2) {
                return 2;
            }
            return 1;
        }
        if (n3 > n4) {
            return 2;
        }
        return 3;
    }

    private static final boolean nonascii(int n2) {
        return n2 >= 127 || n2 < 32 && n2 != 13 && n2 != 10 && n2 != 9;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        InputStream inputStream = (class$javax$mail$internet$MimeUtility != null ? class$javax$mail$internet$MimeUtility : (class$javax$mail$internet$MimeUtility = MimeUtility.class$("javax.mail.internet.MimeUtility"))).getResourceAsStream("/META-INF/javamail.charset.map");
        if (inputStream != null) {
            inputStream = new LineInputStream(inputStream);
            java2mime = new Hashtable(20);
            MimeUtility.loadMappings((LineInputStream)inputStream, java2mime);
            mime2java = new Hashtable(10);
            MimeUtility.loadMappings((LineInputStream)inputStream, mime2java);
        }
    }
}

