/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;

class AsciiOutputStream
extends OutputStream {
    private boolean breakOnNonAscii;
    private int ascii;
    private int non_ascii;
    private int linelen;
    private boolean longLine = false;
    private int ret;

    public AsciiOutputStream(boolean bl) {
        this.breakOnNonAscii = bl;
    }

    public void write(int n2) throws IOException {
        this.check(n2);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        n3 += n2;
        int n4 = n2;
        while (n4 < n3) {
            this.check(byArray[n4]);
            ++n4;
        }
    }

    private final void check(int n2) throws IOException {
        if ((n2 &= 0xFF) == 13 || n2 == 10) {
            this.linelen = 0;
        } else {
            ++this.linelen;
            if (this.linelen > 998) {
                this.longLine = true;
            }
        }
        if (n2 > 127) {
            ++this.non_ascii;
            if (this.breakOnNonAscii) {
                this.ret = 3;
                throw new EOFException();
            }
        } else {
            ++this.ascii;
        }
    }

    public int getAscii() {
        if (this.ret != 0) {
            return this.ret;
        }
        if (this.non_ascii == 0) {
            if (this.longLine) {
                return 2;
            }
            return 1;
        }
        if (this.ascii > this.non_ascii) {
            return 2;
        }
        return 3;
    }
}

