/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import com.sun.mail.util.LineInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class UUDecoderStream
extends FilterInputStream {
    private String name;
    private int mode;
    private byte[] buffer;
    private int bufsize;
    private int index;
    private boolean gotPrefix = false;
    private LineInputStream lin;

    public UUDecoderStream(InputStream inputStream) {
        super(inputStream);
        this.lin = new LineInputStream(inputStream);
        this.buffer = new byte[45];
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.readPrefix();
            if (!this.decode()) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        try {
            n4 = 0;
            while (n4 < n3) {
                int n5 = this.read();
                if (n5 == -1) {
                    if (n4 == 0) {
                        n4 = -1;
                    }
                    break;
                }
                byArray[n2 + n4] = (byte)n5;
                ++n4;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        return n4;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    public String getName() throws IOException {
        this.readPrefix();
        return this.name;
    }

    public int getMode() throws IOException {
        this.readPrefix();
        return this.mode;
    }

    private void readPrefix() throws IOException {
        String string;
        if (this.gotPrefix) {
            return;
        }
        do {
            if ((string = this.lin.readLine()) != null) continue;
            throw new IOException("UUDecoder error: No Begin");
        } while (!string.regionMatches(true, 0, "begin", 0, 5));
        this.mode = Integer.parseInt(string.substring(6, 9));
        this.name = string.substring(10);
        this.gotPrefix = true;
    }

    private boolean decode() throws IOException {
        this.bufsize = 0;
        String string = this.lin.readLine();
        if (string == null) {
            throw new IOException("Missing End");
        }
        if (string.regionMatches(true, 0, "end", 0, 3)) {
            return false;
        }
        if (string.length() < 1) {
            throw new IOException("Short buffer error");
        }
        int n2 = string.charAt(0);
        if (n2 < 32 || n2 > 77) {
            throw new IOException("Buffer format error");
        }
        if ((n2 = n2 - 32 & 0x3F) == 0) {
            string = this.lin.readLine();
            if (string == null || !string.regionMatches(true, 0, "end", 0, 3)) {
                throw new IOException("Missing End");
            }
            return false;
        }
        int n3 = (n2 * 8 + 5) / 6;
        if (string.length() < n3 + 1) {
            throw new IOException("Short buffer error");
        }
        int n4 = 1;
        while (this.bufsize < n2) {
            byte by = (byte)(string.charAt(n4++) - 32 & 0x3F);
            byte by2 = (byte)(string.charAt(n4++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (this.bufsize < n2) {
                by = by2;
                by2 = (byte)(string.charAt(n4++) - 32 & 0x3F);
                this.buffer[this.bufsize++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            }
            if (this.bufsize >= n2) continue;
            by = by2;
            by2 = (byte)(string.charAt(n4++) - 32 & 0x3F);
            this.buffer[this.bufsize++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
        }
        return true;
    }
}

