/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Properties;

public class SocketFetcher
implements Runnable {
    private Socket socket;
    private String host;
    private int port;
    private Properties props;
    private String prefix;
    private int cto;
    private IOException exception;
    private boolean aborted = false;
    private boolean done = false;
    static /* synthetic */ Class class$java$lang$String;

    private SocketFetcher(String string, int n2, Properties properties, String string2, int n3) throws IOException {
        this.host = string;
        this.port = n2;
        this.props = properties;
        this.prefix = string2;
        this.cto = n3;
    }

    public static Socket getSocket(String string, int n2, Properties properties, String string2) throws IOException {
        if (string2 == null) {
            string2 = "socket";
        }
        if (properties == null) {
            properties = new Properties();
        }
        String string3 = properties.getProperty(String.valueOf(string2) + ".connectiontimeout", null);
        int n3 = -1;
        if (string3 != null) {
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n3 > 0) {
            SocketFetcher socketFetcher = new SocketFetcher(string, n2, properties, string2, n3);
            try {
                Thread thread = new Thread((Runnable)socketFetcher, "Connection thread for host " + string);
                thread.start();
            }
            catch (Exception exception) {
                return SocketFetcher.getSocket0(string, n2, properties, string2);
            }
            return socketFetcher.getSocket();
        }
        return SocketFetcher.getSocket0(string, n2, properties, string2);
    }

    private static Socket getSocket0(String string, int n2, Properties properties, String string2) throws IOException {
        Socket socket = null;
        String string3 = properties.getProperty(String.valueOf(string2) + ".socketFactory.class", null);
        String string4 = properties.getProperty(String.valueOf(string2) + ".timeout", null);
        if (string3 == null || string3.length() <= 0) {
            socket = new Socket(string, n2);
        } else {
            String string5 = properties.getProperty(String.valueOf(string2) + ".socketFactory.fallback", null);
            boolean bl = string5 == null || !string5.equalsIgnoreCase("false");
            String string6 = properties.getProperty(String.valueOf(string2) + ".socketFactory.port", null);
            int n3 = -1;
            if (string6 != null) {
                try {
                    n3 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            try {
                Class<?> clazz = Class.forName(string3);
                Method method = clazz.getMethod("getDefault", new Class[0]);
                Object object = method.invoke(new Object(), new Object[0]);
                Class[] classArray = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = SocketFetcher.class$("java.lang.String")), Integer.TYPE};
                Method method2 = clazz.getMethod("createSocket", classArray);
                Integer n4 = new Integer(n3 != -1 ? n3 : n2);
                Object[] objectArray = new Object[]{string, n4};
                socket = (Socket)method2.invoke(object, objectArray);
            }
            catch (Exception exception) {
                if (bl) {
                    socket = new Socket(string, n2);
                }
                throw new IOException("Couldn't connect using \"" + string3 + "\" socket factory to host, port: " + string + ", " + n3 + "; Exception: " + exception);
            }
        }
        int n5 = -1;
        if (string4 != null) {
            try {
                n5 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n5 >= 0) {
            socket.setSoTimeout(n5);
        }
        return socket;
    }

    private synchronized Socket getSocket() throws IOException {
        if (!this.done) {
            try {
                long l2 = System.currentTimeMillis();
                long l3 = l2 + (long)this.cto;
                while (l2 < l3) {
                    this.wait(l3 - l2);
                    if (!this.done) {
                        l2 = System.currentTimeMillis();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                this.exception = new InterruptedIOException(interruptedException.toString());
            }
        }
        if (this.exception != null) {
            this.aborted = true;
            throw this.exception;
        }
        if (this.socket == null) {
            this.aborted = true;
            throw new ConnectException("connection to " + this.host + " timed out");
        }
        Socket socket = this.socket;
        this.socket = null;
        return socket;
    }

    public void run() {
        try {
            Socket socket = SocketFetcher.getSocket0(this.host, this.port, this.props, this.prefix);
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                if (this.aborted) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    this.socket = socket;
                }
                this.done = true;
                this.notify();
                return;
            }
        }
        catch (IOException iOException) {
            SocketFetcher socketFetcher = this;
            synchronized (socketFetcher) {
                this.exception = iOException;
                this.done = true;
                this.notify();
                return;
            }
        }
    }

    protected synchronized void finalize() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

