/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class TaggedProperties {
    private Properties m_properties;

    public TaggedProperties(Properties properties) {
        this.m_properties = properties;
    }

    public String[] getTags(String prefix) {
        HashSet<String> tags = new HashSet<String>();
        int lprefix = prefix.length();
        Iterator iter = ((Hashtable)this.m_properties).keySet().iterator();
        while (iter.hasNext()) {
            int tagstart;
            int tagend;
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            String tag = null;
            if (key.length() >= lprefix + 2 && key.charAt(lprefix) == '[' && (tagend = key.indexOf(93, tagstart = lprefix + 1)) != -1) {
                tag = key.substring(tagstart, tagend);
            }
            tags.add(tag);
        }
        return tags.toArray(new String[tags.size()]);
    }

    public Properties getProperties(String prefix, String tag) {
        if (tag != null) {
            return this.getTaggedProperties(prefix, tag);
        }
        return this.getUntaggedProperties(prefix);
    }

    private Properties getTaggedProperties(String prefix, String tag) {
        String searchkey = prefix + "[" + tag + "]";
        int lsearchkey = searchkey.length();
        Properties properties = new Properties();
        Iterator iter = ((Hashtable)this.m_properties).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(searchkey)) continue;
            String filteredkey = null;
            filteredkey = key.length() > lsearchkey ? this.stripLeadingDot(key.substring(lsearchkey)) : "";
            ((Hashtable)properties).put(filteredkey, this.m_properties.getProperty(key));
        }
        return properties;
    }

    private Properties getUntaggedProperties(String prefix) {
        int lprefix = prefix.length();
        Properties properties = new Properties();
        Iterator iter = ((Hashtable)this.m_properties).keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith(prefix)) continue;
            if (key.length() == lprefix) {
                ((Hashtable)properties).put("", this.m_properties.getProperty(key));
                continue;
            }
            String suffix = key.substring(lprefix);
            if (this.isTagged(suffix)) continue;
            ((Hashtable)properties).put(this.stripLeadingDot(suffix), this.m_properties.getProperty(key));
        }
        return properties;
    }

    private boolean isTagged(String suffix) {
        int openBracketIdx = suffix.indexOf(91);
        int closeBracketIdx = suffix.indexOf(93);
        if (openBracketIdx == -1 || closeBracketIdx == -1) {
            return false;
        }
        return openBracketIdx < closeBracketIdx;
    }

    private String stripLeadingDot(String s) {
        String out = null;
        out = s.startsWith(".") ? (s.length() > 1 ? s.substring(1) : "") : s;
        return out;
    }
}

