/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.util;

import com.sap.mw.jco.IMetaData;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.util.TaggedProperties;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;

public class SAPBasis {
    public static final RuntimePermission PERM_GET_PROPERTIES = new RuntimePermission("com.sap.security.util.SAPBasis.getProperties()");
    public static final String VERSION = "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/util/SAPBasis.java#1 $ from $DateTime: 2004/03/08 16:48:25 $ ($Change: 14740 $)";
    public static final int DEFAULT_POOL_SIZE = 3;
    public static final long DEFAULT_WAIT_TIME = 10000L;
    private static final PoolManager POOLMANAGER = new PoolManager();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$util$SAPBasis == null ? (class$com$sap$security$util$SAPBasis = SAPBasis.class$("com.sap.security.util.SAPBasis")) : class$com$sap$security$util$SAPBasis));
    private static final Category CATEGORY = Category.getCategory((String)"/Security/SAPBasis");
    private static final Map INSTANCES = new HashMap();
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private IRepository m_repository;
    private JCO.Client m_poolMaster;
    private String m_poolID;
    private boolean m_acceptsTickets;
    private boolean m_createsTickets;
    private boolean m_sncEnabled;
    private int m_poolMaxSize;
    private long m_poolMaxWait;
    private String m_systemID;
    private String m_clientID;
    private final Properties m_properties = new Properties();
    static /* synthetic */ Class class$com$sap$security$util$SAPBasis;

    public SAPBasis(Properties pSapBasis) {
        String value = pSapBasis.getProperty("snc_mode");
        if (value != null && !"".equals(value)) {
            this.m_sncEnabled = "1".equals(value);
        }
        if ((value = pSapBasis.getProperty("acceptticket")) != null && !"".equals(value)) {
            this.m_acceptsTickets = "1".equals(value);
        }
        if ((value = pSapBasis.getProperty("createticket")) != null && !"".equals(value)) {
            this.m_createsTickets = "1".equals(value);
        }
        if ((value = pSapBasis.getProperty("poolmaxsize")) != null && !"".equals(value)) {
            try {
                this.m_poolMaxSize = Integer.parseInt(value);
            }
            catch (Exception e) {
                LOCATION.warningT(SAPBasis.t2s(e));
                this.m_poolMaxSize = 3;
            }
        } else {
            this.m_poolMaxSize = 3;
        }
        if ((value = pSapBasis.getProperty("poolmaxwait")) != null && !"".equals(value)) {
            try {
                this.m_poolMaxWait = Long.parseLong(value);
            }
            catch (Exception e) {
                LOCATION.warningT(SAPBasis.t2s(e));
                this.m_poolMaxWait = 10000L;
            }
        } else {
            this.m_poolMaxWait = 10000L;
        }
        Properties pJco = this.getJcoProperties(pSapBasis);
        this.m_poolMaster = JCO.createClient((Properties)pJco);
        this.m_poolID = "SAPBasis" + RANDOM.nextInt();
        POOLMANAGER.addPool(this.m_poolID, this.m_poolMaster, this.m_poolMaxSize);
        POOLMANAGER.getPool(this.m_poolID).setMaxWaitTime(this.m_poolMaxWait);
        this.m_repository = new Repository("Repository", this.m_poolID);
        JCO.Client client = null;
        try {
            client = POOLMANAGER.getClient(this.m_poolID);
            this.m_systemID = client.getAttributes().getSystemID();
            this.m_clientID = client.getAttributes().getClient();
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                POOLMANAGER.releaseClient(client);
            }
            catch (Exception e) {
                LOCATION.errorT(SAPBasis.t2s(e));
            }
            throw throwable;
        }
        try {
            POOLMANAGER.releaseClient(client);
        }
        catch (Exception e) {
            LOCATION.errorT(SAPBasis.t2s(e));
        }
        ((Hashtable)this.m_properties).putAll(pSapBasis);
    }

    public JCO.Client getClient() {
        return POOLMANAGER.getClient(this.m_poolID);
    }

    public IRepository getRepository() {
        return this.m_repository;
    }

    public void releaseClient(JCO.Client client) {
        if (null != client) {
            try {
                POOLMANAGER.releaseClient(client);
            }
            catch (Exception e) {
                LOCATION.errorT(SAPBasis.t2s(e));
            }
        }
    }

    public String getSystemID() {
        return this.m_systemID;
    }

    public String getClientID() {
        return this.m_clientID;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName() + ":");
        JCO.Pool pool = POOLMANAGER.getPool(this.m_poolID);
        String num_used = pool != null ? String.valueOf(pool.getNumUsed()) : "n/a";
        String max_used = pool != null ? String.valueOf(pool.getMaxUsed()) : "n/a";
        sb.append("\n   System ID:                  " + this.m_systemID);
        sb.append("\n   Client ID:                  " + this.m_clientID);
        sb.append("\n   Pool ID:                    " + this.m_poolID);
        sb.append("\n   Max. pool size:             " + this.m_poolMaxSize);
        sb.append("\n   Currently used clients:     " + num_used);
        sb.append("\n   Max. used clients so far:   " + max_used);
        sb.append("\n   Max. wait time for clients: " + this.m_poolMaxWait + "ms\n");
        return sb.toString();
    }

    public JCO.PoolManager getPoolManager() {
        return POOLMANAGER;
    }

    public String getPoolID() {
        return this.m_poolID;
    }

    public boolean acceptsTickets() {
        return this.m_acceptsTickets;
    }

    public boolean createsTickets() {
        return this.m_createsTickets;
    }

    public boolean isSncEnabled() {
        return this.m_sncEnabled;
    }

    public Properties getProperties() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERM_GET_PROPERTIES);
        }
        Properties p = new Properties();
        ((Hashtable)p).putAll(this.m_properties);
        return p;
    }

    public static SAPBasis getSAPBasis() {
        return SAPBasis.getSAPBasis(null);
    }

    public static synchronized void unregisterAll() {
        String method = "unregisterAll()";
        LOCATION.entering(CATEGORY, "unregisterAll()");
        INSTANCES.clear();
        LOCATION.exiting();
    }

    protected void finalize() {
        POOLMANAGER.removePool(this.m_poolID);
    }

    public static SAPBasis getSAPBasis(String key) {
        String method = "getSAPBasis(String)";
        LOCATION.entering(CATEGORY, "getSAPBasis(String)", new Object[]{key});
        Map map = INSTANCES;
        synchronized (map) {
            LOCATION.exiting();
            SAPBasis sAPBasis = (SAPBasis)INSTANCES.get(key);
            return sAPBasis;
        }
    }

    private Properties getJcoProperties(Properties p) {
        Properties pJco = new Properties();
        Iterator iter = ((Hashtable)p).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            pJco.setProperty("jco.client." + entry.getKey(), (String)entry.getValue());
        }
        return pJco;
    }

    public static synchronized void init(Properties p, String instance_id) throws Exception {
        String method = "init(Properties,String)";
        try {
            LOCATION.entering(CATEGORY, "init(Properties,String)", new Object[]{p, instance_id});
            HashMap<String, SAPBasis> instances = new HashMap<String, SAPBasis>();
            TaggedProperties pTagged = new TaggedProperties(p);
            if (instance_id != null) {
                ((Hashtable)p).putAll(pTagged.getProperties("clusterelement", instance_id));
                pTagged = new TaggedProperties(p);
                StringWriter sw = new StringWriter();
                p.list(new PrintWriter(sw));
                LOCATION.debugT(CATEGORY, "init(Properties,String)", "Replaced global with instance-specific data:\n" + sw.toString());
            }
            String[] tags = pTagged.getTags("sapbasis");
            int i = 0;
            while (i < tags.length) {
                Properties pInstance = pTagged.getProperties("sapbasis", tags[i]);
                instances.put(tags[i], new SAPBasis(pInstance));
                LOCATION.infoT(CATEGORY, "init(Properties,String)", "Initialization of SAPBasis [" + tags[i] + "] successful");
                ++i;
            }
            INSTANCES.putAll(instances);
            LOCATION.exiting();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            LOCATION.errorT(CATEGORY, "init(Properties,String)", sw.toString());
            throw e;
        }
    }

    private static String t2s(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Repository
    extends JCO.Repository {
        public Repository(String key, String poolID) {
            super(key, new String[]{SAPBasis.this.m_poolID});
        }

        public IMetaData queryFunctionInterface(String function_name, String pool_name) {
            JCO.Client client = null;
            IMetaData meta = null;
            try {
                client = POOLMANAGER.getClient(pool_name);
                meta = this.queryFunctionInterface(client, function_name);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                POOLMANAGER.releaseClient(client);
                throw throwable;
            }
            POOLMANAGER.releaseClient(client);
            return meta;
        }

        public IMetaData queryStructureDefinition(String structure_name, String pool_name) {
            JCO.Client client = null;
            IMetaData meta = null;
            try {
                client = POOLMANAGER.getClient(pool_name);
                meta = this.queryStructureDefinition(client, structure_name);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                POOLMANAGER.releaseClient(client);
                throw throwable;
            }
            POOLMANAGER.releaseClient(client);
            return meta;
        }
    }

    private static class PoolManager
    extends JCO.PoolManager {
    }
}

