/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.wizard;

import com.sap.security.util.PropertiesPersistence;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class WizardModel
extends PropertiesPersistence {
    public static final String DEFAULT_POOL_SIZE = String.valueOf(3);
    public static final String DEFAULT_USER = "SAPJSF";
    private static final int HOST = 0;
    private static final int ROUTER = 1;
    private String user;
    private byte[] crypt_passwd;
    private boolean use_default_user;
    private boolean use_load_balancing;
    private String r3name;
    private String mshost;
    private String group;
    private String ashost;
    private String sysnr;
    private String client;
    private String sap_router_string;
    private boolean auto_detect_ticket;
    private boolean accept_ticket;
    private boolean create_ticket;
    private boolean use_snc;
    private String snc_lib_global;
    private String snc_myname;
    private String snc_partnername;
    private String poolmaxsize;
    private boolean use_default_poolmaxsize;
    private boolean marked_for_activation;
    private long timestamp;
    private char[] passwd;
    private final transient String instance_id;
    private final transient Properties pAdditional = new Properties();

    public void init() {
        this.user = null;
        this.crypt_passwd = null;
        this.use_default_user = true;
        this.use_load_balancing = true;
        this.r3name = null;
        this.mshost = null;
        this.group = null;
        this.ashost = null;
        this.sysnr = null;
        this.sap_router_string = null;
        this.client = null;
        this.auto_detect_ticket = true;
        this.accept_ticket = false;
        this.create_ticket = false;
        this.use_snc = false;
        this.snc_lib_global = null;
        this.snc_myname = null;
        this.snc_partnername = null;
        this.poolmaxsize = null;
        this.use_default_poolmaxsize = true;
        this.passwd = null;
        ((Hashtable)this.pAdditional).clear();
    }

    public WizardModel(String instance_id) {
        if (instance_id == null) {
            throw new NullPointerException("instance_id is null");
        }
        this.instance_id = instance_id;
        this.init();
    }

    public void setUseDefaultServiceUser(boolean useDefault) {
        this.use_default_user = useDefault;
    }

    public boolean getUseDefaultServiceUser() {
        return this.use_default_user;
    }

    public void setServiceUserName(String user) {
        this.user = user;
    }

    public String getServiceUserName() {
        if (this.use_default_user) {
            return DEFAULT_USER;
        }
        return this.user != null ? this.user : "";
    }

    public void setServiceUserPass(char[] pass) {
        this.passwd = pass != null ? (char[])pass.clone() : null;
    }

    public String getServiceUserPass() {
        return this.passwd != null ? new String(this.passwd) : "";
    }

    public void setCryptServiceUserPass(byte[] crypt_passwd) {
        this.crypt_passwd = crypt_passwd != null ? (byte[])crypt_passwd.clone() : null;
    }

    public byte[] getCryptServiceUserPass() {
        return this.crypt_passwd != null ? (byte[])this.crypt_passwd.clone() : new byte[]{};
    }

    public void setUseLoadBalancing(boolean use_load_balancing) {
        this.use_load_balancing = use_load_balancing;
    }

    public boolean getUseLoadBalancing() {
        return this.use_load_balancing;
    }

    public void setR3Name(String r3name) {
        this.r3name = r3name;
    }

    public String getR3Name() {
        return this.r3name != null ? this.r3name : "";
    }

    public void setMsHost(String mshost) {
        this.mshost = mshost;
    }

    public String getMsHost() {
        return this.mshost != null ? this.mshost : "";
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group != null ? this.group : "";
    }

    public void setAsHost(String ashost) {
        this.ashost = ashost;
    }

    public String getAsHost() {
        return this.ashost != null ? this.ashost : "";
    }

    public String getSapRouterString() {
        return this.sap_router_string != null ? this.sap_router_string : "";
    }

    public void setSapRouterString(String sapRouterString) {
        if (sapRouterString != null && !"".equals(sapRouterString) && !sapRouterString.toUpperCase().endsWith("/H/")) {
            sapRouterString = sapRouterString + "/H/";
        }
        this.sap_router_string = sapRouterString;
    }

    public void setSysNr(String sysnr) {
        this.sysnr = sysnr;
    }

    public String getSysNr() {
        return this.sysnr != null ? this.sysnr : "";
    }

    public void setClient(String client) throws Exception {
        this.validateClient(client);
        this.client = client;
    }

    private void validateClient(String client) throws Exception {
        try {
            int nClient = Integer.parseInt(client);
            if (nClient < 0 || nClient > 999) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("sapbasis.client must be an integer in the range 0-999 (was: " + client + ")");
        }
    }

    public String getClient() {
        return this.client != null ? this.client : "";
    }

    public void setUseSnc(boolean use_snc) {
        this.use_snc = use_snc;
    }

    public boolean getUseSnc() {
        return this.use_snc;
    }

    public void setSncMyName(String snc_myname) {
        this.snc_myname = snc_myname;
    }

    public String getSncMyName() {
        return this.snc_myname != null ? this.snc_myname : "";
    }

    public void setSncPartnerName(String snc_partnername) {
        this.snc_partnername = snc_partnername;
    }

    public String getSncPartnerName() {
        return this.snc_partnername != null ? this.snc_partnername : "";
    }

    public void setSncLib(String snc_lib) {
        String key = "clusterelement[" + this.instance_id + "].sapbasis.snc_lib";
        if (snc_lib == null || "".equals(snc_lib)) {
            ((Hashtable)this.pAdditional).remove(key);
        } else {
            this.pAdditional.setProperty(key, snc_lib);
        }
    }

    public String getSncLib() {
        String snc_lib = this.pAdditional.getProperty("clusterelement[" + this.instance_id + "].sapbasis.snc_lib");
        return snc_lib != null ? snc_lib : "";
    }

    public void setSncLibGlobal(String snc_lib_global) {
        this.snc_lib_global = snc_lib_global;
    }

    public String getSncLibGlobal() {
        return this.snc_lib_global != null ? this.snc_lib_global : "";
    }

    public void setAcceptTicket(boolean accept) {
        this.accept_ticket = accept;
    }

    public boolean getAcceptTicket() {
        return this.accept_ticket;
    }

    public void setCreateTicket(boolean create) {
        this.create_ticket = create;
    }

    public boolean getCreateTicket() {
        return this.create_ticket;
    }

    public boolean getAutoDetectTicket() {
        return this.auto_detect_ticket;
    }

    public void setAutoDetectTicket(boolean autoDetect) {
        this.auto_detect_ticket = autoDetect;
    }

    public void setMaxConnections(String poolmaxsize) throws Exception {
        if (poolmaxsize == null) {
            this.use_default_poolmaxsize = true;
        } else {
            this.validateMaxConnections(poolmaxsize);
        }
        this.poolmaxsize = poolmaxsize;
    }

    private void validateMaxConnections(String poolmaxsize) throws Exception {
        try {
            int nPoolmaxsize = Integer.parseInt(poolmaxsize);
            if (!(nPoolmaxsize > 0)) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException nfe) {
            throw new Exception("sapbasis.poolmaxsize must be a positive integer (was: " + poolmaxsize + ")");
        }
    }

    public String getMaxConnections() {
        if (this.use_default_poolmaxsize) {
            return DEFAULT_POOL_SIZE;
        }
        return this.poolmaxsize != null ? this.poolmaxsize : "";
    }

    public boolean getUseDefaultMaxConnections() {
        return this.use_default_poolmaxsize;
    }

    public void setUseDefaultMaxConnections(boolean useDefault) {
        this.use_default_poolmaxsize = useDefault;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public void markForActivation(boolean activate) {
        this.marked_for_activation = activate;
    }

    public boolean isMarkedForActivation() {
        return this.marked_for_activation;
    }

    public String getInstanceId() {
        return this.instance_id;
    }

    protected String getPrefix() {
        return "wizard.";
    }

    public Properties exportR3SecurityProperties() {
        Properties p = new Properties();
        ((Hashtable)p).putAll(this.pAdditional);
        p.setProperty("sapbasis.acceptticket", this.accept_ticket ? "1" : "0");
        p.setProperty("sapbasis.createticket", this.create_ticket ? "1" : "0");
        p.setProperty("sapbasis.user", this.getServiceUserName());
        p.setProperty("sapbasis.client", this.getClient());
        if (this.use_load_balancing) {
            p.setProperty("sapbasis.r3name", this.getR3Name());
            p.setProperty("sapbasis.mshost", this.getSapRouterString() + this.getMsHost());
            p.setProperty("sapbasis.group", this.getGroup());
        } else {
            p.setProperty("sapbasis.ashost", this.getSapRouterString() + this.getAsHost());
            p.setProperty("sapbasis.sysnr", this.getSysNr());
        }
        if (this.use_snc) {
            p.setProperty("sapbasis.snc_mode", "1");
            p.setProperty("sapbasis.snc_myname", this.getSncMyName());
            p.setProperty("sapbasis.snc_partnername", this.getSncPartnerName());
            p.setProperty("sapbasis.snc_lib", this.getSncLibGlobal());
        } else {
            p.setProperty("sapbasis.passwd", this.getServiceUserPass());
        }
        if (!this.use_default_poolmaxsize) {
            p.setProperty("sapbasis.poolmaxsize", this.getMaxConnections());
        }
        return p;
    }

    public void importR3SecurityProperties(Properties p) throws Exception {
        boolean use_default_poolmaxsize;
        boolean use_snc;
        boolean use_load_balancing;
        String key = null;
        String r3name = null;
        String mshost = null;
        String group = null;
        String ashost = null;
        String sysnr = null;
        String saprouterstring = null;
        String user = null;
        String passwd = null;
        String snc_mode = null;
        String snc_lib_global = null;
        String snc_lib = null;
        String snc_myname = null;
        String snc_partnername = null;
        String client = null;
        String acceptticket = null;
        String createticket = null;
        String poolmaxsize = null;
        Properties pAdditional = new Properties();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if ("sapbasis.r3name".equals(key)) {
                r3name = p.getProperty(key);
                continue;
            }
            if ("sapbasis.mshost".equals(key)) {
                mshost = p.getProperty(key);
                continue;
            }
            if ("sapbasis.group".equals(key)) {
                group = p.getProperty(key);
                continue;
            }
            if ("sapbasis.ashost".equals(key)) {
                ashost = p.getProperty(key);
                continue;
            }
            if ("sapbasis.sysnr".equals(key)) {
                sysnr = p.getProperty(key);
                continue;
            }
            if ("sapbasis.user".equals(key)) {
                user = p.getProperty(key);
                continue;
            }
            if ("sapbasis.passwd".equals(key)) {
                passwd = p.getProperty(key);
                continue;
            }
            if ("sapbasis.snc_mode".equals(key)) {
                snc_mode = p.getProperty(key);
                continue;
            }
            if ("sapbasis.snc_lib".equals(key)) {
                snc_lib_global = p.getProperty(key);
                continue;
            }
            if (("clusterelement[" + this.instance_id + "].sapbasis.snc_lib").equals(key)) {
                snc_lib = p.getProperty(key);
                continue;
            }
            if ("sapbasis.snc_myname".equals(key)) {
                snc_myname = p.getProperty(key);
                continue;
            }
            if ("sapbasis.snc_partnername".equals(key)) {
                snc_partnername = p.getProperty(key);
                continue;
            }
            if ("sapbasis.client".equals(key)) {
                client = p.getProperty(key);
                continue;
            }
            if ("sapbasis.acceptticket".equals(key)) {
                acceptticket = p.getProperty(key);
                continue;
            }
            if ("sapbasis.createticket".equals(key)) {
                createticket = p.getProperty(key);
                continue;
            }
            if ("sapbasis.poolmaxsize".equals(key)) {
                poolmaxsize = p.getProperty(key);
                continue;
            }
            pAdditional.setProperty(key, p.getProperty(key));
        }
        if (!(r3name == null || "".equals(r3name) || mshost == null || "".equals(mshost) || group == null || "".equals(group))) {
            use_load_balancing = true;
            String[] hostrouter = this.parseSapRouter(mshost);
            if (hostrouter != null) {
                mshost = hostrouter[0];
                saprouterstring = hostrouter[1];
            }
        } else if (ashost != null && !"".equals(ashost) && sysnr != null && !"".equals(sysnr)) {
            use_load_balancing = false;
            String[] hostrouter = this.parseSapRouter(ashost);
            if (hostrouter != null) {
                ashost = hostrouter[0];
                saprouterstring = hostrouter[1];
            }
        } else {
            throw new Exception("Invalid configuration: " + p + "\none of (sapbasis.ashost & sapbasis.sysnr) or " + "(sapbasis.r3name & sapbasis.mshost & sapbasis.group) " + "must be specified\n");
        }
        if (user != null && !"".equals(user) && snc_mode != null && "1".equals(snc_mode) && (snc_lib != null && !"".equals(snc_lib) || snc_lib_global != null && !"".equals(snc_lib_global)) && snc_myname != null && !"".equals(snc_myname) && snc_partnername != null && !"".equals(snc_partnername)) {
            use_snc = true;
        } else if (user != null && !"".equals(user) && passwd != null && !"".equals(passwd)) {
            use_snc = false;
        } else {
            throw new Exception("Invalid configuration: " + p + "\none of (sapbasis.user & sapbasis.passwd) or" + "(sapbasis.user & sapbasis.snc_mode & sapbasis.snc_myname & " + "sapbasis.snc_partnername & sapbasis.snc_lib) must be specified\n");
        }
        if (client == null || "".equals(client)) {
            throw new Exception("Invalid configuration: " + p + "\nsapbasis.client not specified");
        }
        this.validateClient(client);
        boolean use_default_user = DEFAULT_USER.equalsIgnoreCase(user);
        if (poolmaxsize != null) {
            this.validateMaxConnections(poolmaxsize);
            use_default_poolmaxsize = false;
        } else {
            use_default_poolmaxsize = true;
        }
        this.init();
        this.setAcceptTicket("1".equals(acceptticket));
        this.setAsHost(ashost);
        this.setClient(client);
        this.setCreateTicket("1".equals(createticket));
        this.setGroup(group);
        this.setMaxConnections(poolmaxsize);
        this.setMsHost(mshost);
        this.setR3Name(r3name);
        this.setSapRouterString(saprouterstring);
        this.setServiceUserName(user);
        if (passwd != null) {
            this.setServiceUserPass(passwd.toCharArray());
        } else {
            this.setServiceUserPass(null);
        }
        this.setSncLib(snc_lib);
        this.setSncLibGlobal(snc_lib_global);
        this.setSncMyName(snc_myname);
        this.setSncPartnerName(snc_partnername);
        this.setSysNr(sysnr);
        this.setUseDefaultMaxConnections(use_default_poolmaxsize);
        this.setUseDefaultServiceUser(use_default_user);
        this.setUseLoadBalancing(use_load_balancing);
        this.setUseSnc(use_snc);
        ((Hashtable)this.pAdditional).putAll(pAdditional);
    }

    private String[] parseSapRouter(String input) throws Exception {
        if (input == null) {
            return null;
        }
        String separator = "/H/";
        String[] hostrouter = new String[2];
        int split = input.toUpperCase().lastIndexOf("/H/");
        if (split == -1) {
            hostrouter[0] = input;
            hostrouter[1] = "";
        } else {
            if (split == input.length() - "/H/".length()) {
                throw new Exception("Missing host name at end of SAP Router String " + input);
            }
            hostrouter[0] = input.substring(split + "/H/".length());
            hostrouter[1] = input.substring(0, split);
        }
        return hostrouter;
    }

    public Properties marshal() throws Exception {
        this.timestamp = System.currentTimeMillis();
        Properties p = super.marshal();
        ((Hashtable)p).putAll(this.pAdditional);
        return p;
    }

    public void unmarshal(Properties p) throws Exception {
        this.init();
        try {
            super.unmarshal(p);
        }
        catch (Exception e) {
            this.init();
            throw e;
        }
        Enumeration<?> e = p.propertyNames();
        String prefix = this.getPrefix();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (key.startsWith(prefix)) continue;
            this.pAdditional.setProperty(key, p.getProperty(key));
        }
    }
}

