/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.wizard;

import com.sap.security.um.wizard.WizardModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EventListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class WizardDialog
extends JDialog {
    public static final int FINISH_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private static final String AC_FINISH = "FINISH";
    private static final String AC_CANCEL = "CANCEL";
    private static final String AC_LOAD_BALANCING = "LOAD BALANCING";
    private static final String AC_SINGLE_HOST = "SINGLE HOST";
    private static final String AC_PASSWORD = "PASSWORD";
    private static final String AC_SNC = "SNC";
    private static final String AC_BACK = "BACK";
    private static final String AC_NEXT = "NEXT";
    private static final String AC_SNC_LIB = "AC_SNC_LIB";
    private static final String AC_SNC_LIB_GLOBAL = "AC_SNC_LIB_GLOBAL";
    private static final String[] CARDS = new String[]{"CARD_1", "CARD_2", "CARD_3"};
    private static boolean PACK_FRAME = true;
    private JFileChooser _fileChooser = new JFileChooser();
    private Component _owner;
    private Container _contentPane;
    private WizardModel _model;
    private CardLayout _cardLayout;
    private JPanel _pnlCards;
    private JPanel _pnlButtons;
    private JPanel _pnlStepOne;
    private JPanel _pnlStepTwo;
    private JPanel _pnlStepThree;
    private JButton _btnBack;
    private JButton _btnNext;
    private JButton _btnFinish;
    private JButton _btnCancel;
    private JButton _btnSncLib;
    private JButton _btnSncLibGlobal;
    private JTextField _txtAsHost;
    private JTextField _txtSapRouter;
    private JTextField _txtSysNr;
    private JTextField _txtMsHost;
    private JTextField _txtR3Name;
    private JTextField _txtGroup;
    private JTextField _txtClient;
    private JTextField _txtUser;
    private JTextField _txtSncMyName;
    private JTextField _txtSncPartnerName;
    private JTextField _txtSncLib;
    private JTextField _txtSncLibGlobal;
    private JTextField _txtMaxConnections;
    private JPasswordField _txtPasswd;
    private JRadioButton _rbUsePassword;
    private JRadioButton _rbUseSnc;
    private JRadioButton _rbUseLoadBalancing;
    private JRadioButton _rbUseSingleHost;
    private JCheckBox _cbUseDefaultMaxConnections;
    private JCheckBox _cbSsoAccept;
    private JCheckBox _cbSsoCreate;
    private JCheckBox _cbSsoAutoDetect;
    private JCheckBox _cbUseDefaultUser;
    private int _showingCard = 0;
    private int _selectedOption = 1;
    private EventListener _stepCompleteListener = new StepCompleteListener();
    static /* synthetic */ Class class$com$sap$security$um$wizard$WizardDialog;

    public WizardDialog(Frame owner, WizardModel model) {
        super(owner, "Configuration Wizard", true);
        this._owner = owner;
        this._model = model;
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() throws Exception {
        this._contentPane = this.getContentPane();
        this._contentPane.setLayout(new BorderLayout());
        this._btnBack = new JButton("< Back");
        this._btnBack.setActionCommand(AC_BACK);
        this._btnNext = new JButton("Next >");
        this._btnNext.setActionCommand(AC_NEXT);
        this._btnFinish = new JButton("Finish");
        this._btnFinish.setActionCommand(AC_FINISH);
        this._btnCancel = new JButton("Cancel");
        this._btnCancel.setActionCommand(AC_CANCEL);
        this._pnlButtons = new JPanel();
        this._pnlButtons.setLayout(new FlowLayout());
        this._pnlButtons.add(this._btnBack);
        this._pnlButtons.add(this._btnNext);
        this._pnlButtons.add(this._btnFinish);
        this._pnlButtons.add(this._btnCancel);
        this._contentPane.add("South", this._pnlButtons);
        ActionListener buttonListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WizardDialog.AC_BACK.equals(e.getActionCommand())) {
                    WizardDialog.this._cardLayout.show(WizardDialog.this._pnlCards, CARDS[--WizardDialog.this._showingCard]);
                } else if (WizardDialog.AC_NEXT.equals(e.getActionCommand())) {
                    WizardDialog.this._cardLayout.show(WizardDialog.this._pnlCards, CARDS[++WizardDialog.this._showingCard]);
                } else if (WizardDialog.AC_FINISH.equals(e.getActionCommand())) {
                    WizardDialog.this.finishAction();
                } else {
                    WizardDialog.this.cancelAction();
                }
                WizardDialog.this._btnBack.setEnabled(WizardDialog.this.showBackButton());
                WizardDialog.this._btnNext.setEnabled(WizardDialog.this.showNextButton());
                WizardDialog.this._btnFinish.setEnabled(WizardDialog.this.showFinishButton());
            }
        };
        this._btnBack.addActionListener(buttonListener);
        this._btnNext.addActionListener(buttonListener);
        this._btnCancel.addActionListener(buttonListener);
        this._btnFinish.addActionListener(buttonListener);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                WizardDialog.this.cancelAction();
            }
        });
        this._cardLayout = new CardLayout();
        this._pnlCards = new JPanel();
        this._pnlCards.setLayout(this._cardLayout);
        this.initStepOne();
        this.initStepTwo();
        this.initStepThree();
        this._pnlCards.add((Component)this._pnlStepOne, CARDS[0]);
        this._pnlCards.add((Component)this._pnlStepTwo, CARDS[1]);
        this._pnlCards.add((Component)this._pnlStepThree, CARDS[2]);
        this._cardLayout.show(this._pnlCards, CARDS[0]);
        this.validateShowingCard();
        this._contentPane.add("Center", this._pnlCards);
        this.pack();
    }

    private void initStepOne() {
        this._txtClient = new NumericTextField(this._model.getClient(), 3, "Example: 000");
        NameTextPanel pnlClient = new NameTextPanel("Client", this._txtClient);
        this._txtSapRouter = new CTextField(this._model.getSapRouterString(), "Example: /H/host.domain/S/3294/H/");
        NameTextPanel pnlSapRouter = new NameTextPanel("SAP Router String", this._txtSapRouter);
        CPanel pnlCommon = new CPanel(1, "Common");
        pnlCommon.add(pnlClient);
        pnlCommon.add(pnlSapRouter);
        this._txtR3Name = new UpperCaseTextField(this._model.getR3Name(), 8, "Example: ABC");
        NameTextPanel pnlR3Name = new NameTextPanel("System ID", this._txtR3Name);
        this._txtMsHost = new CTextField(this._model.getMsHost(), "Example: host.domain");
        NameTextPanel pnlMshost = new NameTextPanel("Message Server", this._txtMsHost);
        this._txtGroup = new CTextField(this._model.getGroup(), 20, "Example: PUBLIC");
        NameTextPanel pnlGroup = new NameTextPanel("Logon Group", this._txtGroup);
        final CPanel pnlLoadBalancing = new CPanel(1, "Load Balancing Setup");
        pnlLoadBalancing.add(pnlR3Name);
        pnlLoadBalancing.add(pnlMshost);
        pnlLoadBalancing.add(pnlGroup);
        WizardDialog.recursiveEnable(pnlLoadBalancing, this._model.getUseLoadBalancing());
        this._txtAsHost = new CTextField(this._model.getAsHost(), "Example: host.domain");
        NameTextPanel pnlAshost = new NameTextPanel("Application Server", this._txtAsHost);
        this._txtSysNr = new NumericTextField(this._model.getSysNr(), 2, "Example: 00");
        NameTextPanel pnlSysnr = new NameTextPanel("System Number", this._txtSysNr);
        final CPanel pnlSingleHost = new CPanel(1, "Single Host Setup");
        pnlSingleHost.add(pnlAshost);
        pnlSingleHost.add(pnlSysnr);
        WizardDialog.recursiveEnable(pnlSingleHost, !this._model.getUseLoadBalancing());
        this._rbUseLoadBalancing = new JRadioButton("Load Balancing");
        this._rbUseLoadBalancing.setActionCommand(AC_LOAD_BALANCING);
        this._rbUseLoadBalancing.setSelected(this._model.getUseLoadBalancing());
        this._rbUseLoadBalancing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.recursiveEnable(pnlLoadBalancing, true);
                WizardDialog.recursiveEnable(pnlSingleHost, false);
            }
        });
        this._rbUseLoadBalancing.addChangeListener((ChangeListener)this._stepCompleteListener);
        this._rbUseSingleHost = new JRadioButton("Single Host");
        this._rbUseSingleHost.setActionCommand(AC_SINGLE_HOST);
        this._rbUseSingleHost.setSelected(!this._model.getUseLoadBalancing());
        this._rbUseSingleHost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.recursiveEnable(pnlLoadBalancing, false);
                WizardDialog.recursiveEnable(pnlSingleHost, true);
            }
        });
        this._rbUseSingleHost.addChangeListener((ChangeListener)this._stepCompleteListener);
        ButtonGroup bgLoadBalancing = new ButtonGroup();
        bgLoadBalancing.add(this._rbUseLoadBalancing);
        bgLoadBalancing.add(this._rbUseSingleHost);
        CPanel pnlRadio = new CPanel(1, null);
        pnlRadio.add(this._rbUseLoadBalancing);
        pnlRadio.add(this._rbUseSingleHost);
        this._pnlStepOne = new CPanel(1, "Step 1 of 3: System");
        this._pnlStepOne.add(pnlRadio);
        this._pnlStepOne.add(pnlLoadBalancing);
        this._pnlStepOne.add(pnlSingleHost);
        this._pnlStepOne.add(pnlCommon);
    }

    private void initStepTwo() {
        this._cbUseDefaultUser = new JCheckBox("Use Default", this._model.getUseDefaultServiceUser());
        this._txtUser = new UpperCaseTextField(this._model.getServiceUserName(), 12, "Service User ID");
        NameTextDefaultPanel pnlUid = new NameTextDefaultPanel("User ID", this._txtUser, this._cbUseDefaultUser, "SAPJSF");
        this._txtPasswd = new CPasswordField(this._model.getServiceUserPass(), 8, "Service User Password");
        final NameTextPanel pnlAuthPw = new NameTextPanel("Password", this._txtPasswd);
        WizardDialog.recursiveEnable(pnlAuthPw, !this._model.getUseSnc());
        this._txtSncMyName = new CTextField(this._model.getSncMyName(), "Example: p/secude:CN=J2EE, O=Company, C=US");
        NameTextPanel pnlSncMyname = new NameTextPanel("Java Stack SNC Name", this._txtSncMyName);
        this._txtSncPartnerName = new CTextField(this._model.getSncPartnerName(), "Example: p/secude:CN=ABAP, O=Company, C=US");
        NameTextPanel pnlSncPartnername = new NameTextPanel("ABAP Stack SNC Name", this._txtSncPartnerName);
        this._txtSncLib = new CTextField(this._model.getSncLib(), "can be used to override the default SNC library path for this cluster element");
        NameTextPanel pnlSncLib = new NameTextPanel("SNC Library Path (element " + this._model.getInstanceId() + ")", this._txtSncLib);
        this._btnSncLib = new JButton("...");
        this._btnSncLib.setActionCommand(AC_SNC_LIB);
        this._btnSncLib.setToolTipText("Browse Local File System");
        this._btnSncLib.addActionListener(new FileChooserListener());
        pnlSncLib.add(this._btnSncLib);
        this._txtSncLibGlobal = new CTextField(this._model.getSncLibGlobal(), "Example: /usr/sap/ABC/SYS/exe/run/libsapcrypto.so");
        NameTextPanel pnlSncLibGlobal = new NameTextPanel("SNC Library Path (cluster default)", this._txtSncLibGlobal);
        this._btnSncLibGlobal = new JButton("...");
        this._btnSncLibGlobal.setActionCommand(AC_SNC_LIB_GLOBAL);
        this._btnSncLibGlobal.setToolTipText("Browse Local File System");
        this._btnSncLibGlobal.addActionListener(new FileChooserListener());
        pnlSncLibGlobal.add(this._btnSncLibGlobal);
        final CPanel pnlAuthSnc = new CPanel(1, null);
        pnlAuthSnc.add(pnlSncMyname);
        pnlAuthSnc.add(pnlSncPartnername);
        pnlAuthSnc.add(pnlSncLibGlobal);
        pnlAuthSnc.add(pnlSncLib);
        WizardDialog.recursiveEnable(pnlAuthSnc, this._model.getUseSnc());
        this._rbUsePassword = new JRadioButton("Password");
        this._rbUsePassword.setActionCommand(AC_PASSWORD);
        this._rbUsePassword.setSelected(!this._model.getUseSnc());
        this._rbUsePassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.recursiveEnable(pnlAuthPw, true);
                WizardDialog.recursiveEnable(pnlAuthSnc, false);
            }
        });
        this._rbUsePassword.addChangeListener((ChangeListener)this._stepCompleteListener);
        this._rbUseSnc = new JRadioButton(AC_SNC);
        this._rbUseSnc.setActionCommand(AC_SNC);
        this._rbUseSnc.setSelected(this._model.getUseSnc());
        this._rbUseSnc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WizardDialog.recursiveEnable(pnlAuthPw, false);
                WizardDialog.recursiveEnable(pnlAuthSnc, true);
            }
        });
        this._rbUseSnc.addChangeListener((ChangeListener)this._stepCompleteListener);
        ButtonGroup bgAuthMethod = new ButtonGroup();
        bgAuthMethod.add(this._rbUsePassword);
        bgAuthMethod.add(this._rbUseSnc);
        CPanel pnlAuthMethod = new CPanel(1, "Service User Login Information");
        pnlAuthMethod.add(pnlUid);
        pnlAuthMethod.add(this._rbUsePassword);
        pnlAuthMethod.add(this._rbUseSnc);
        pnlAuthMethod.add(pnlAuthPw);
        pnlAuthMethod.add(pnlAuthSnc);
        this._pnlStepTwo = new CPanel(1, "Step 2 of 3: Authentication");
        this._pnlStepTwo.add(pnlAuthMethod);
    }

    private void initStepThree() {
        this._cbSsoAccept = new JCheckBox("ABAP stack accepts SAP Logon Tickets", this._model.getAcceptTicket());
        this._cbSsoAccept.setEnabled(!this._model.getAutoDetectTicket());
        this._cbSsoCreate = new JCheckBox("ABAP stack creates SAP Logon Tickets", this._model.getCreateTicket());
        this._cbSsoCreate.setEnabled(!this._model.getAutoDetectTicket());
        this._cbSsoAutoDetect = new JCheckBox("Auto-detect", this._model.getAutoDetectTicket());
        this._cbSsoAutoDetect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean enable = !((JCheckBox)e.getSource()).isSelected();
                WizardDialog.this._cbSsoAccept.setEnabled(enable);
                WizardDialog.this._cbSsoCreate.setEnabled(enable);
            }
        });
        CPanel pnlSso = new CPanel(1, "Single Sign-On");
        pnlSso.add(this._cbSsoAutoDetect);
        pnlSso.add(this._cbSsoAccept);
        pnlSso.add(this._cbSsoCreate);
        this._cbUseDefaultMaxConnections = new JCheckBox("Use Default", this._model.getUseDefaultMaxConnections());
        this._txtMaxConnections = new NumericTextField(this._model.getMaxConnections(), 3, "maximum number of simultaneous RFC connections to the ABAP stack");
        NameTextDefaultPanel pnlMaxCon = new NameTextDefaultPanel("Max. connection pool size", this._txtMaxConnections, this._cbUseDefaultMaxConnections, WizardModel.DEFAULT_POOL_SIZE);
        CPanel pnlPerformance = new CPanel(1, "Performance");
        pnlPerformance.add(pnlMaxCon);
        this._pnlStepThree = new CPanel(1, "Step 3 of 3: Advanced");
        this._pnlStepThree.add(pnlSso);
        this._pnlStepThree.add(pnlPerformance);
    }

    private void finishAction() {
        try {
            this._model.setUseLoadBalancing(this._rbUseLoadBalancing.isSelected());
            this._model.setAsHost(this._txtAsHost.getText());
            this._model.setSysNr(this._txtSysNr.getText());
            this._model.setMsHost(this._txtMsHost.getText());
            this._model.setR3Name(this._txtR3Name.getText());
            this._model.setGroup(this._txtGroup.getText());
            this._model.setClient(this._txtClient.getText());
            this._model.setSapRouterString(this._txtSapRouter.getText());
            this._model.setUseDefaultServiceUser(this._cbUseDefaultUser.isSelected());
            this._model.setServiceUserName(this._txtUser.getText());
            this._model.setServiceUserPass(this._txtPasswd.getPassword());
            this._model.setUseSnc(this._rbUseSnc.isSelected());
            this._model.setSncMyName(this._txtSncMyName.getText());
            this._model.setSncPartnerName(this._txtSncPartnerName.getText());
            this._model.setSncLib(this._txtSncLib.getText());
            this._model.setSncLibGlobal(this._txtSncLibGlobal.getText());
            this._model.setAutoDetectTicket(this._cbSsoAutoDetect.isSelected());
            this._model.setAcceptTicket(this._cbSsoAccept.isSelected());
            this._model.setCreateTicket(this._cbSsoCreate.isSelected());
            this._model.setUseDefaultMaxConnections(this._cbUseDefaultMaxConnections.isSelected());
            this._model.setMaxConnections(this._txtMaxConnections.getText());
            this._selectedOption = 0;
            ((Component)this).setVisible(false);
        }
        catch (Exception e) {
            this.showErrorDialog(e);
        }
    }

    private void cancelAction() {
        this._selectedOption = 1;
        ((Component)this).setVisible(false);
    }

    private void showErrorDialog(Throwable t) {
        JTextArea message = new JTextArea(t.toString());
        message.setEditable(false);
        message.setBackground(((Component)this).getBackground());
        message.setFont(this.getFont());
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private boolean isStepOneComplete() {
        return this._txtClient != null && this._txtClient.getText() != null && !"".equals(this._txtClient.getText()) && (this._rbUseLoadBalancing != null && this._rbUseLoadBalancing.isSelected() && this._txtMsHost != null && this._txtMsHost.getText() != null && !"".equals(this._txtMsHost.getText()) && this._txtR3Name != null && this._txtR3Name.getText() != null && !"".equals(this._txtR3Name.getText()) && this._txtGroup != null && this._txtGroup.getText() != null && !"".equals(this._txtGroup.getText()) || this._rbUseSingleHost != null && this._rbUseSingleHost.isSelected() && this._txtAsHost != null && this._txtAsHost.getText() != null && !"".equals(this._txtAsHost.getText()) && this._txtSysNr != null && this._txtSysNr.getText() != null && !"".equals(this._txtSysNr.getText()));
    }

    private boolean isStepTwoComplete() {
        return this._rbUsePassword != null && this._rbUsePassword.isSelected() && this._txtUser != null && this._txtUser.getText() != null && !"".equals(this._txtUser.getText()) && this._txtPasswd != null && this._txtPasswd.getPassword() != null && this._txtPasswd.getPassword().length > 0 || this._rbUseSnc != null && this._rbUseSnc.isSelected() && this._txtSncMyName != null && this._txtSncMyName.getText() != null && !"".equals(this._txtSncMyName.getText()) && this._txtSncPartnerName != null && this._txtSncPartnerName.getText() != null && !"".equals(this._txtSncPartnerName.getText()) && (this._txtSncLib != null && this._txtSncLib.getText() != null && !"".equals(this._txtSncLib.getText()) || this._txtSncLibGlobal != null && this._txtSncLibGlobal.getText() != null && !"".equals(this._txtSncLibGlobal.getText()));
    }

    private boolean isStepThreeComplete() {
        return this._txtMaxConnections != null && this._txtMaxConnections.getText() != null && !"".equals(this._txtMaxConnections.getText());
    }

    private boolean showNextButton() {
        return this._showingCard < CARDS.length - 1 && this._showingCard == 0 && this.isStepOneComplete() || this._showingCard == 1 && this.isStepTwoComplete();
    }

    private boolean showFinishButton() {
        return this._showingCard == CARDS.length - 1 && this.isStepThreeComplete();
    }

    private boolean showBackButton() {
        return this._showingCard > 0;
    }

    private void validateShowingCard() {
        this._btnNext.setEnabled(this.showNextButton());
        this._btnBack.setEnabled(this.showBackButton());
        this._btnFinish.setEnabled(this.showFinishButton());
    }

    public int showWizardDialog() {
        this.setLocationRelativeTo(this._owner);
        this.show();
        return this._selectedOption;
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        JFrame frame = new JFrame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }
        };
        ((Component)frame).setSize(new Dimension(600, 600));
        frame.setTitle("Demo Frame");
        final WizardModel model = new WizardModel("DUMMY_ID");
        try {
            Properties p = new Properties();
            FileInputStream is = null;
            is = new FileInputStream("model.properties");
            p.load(is);
            ((InputStream)is).close();
            model.unmarshal(p);
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("model.properties doesn't exist, starting from scratch");
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        ((Component)frame).setLocation((screenSize.width - frameSize.width) / 2 + 100, (screenSize.height - frameSize.height) / 2 + 100);
        final WizardDialog dialog = new WizardDialog((Frame)frame, model);
        JButton btnImport = new JButton("Import R3Security.properties");
        btnImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    System.out.println("Importing import.properties");
                    Properties pImport = new Properties();
                    FileInputStream is = new FileInputStream("import.properties");
                    pImport.load(is);
                    ((InputStream)is).close();
                    pImport.list(System.out);
                    model.importR3SecurityProperties(pImport);
                    dialog.showWizardDialog();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton btnExport = new JButton("Export R3Security.properties");
        btnExport.addActionListener(new ActionListener(){
            static /* synthetic */ Class class$com$sap$security$um$wizard$WizardDialog;

            public void actionPerformed(ActionEvent e) {
                try {
                    System.out.println("Exporting export.properties");
                    FileOutputStream os = new FileOutputStream("export.properties");
                    Properties pExport = model.exportR3SecurityProperties();
                    pExport.list(System.out);
                    pExport.store(os, "Generated by " + (class$com$sap$security$um$wizard$WizardDialog == null ? (class$com$sap$security$um$wizard$WizardDialog = 10.class$("com.sap.security.um.wizard.WizardDialog")) : class$com$sap$security$um$wizard$WizardDialog).getName());
                    ((OutputStream)os).close();
                    dialog.showWizardDialog();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
        frame.getContentPane().setLayout(new BorderLayout());
        JPanel pnlButtons = new JPanel();
        pnlButtons.setLayout(new FlowLayout());
        pnlButtons.add(btnImport);
        pnlButtons.add(btnExport);
        frame.getContentPane().add("South", pnlButtons);
        ((Component)frame).setVisible(true);
        System.out.println("showPanel() returned " + dialog.showWizardDialog());
        FileOutputStream os = new FileOutputStream("model.properties");
        model.marshal().store(os, "Automatically generated by " + (class$com$sap$security$um$wizard$WizardDialog == null ? (class$com$sap$security$um$wizard$WizardDialog = WizardDialog.class$("com.sap.security.um.wizard.WizardDialog")) : class$com$sap$security$um$wizard$WizardDialog).getName() + " on");
        ((OutputStream)os).close();
    }

    private static void recursiveEnable(Component c, boolean enable) {
        Component[] ac;
        if (c instanceof Container && (ac = ((Container)c).getComponents()) != null) {
            int i = 0;
            while (i < ac.length) {
                WizardDialog.recursiveEnable(ac[i], enable);
                ++i;
            }
        }
        c.setEnabled(enable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class StepCompleteListener
    implements DocumentListener,
    ChangeListener {
        private StepCompleteListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            WizardDialog.this.validateShowingCard();
        }

        public void changedUpdate(DocumentEvent e) {
            WizardDialog.this.validateShowingCard();
        }

        public void removeUpdate(DocumentEvent e) {
            WizardDialog.this.validateShowingCard();
        }

        public void stateChanged(ChangeEvent e) {
            WizardDialog.this.validateShowingCard();
        }
    }

    private class FileChooserListener
    implements ActionListener {
        private FileChooserListener() {
        }

        public void actionPerformed(ActionEvent event) {
            File selectedFile;
            File currentDirectory;
            JTextField target = WizardDialog.AC_SNC_LIB.equals(event.getActionCommand()) ? WizardDialog.this._txtSncLib : WizardDialog.this._txtSncLibGlobal;
            String currentSelection = target.getText();
            if (currentSelection == null) {
                currentSelection = "";
            }
            try {
                currentDirectory = new File(currentSelection).getParentFile();
            }
            catch (Exception e) {
                currentDirectory = new File("/");
            }
            WizardDialog.this._fileChooser.setCurrentDirectory(currentDirectory);
            try {
                selectedFile = new File(currentSelection);
                WizardDialog.this._fileChooser.setSelectedFile(selectedFile);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (0 == WizardDialog.this._fileChooser.showOpenDialog(WizardDialog.this) && (selectedFile = WizardDialog.this._fileChooser.getSelectedFile()) != null) {
                    target.setText(selectedFile.getCanonicalPath());
                }
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                JOptionPane.showMessageDialog(WizardDialog.this, sw.toString(), e.getLocalizedMessage(), 0);
            }
        }
    }

    private class NameTextDefaultPanel
    extends NameTextPanel {
        private final JCheckBox __checkBox;
        private final String __defaultText;

        public NameTextDefaultPanel(String labelText, JTextField textField, JCheckBox cbUseDefault, String defaultText) {
            super(labelText, textField);
            boolean enable;
            this.__defaultText = defaultText;
            this.__checkBox = cbUseDefault;
            this.__checkBox.addActionListener(new ActionListener(this){
                private final /* synthetic */ NameTextDefaultPanel this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    boolean enable;
                    boolean bl = enable = false == NameTextDefaultPanel.access$2200(this.this$1).isSelected();
                    if (!enable) {
                        this.this$1.getTextField().setText(NameTextDefaultPanel.access$2300(this.this$1));
                    }
                    this.this$1.getLabel().setEnabled(enable);
                    this.this$1.getTextField().setEnabled(enable);
                }
            });
            this.add(this.__checkBox);
            boolean bl = enable = false == this.__checkBox.isSelected();
            if (!enable) {
                this.getTextField().setText(this.__defaultText);
            }
            this.getLabel().setEnabled(enable);
            this.getTextField().setEnabled(enable);
        }

        static /* synthetic */ JCheckBox access$2200(NameTextDefaultPanel x0) {
            return x0.__checkBox;
        }

        static /* synthetic */ String access$2300(NameTextDefaultPanel x0) {
            return x0.__defaultText;
        }
    }

    private class NameTextPanel
    extends CPanel {
        private final JLabel __label;
        private final JTextField __textField;

        public NameTextPanel(String labelText, JTextField textField) {
            this.__label = new CLabel(labelText);
            this.__textField = textField;
            this.add(this.__label);
            this.add(this.__textField);
        }

        public JTextField getTextField() {
            return this.__textField;
        }

        public JLabel getLabel() {
            return this.__label;
        }
    }

    private class UpperCaseTextField
    extends CTextField {
        private int __columns = 0;

        UpperCaseTextField(String text, int columns, String toolTipText) {
            super(text, toolTipText);
            this.__columns = columns;
        }

        protected Document createDefaultModel() {
            return new PlainDocument(this){
                private final /* synthetic */ UpperCaseTextField this$1;
                {
                    this.this$1 = this$1;
                }

                public void insertString(int offset, String str, AttributeSet as) throws BadLocationException {
                    if (UpperCaseTextField.access$2100(this.this$1) == 0 || this.getLength() < UpperCaseTextField.access$2100(this.this$1)) {
                        if (str != null) {
                            super.insertString(offset, str.toUpperCase(), as);
                        } else {
                            super.insertString(offset, str, as);
                        }
                    }
                }
            };
        }

        static /* synthetic */ int access$2100(UpperCaseTextField x0) {
            return x0.__columns;
        }
    }

    private class NumericTextField
    extends CTextField {
        private int __columns = 0;

        public NumericTextField(String text, int columns, String toolTipText) {
            super(text, toolTipText);
            this.__columns = columns;
        }

        protected Document createDefaultModel() {
            return new PlainDocument(this){
                private final /* synthetic */ NumericTextField this$1;
                {
                    this.this$1 = this$1;
                }

                public void insertString(int offset, String str, AttributeSet as) throws BadLocationException {
                    if (NumericTextField.access$2000(this.this$1) == 0 || this.getLength() < NumericTextField.access$2000(this.this$1)) {
                        if (str != null) {
                            try {
                                Integer.parseInt(str);
                                super.insertString(offset, str, as);
                            }
                            catch (NumberFormatException e) {}
                        } else {
                            super.insertString(offset, str, as);
                        }
                    }
                }
            };
        }

        static /* synthetic */ int access$2000(NumericTextField x0) {
            return x0.__columns;
        }
    }

    private class CPasswordField
    extends JPasswordField {
        private final int PREF_WIDTH = 200;
        private final Color __enabledColor;
        private final int __columns;

        public CPasswordField(String text, int columns, String toolTipText) {
            super(text);
            this.__columns = columns;
            if (toolTipText != null) {
                this.setToolTipText(toolTipText);
            }
            this.addFocusListener(new FocusListener(this){
                private final /* synthetic */ CPasswordField this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }

                public void focusLost(FocusEvent e) {
                    ((JTextField)e.getSource()).setSelectionEnd(0);
                }
            });
            this.getDocument().addDocumentListener((DocumentListener)WizardDialog.this._stepCompleteListener);
            this.__enabledColor = this.getBackground();
        }

        public Dimension getPreferredSize() {
            return new Dimension(200, super.getPreferredSize().height);
        }

        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.setBackground(enable ? this.__enabledColor : this.getParent().getBackground());
        }

        protected Document createDefaultModel() {
            return new PlainDocument(this){
                private final /* synthetic */ CPasswordField this$1;
                {
                    this.this$1 = this$1;
                }

                public void insertString(int offset, String str, AttributeSet as) throws BadLocationException {
                    if (CPasswordField.access$1900(this.this$1) == 0 || this.getLength() < CPasswordField.access$1900(this.this$1)) {
                        super.insertString(offset, str, as);
                    }
                }
            };
        }

        static /* synthetic */ int access$1900(CPasswordField x0) {
            return x0.__columns;
        }
    }

    private class CTextField
    extends JTextField {
        private final int PREF_WIDTH = 200;
        private final Color __enabledColor;
        private int __columns = 0;

        public CTextField(String text, int columns, String toolTipText) {
            this(text, toolTipText);
            this.__columns = columns;
        }

        public CTextField(String text, String toolTipText) {
            super(text);
            if (toolTipText != null) {
                this.setToolTipText(toolTipText);
            }
            this.addFocusListener(new FocusListener(this){
                private final /* synthetic */ CTextField this$1;
                {
                    this.this$1 = this$1;
                }

                public void focusGained(FocusEvent e) {
                    ((JTextField)e.getSource()).selectAll();
                }

                public void focusLost(FocusEvent e) {
                    ((JTextField)e.getSource()).setSelectionEnd(0);
                }
            });
            this.getDocument().addDocumentListener((DocumentListener)WizardDialog.this._stepCompleteListener);
            this.__enabledColor = this.getBackground();
        }

        protected Document createDefaultModel() {
            return new PlainDocument(this){
                private final /* synthetic */ CTextField this$1;
                {
                    this.this$1 = this$1;
                }

                public void insertString(int offset, String str, AttributeSet as) throws BadLocationException {
                    if (CTextField.access$1800(this.this$1) == 0 || this.getLength() < CTextField.access$1800(this.this$1)) {
                        super.insertString(offset, str, as);
                    }
                }
            };
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.setBackground(enable ? this.__enabledColor : this.getParent().getBackground());
        }

        static /* synthetic */ int access$1800(CTextField x0) {
            return x0.__columns;
        }
    }

    private static class CLabel
    extends JLabel {
        private static int PREF_WIDTH = 200;

        public CLabel() {
        }

        public CLabel(String txt) {
            super(txt);
        }

        public Dimension getPreferredSize() {
            return new Dimension(PREF_WIDTH, super.getPreferredSize().height);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    private static class CPanel
    extends JPanel {
        public CPanel() {
            this.setLayout(new BoxLayout(this, 0));
        }

        public CPanel(int axis, String title) {
            this.setLayout(new BoxLayout(this, axis));
            if (title != null) {
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(title), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            }
        }

        public float getAlignmentX() {
            return 0.0f;
        }

        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, this.getPreferredSize().height);
        }
    }
}

