/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.um.r3.Configuration;
import com.sap.security.um.r3.LoginCheck;
import com.sap.security.um.r3.LoginResult;
import com.sap.security.um.r3.StandAloneUtil;
import com.sap.security.um.r3.Util;
import com.sap.security.usermanagement.AuthenticationFailedException;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.usermanagement.UserLockedException;
import com.sap.security.util.LogUtil;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.Location;
import java.security.cert.CertificateException;

class ServiceUserLoginCheck
implements LoginCheck {
    private static final String M1 = "execSusrCheckLogonData(char,String,String,String,String,String,String)";
    private static final char AM_UIDPW = 'P';
    private static final char AM_CERT = 'X';
    private static final char AM_EXTID = 'E';
    private static final char AM_TICKET = 'T';
    private static final int CHANGE_NEVER = -2;
    private static final int CHANGE_NOT_TODAY = -1;
    private static final int CHANGE_NOT_REQ = 0;
    private static final int CHANGE_REQ_INIT = 1;
    private static final int CHANGE_REQ_EXP = 2;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$um$r3$ServiceUserLoginCheck == null ? (class$com$sap$security$um$r3$ServiceUserLoginCheck = ServiceUserLoginCheck.class$("com.sap.security.um.r3.ServiceUserLoginCheck")) : class$com$sap$security$um$r3$ServiceUserLoginCheck));
    private JCO.Client m_client;
    private IRepository m_repository;
    private JCO.PoolManager m_poolManager;
    private String m_poolID;
    private boolean m_getTicket;
    private LogUtil m_logUtil = new LogUtil(LOCATION, null);
    static /* synthetic */ Class class$com$sap$security$um$r3$ServiceUserLoginCheck;

    ServiceUserLoginCheck(Configuration configuration, boolean getTicket) {
        this.m_poolManager = configuration.poolManager;
        this.m_poolID = configuration.poolID;
        this.m_repository = configuration.repository;
        this.m_getTicket = getTicket;
    }

    ServiceUserLoginCheck(JCO.Client client, IRepository repository, boolean getTicket) {
        this.m_client = client;
        this.m_repository = repository;
        this.m_getTicket = getTicket;
    }

    public ServiceUserLoginCheck(SAPBasis sapBasis) {
        this.m_poolManager = sapBasis.getPoolManager();
        this.m_poolID = sapBasis.getPoolID();
        this.m_repository = sapBasis.getRepository();
        this.m_getTicket = sapBasis.createsTickets();
    }

    public LoginResult checkAliasPassword(String alias, String password, String language) throws AuthenticationFailedException, UserLockedException {
        LoginResult lr = null;
        try {
            lr = this.execSusrCheckLogonData('P', null, alias, password, null, null, language);
        }
        catch (CertificateException e) {
            // empty catch block
        }
        return lr;
    }

    public LoginResult checkUserPassword(String user, String password, String language) throws AuthenticationFailedException, UserLockedException {
        LoginResult lr = null;
        try {
            lr = this.execSusrCheckLogonData('P', user, null, password, null, null, language);
        }
        catch (CertificateException e) {
            // empty catch block
        }
        return lr;
    }

    public LoginResult checkUserCertificate(String user, String b64certificate, String language) throws AuthenticationFailedException, UserLockedException, CertificateException {
        return this.execSusrCheckLogonData('X', user, null, null, b64certificate, null, language);
    }

    public LoginResult checkTicket(String b64ticket) throws AuthenticationFailedException, UserLockedException {
        LoginResult lr = null;
        try {
            lr = this.execSusrCheckLogonData('T', null, null, null, b64ticket, null, null);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        return lr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private LoginResult execSusrCheckLogonData(char authmethod, String userid, String aliasname, String password, String authdata, String extidtype, String language) throws AuthenticationFailedException, UserLockedException, CertificateException {
        JCO.ParameterList exports;
        int pwdstate;
        JCO.Function checklogondata;
        block20: {
            if (LOCATION.bePath()) {
                LOCATION.entering(M1, new Object[]{String.valueOf(authmethod), aliasname, password, authdata, extidtype, language});
            }
            JCO.Client client = null;
            checklogondata = null;
            checklogondata = this.m_repository.getFunctionTemplate("SUSR_CHECK_LOGON_DATA").getFunction();
            JCO.ParameterList imports = checklogondata.getImportParameterList();
            imports.setValue(authmethod, "AUTH_METHOD");
            if (userid != null) {
                imports.setValue(StandAloneUtil.charWiseUpperCase(userid.trim()), "USERID");
            }
            if (password != null) {
                imports.setValue(StandAloneUtil.charWiseUpperCase(password), "PASSWORD");
            }
            if (aliasname != null) {
                imports.setValue(StandAloneUtil.charWiseUpperCase(aliasname.trim()), "ALIASNAME");
            }
            if (authdata != null) {
                if ('T' == authmethod) {
                    authdata = Util.undoReplaceChar(Util.stripLineBreaksAndWhiteSpace(authdata));
                } else if ('X' == authmethod) {
                    authdata = Util.stripLineBreaksAndWhiteSpace(Util.stripCertificateHeaderAndFooter(authdata));
                }
                imports.setValue(authdata, "AUTH_DATA");
            }
            if (extidtype != null) {
                imports.setValue(extidtype, "EXTID_TYPE");
            }
            if (language != null) {
                imports.setValue(StandAloneUtil.charWiseUpperCase(language.trim()), "LANGUAGE");
            }
            try {
                try {
                    client = this.m_poolManager != null ? this.m_poolManager.getClient(this.m_poolID) : this.m_client;
                    client.execute(checklogondata);
                }
                catch (JCO.AbapException ae) {
                    if ("USER_LOCKED".equals(ae.getKey()) || "USER_OUTSIDE_VALIDITY".equals(ae.getKey())) {
                        throw (UserLockedException)this.m_logUtil.logException(new UserLockedException(ae.getKey()), M1);
                    }
                    if ("X509_ENCODING_ERROR".equals(ae.getKey())) {
                        throw (CertificateException)this.m_logUtil.logException(new CertificateException(ae.getKey()), M1);
                    }
                    throw (AuthenticationFailedException)this.m_logUtil.logException(new AuthenticationFailedException(ae.getKey()), M1);
                }
                catch (JCO.Exception je) {
                    throw (UMRuntimeException)this.m_logUtil.logException(new UMRuntimeException(je), M1);
                }
                Object var14_11 = null;
                if (client == null || this.m_poolManager == null) break block20;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                if (client != null && this.m_poolManager != null) {
                    this.m_poolManager.releaseClient(client);
                }
                throw throwable;
            }
            this.m_poolManager.releaseClient(client);
        }
        Boolean pwchangerequired = (pwdstate = (exports = checklogondata.getExportParameterList()).getInt("PWDSTATE")) == 1 || pwdstate == 2 ? Boolean.TRUE : Boolean.FALSE;
        String ticket = null;
        if (this.m_getTicket && !('T' == authmethod) && ((ticket = exports.getString("TICKET")) == null || ticket.equals(""))) {
            RuntimeException re = new RuntimeException("No SAP Logon Ticket received");
            throw (RuntimeException)this.m_logUtil.logException(re, M1);
        }
        String username = exports.getString("USER_ID");
        if ("".equals(username)) {
            username = null;
        }
        return new LoginResult(username, ticket, pwchangerequired);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

