/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.um.r3;

import com.sap.security.Security;
import com.sap.security.toolkit.ds.MostRecentlyUsedCache;
import com.sap.security.um.SSOUser;
import com.sap.security.um.r3.AuthenticationFactory;
import com.sap.security.um.r3.CacheCheck;
import com.sap.security.um.r3.CacheCheckFailedException;
import com.sap.security.um.r3.CacheCheckResult;
import com.sap.security.um.r3.ExceptionLogger;
import com.sap.security.um.r3.R3User;
import com.sap.security.um.r3.R3UserAccount;
import com.sap.security.um.r3.Util;
import com.sap.security.usermanagement.AuthenticationFailedException;
import com.sap.security.usermanagement.IAuthentication;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.IUserAccount;
import com.sap.security.usermanagement.IUserAccountFactory;
import com.sap.security.usermanagement.IUserFactory;
import com.sap.security.usermanagement.MissingLoginParamException;
import com.sap.security.usermanagement.MissingPasswdChangeException;
import com.sap.security.usermanagement.UMException;
import com.sap.security.usermanagement.UMRuntimeException;
import com.sap.security.usermanagement.UserLockedException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class R3Authentication
implements IAuthentication {
    private static final String HOST_NAME = "fullqualifiedhostname";
    private static final String FORWARD_URL = "loginscreenurl";
    private static final String ACTIVATE_LOGIN_FORWARD = "activateloginforward";
    private static final String HTTP_PARAM_USER = "httpparamuser";
    private static final String HTTP_PARAM_ALIAS = "httpparamalias";
    private static final String HTTP_PARAM_PASSWD = "httpparampassword";
    private static final String HTTP_PARAM_NEW_PASSWD1 = "httpparamnewpassword1";
    private static final String HTTP_PARAM_NEW_PASSWD2 = "httpparamnewpassword2";
    private static final String HTTP_PARAM_LANGUAGE = "httpparamlanguage";
    private static final int defEnableCert = 0;
    private static final int defEnablePasswd = 1;
    private static final int defEnableTicket = 0;
    private static final int defCreateTicket = 0;
    private static final String defForwardUrl = "/servlet/com.sap.security.um.r3.LoginServlet";
    private static final String defHttpParamUser = "j_username";
    private static final String defHttpParamAlias = "j_alias";
    private static final String defHttpParamPasswd = "j_password";
    private static final String defHttpParamNewPasswd1 = "j_newpassword1";
    private static final String defHttpParamNewPasswd2 = "j_newpassword2";
    private static final String defHttpParamLanguage = "j_language";
    private static final String defCacheID = "";
    private static final String HTTP_PARAM_ORIGINAL_URL = "j_originalURL";
    private static final String HTTP_PARAM_LOGIN_METHOD = "j_loginmethod";
    private String m_forwardUrl;
    private String m_hostName = null;
    private String m_httpParamUser = null;
    private String m_httpParamAlias;
    private String m_httpParamPasswd;
    private String m_httpParamNewPasswd1;
    private String m_httpParamNewPasswd2;
    private String m_httpParamLanguage;
    private String m_cacheID;
    private int m_enableCert;
    private int m_enablePasswd;
    private int m_enableTicket;
    private int m_createTicket;
    private int m_useUserfactory;
    private int m_activateForward;
    private int m_tolerance;
    private MostRecentlyUsedCache m_cache = null;
    private IUserFactory m_userfactory = null;
    private IUserAccountFactory m_accountfactory = null;
    private Object[] m_languages;
    private CacheCheck m_cacheCheck;
    private Location m_location = Location.getLocation((Class)(class$com$sap$security$um$r3$R3Authentication == null ? (class$com$sap$security$um$r3$R3Authentication = R3Authentication.class$("com.sap.security.um.r3.R3Authentication")) : class$com$sap$security$um$r3$R3Authentication));
    private Category m_category = Category.getCategory((String)"/Security/Authentication");
    private ExceptionLogger m_exlog = new ExceptionLogger(this.m_location, this.m_category, 400);
    private int m_severity = 300;
    private String m_accountfactoryID;
    private String m_userfactoryID;
    static /* synthetic */ Class class$com$sap$security$um$r3$R3Authentication;

    public void initialize(Properties configuration) throws UMException {
        String method = "initialize(java.util.Properties)";
        this.m_location.entering(method, new Object[]{configuration});
        try {
            this.m_enableCert = ((Hashtable)configuration).containsKey("acceptcertificate") && !configuration.getProperty("acceptcertificate").equals(defCacheID) ? Integer.parseInt(configuration.getProperty("acceptcertificate")) : 0;
            this.m_category.logT(100, this.m_location, method, "set: acceptcertificate = " + this.m_enableCert);
            this.m_enablePasswd = ((Hashtable)configuration).containsKey("acceptpassword") && !configuration.getProperty("acceptpassword").equals(defCacheID) ? Integer.parseInt(configuration.getProperty("acceptpassword")) : 1;
            this.m_category.logT(100, this.m_location, method, "set: acceptpassword = " + this.m_enablePasswd);
            this.m_enableTicket = ((Hashtable)configuration).containsKey("acceptticket") && !configuration.getProperty("acceptticket").equals(defCacheID) ? Integer.parseInt(configuration.getProperty("acceptticket")) : 0;
            this.m_category.logT(100, this.m_location, method, "set: acceptticket = " + this.m_enableTicket);
            this.m_createTicket = ((Hashtable)configuration).containsKey("createticket") && !configuration.getProperty("createticket").equals(defCacheID) ? Integer.parseInt(configuration.getProperty("createticket")) : 0;
            this.m_category.logT(100, this.m_location, method, "set: createticket = " + this.m_createTicket);
        }
        catch (NumberFormatException e) {
            throw (UMException)this.m_exlog.logException((Throwable)new UMException("configuration error: acceptcertificate, acceptpassword, acceptticket, createticket"), 500);
        }
        if (this.m_enableCert == 0 && this.m_enablePasswd == 0 && this.m_enableTicket == 0) {
            throw (UMException)this.m_exlog.logException((Throwable)new UMException("configuration error: no authentication method enabled"), 500);
        }
        if (((Hashtable)configuration).containsKey("loginlanguages") && !configuration.getProperty("loginlanguages").equals(defCacheID)) {
            int separator = configuration.getProperty("loginlanguages").indexOf(",");
            ArrayList<Object> list = new ArrayList<Object>();
            StringTokenizer tok = new StringTokenizer(configuration.getProperty("loginlanguages"), ",");
            while (tok.hasMoreElements()) {
                list.add(tok.nextElement());
            }
            this.m_languages = list.toArray();
            this.m_category.logT(100, this.m_location, method, "set: loginlanguages = " + this.m_languages.toString());
        } else {
            this.m_languages = new String[]{defCacheID};
        }
        this.m_httpParamUser = ((Hashtable)configuration).containsKey(HTTP_PARAM_USER) && !configuration.getProperty(HTTP_PARAM_USER).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_USER) : defHttpParamUser;
        this.m_httpParamAlias = ((Hashtable)configuration).containsKey(HTTP_PARAM_ALIAS) && !configuration.getProperty(HTTP_PARAM_ALIAS).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_ALIAS) : defHttpParamAlias;
        this.m_httpParamLanguage = ((Hashtable)configuration).containsKey(HTTP_PARAM_LANGUAGE) && !configuration.getProperty(HTTP_PARAM_LANGUAGE).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_LANGUAGE) : defHttpParamLanguage;
        this.m_httpParamPasswd = ((Hashtable)configuration).containsKey(HTTP_PARAM_PASSWD) && !configuration.getProperty(HTTP_PARAM_PASSWD).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_PASSWD) : defHttpParamPasswd;
        this.m_httpParamNewPasswd1 = ((Hashtable)configuration).containsKey(HTTP_PARAM_NEW_PASSWD1) && !configuration.getProperty(HTTP_PARAM_NEW_PASSWD1).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_NEW_PASSWD1) : defHttpParamNewPasswd1;
        this.m_httpParamNewPasswd2 = ((Hashtable)configuration).containsKey(HTTP_PARAM_NEW_PASSWD2) && !configuration.getProperty(HTTP_PARAM_NEW_PASSWD2).equals(defCacheID) ? configuration.getProperty(HTTP_PARAM_NEW_PASSWD2) : defHttpParamNewPasswd2;
        this.m_category.logT(100, this.m_location, method, "set: httpparamuser = " + this.m_httpParamUser);
        this.m_category.logT(100, this.m_location, method, "set: httpparamalias = " + this.m_httpParamAlias);
        this.m_category.logT(100, this.m_location, method, "set: httpparamlanguage = " + this.m_httpParamLanguage);
        this.m_category.logT(100, this.m_location, method, "set: httpparampassword = " + this.m_httpParamPasswd);
        this.m_category.logT(100, this.m_location, method, "set: httpparamnewpassword1 = " + this.m_httpParamNewPasswd1);
        this.m_category.logT(100, this.m_location, method, "set: httpparamnewpassword2 = " + this.m_httpParamNewPasswd2);
        this.m_forwardUrl = ((Hashtable)configuration).containsKey(FORWARD_URL) && !configuration.getProperty(FORWARD_URL).equals(defCacheID) ? configuration.getProperty(FORWARD_URL) : defForwardUrl;
        this.m_category.logT(100, this.m_location, method, "set: loginscreenurl = " + this.m_forwardUrl);
        this.m_activateForward = ((Hashtable)configuration).containsKey(ACTIVATE_LOGIN_FORWARD) && !configuration.getProperty(ACTIVATE_LOGIN_FORWARD).equals(defCacheID) ? Integer.parseInt(configuration.getProperty(ACTIVATE_LOGIN_FORWARD)) : 1;
        this.m_category.logT(100, this.m_location, method, "set: activateloginforward = " + this.m_activateForward);
        if (((Hashtable)configuration).containsKey(HOST_NAME) && !configuration.getProperty(HOST_NAME).equals(defCacheID)) {
            this.m_hostName = configuration.getProperty(HOST_NAME);
            this.m_category.logT(100, this.m_location, method, "set: fullqualifiedhostname = " + this.m_hostName);
        }
        this.m_accountfactoryID = null;
        this.m_accountfactory = null;
        if (((Hashtable)configuration).containsKey("useraccountfactory") && !configuration.getProperty("useraccountfactory").equals(defCacheID)) {
            this.m_accountfactoryID = configuration.getProperty("useraccountfactory");
            this.m_category.logT(100, this.m_location, method, "name of UserAccountFactory has been set to: " + this.m_accountfactoryID);
        }
        this.m_userfactoryID = null;
        this.m_userfactory = null;
        this.m_useUserfactory = 1;
        if (((Hashtable)configuration).containsKey("userfactory") && !configuration.getProperty("userfactory").equals(defCacheID)) {
            if (configuration.getProperty("userfactory").equals("null")) {
                this.m_useUserfactory = 0;
            }
            this.m_userfactoryID = configuration.getProperty("userfactory");
            this.m_category.logT(100, this.m_location, method, "name of userfactory has been set to UserFactory: " + this.m_userfactoryID);
        }
        this.m_cacheID = this.m_accountfactoryID == null ? defCacheID : this.m_accountfactoryID;
        this.m_cacheID = this.m_userfactoryID == null ? this.m_cacheID + defCacheID : this.m_cacheID + this.m_userfactoryID;
        this.m_cache = AuthenticationFactory.getCache();
        this.m_category.logT(100, this.m_location, method, "set CacheID: " + this.m_cacheID);
        if (((Hashtable)configuration).containsKey("tickettimetolerance") && !configuration.getProperty("tickettimetolerance").equals(defCacheID)) {
            try {
                this.m_tolerance = Integer.parseInt(configuration.getProperty("tickettimetolerance"));
            }
            catch (NumberFormatException e) {
                throw (UMException)this.m_exlog.logException((Throwable)new UMException("configuration error: tickettimetolerance must be an Integer."), 500);
            }
        } else {
            this.m_tolerance = 5;
        }
        this.m_cacheCheck = new CacheCheck(this.m_cache, this.m_cacheID, this.m_tolerance);
        this.m_category.logT(this.m_severity, this.m_location, method, "Initialization finished successfully.");
        this.m_location.exiting(method);
    }

    public IUser getLoggedInUser(HttpServletRequest request, HttpServletResponse response) {
        boolean redirect;
        String certificate;
        String method = "getLoggedInUser(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)";
        this.m_location.entering(method, new Object[]{request, response});
        IUser user = null;
        Object uID = null;
        String ticketString = null;
        if (this.m_enableTicket == 1) {
            ticketString = Util.getTicketFromCookie(request);
        }
        if (((certificate = (String)request.getAttribute("javax.servlet.http.X509Certificate")) == null || certificate.equals(defCacheID)) && request.getAttribute("javax.servlet.request.X509Certificate") != null && request.getAttribute("javax.servlet.request.X509Certificate") instanceof X509Certificate[]) {
            X509Certificate[] cert = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            try {
                certificate = Util.certificateToBase64(cert[0]);
            }
            catch (Exception e) {
                this.m_category.logT(400, this.m_location, method, e.toString());
            }
        }
        CacheCheckResult cacheResult = null;
        if (this.m_createTicket == 1 && (redirect = this.redirectIfFQHNNotSupplied(request, response))) {
            return null;
        }
        if (ticketString != null && !ticketString.equals(defCacheID)) {
            this.m_category.logT(this.m_severity, this.m_location, method, "SAP Logon Ticket found. Try to get User from cache, using the ticket as cachekey.");
            if (this.m_createTicket == 1) {
                try {
                    cacheResult = this.m_cacheCheck.checkTicketKey(ticketString);
                    user = cacheResult.getUser();
                }
                catch (CacheCheckFailedException ccfe) {
                    this.m_category.logT(400, this.m_location, method, ccfe.toString());
                    ticketString = null;
                }
                catch (UMException e) {
                    this.m_category.logT(400, this.m_location, method, e.toString());
                }
                if (user != null) {
                    this.m_category.logT(this.m_severity, this.m_location, method, "User found in cache.");
                    this.m_category.logT(this.m_severity, this.m_location, method, "return user");
                    this.m_location.exiting(method);
                    return user;
                }
                this.m_category.logT(this.m_severity, this.m_location, method, "User not found in cache.");
            }
            if (ticketString != null && this.m_enableTicket == 1) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("com.sap.security.SAPLogonTicket", ticketString);
                this.m_category.logT(this.m_severity, this.m_location, method, "Try ticket logon.");
                try {
                    user = this.loginViaAccountFact(request, response, map, false);
                    if (user == null) {
                        this.m_location.exiting(method);
                        return null;
                    }
                }
                catch (UMException ume) {
                    this.m_category.logT(400, this.m_location, method, ume.toString());
                }
                catch (CertificateException ce) {
                    this.m_category.logT(400, this.m_location, method, ce.toString());
                }
                if (user != null) {
                    this.m_category.logT(this.m_severity, this.m_location, method, "Ticket logon succeeded.");
                    String ticketKey = Util.getCacheKey(this.m_cacheID + ticketString);
                    this.m_cache.put(ticketKey, user);
                    this.m_category.logT(this.m_severity, this.m_location, method, "User saved in cache, key: ticket.");
                    this.m_category.logT(this.m_severity, this.m_location, method, "return user");
                    this.m_location.exiting(method);
                    return user;
                }
            }
        }
        if (certificate != null && !certificate.equals(defCacheID) && this.m_enableCert == 1 && this.m_createTicket == 1) {
            this.m_category.logT(this.m_severity, this.m_location, method, "Certificate found. Try to get User from cache, using the certificate as cachekey.");
            try {
                cacheResult = this.m_cacheCheck.checkCertKey(certificate);
                user = cacheResult.getUser();
                ticketString = cacheResult.getTicket();
            }
            catch (UMException e) {
                this.m_category.logT(400, this.m_location, method, e.toString());
            }
            if (user != null) {
                this.m_category.logT(this.m_severity, this.m_location, method, "User found in cache.");
                Util.setSSOCookie(request, response, ticketString, Util.getCookieDomain(request), -1);
                this.m_category.logT(this.m_severity, this.m_location, method, "return user");
                this.m_location.exiting(method);
                return user;
            }
            this.m_category.logT(this.m_severity, this.m_location, method, "User not found in cache.");
        }
        this.m_location.exiting(method);
        return null;
    }

    public IUser forceLoggedInUser(HttpServletRequest request, HttpServletResponse response) throws UMException {
        String language;
        boolean redirect;
        String method = "forceLoggedInUser(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)";
        this.m_location.entering(method, new Object[]{request, response});
        if (this.m_createTicket == 1 && (redirect = this.redirectIfFQHNNotSupplied(request, response))) {
            return null;
        }
        IUser user = null;
        user = this.getLoggedInUser(request, response);
        if (user != null) {
            this.m_location.exiting(method);
            return user;
        }
        String certificate = (String)request.getAttribute("javax.servlet.http.X509Certificate");
        if ((certificate == null || certificate.equals(defCacheID)) && request.getAttribute("javax.servlet.request.X509Certificate") != null && request.getAttribute("javax.servlet.request.X509Certificate") instanceof X509Certificate[]) {
            X509Certificate[] cert = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
            try {
                certificate = Util.certificateToBase64(cert[0]);
            }
            catch (Exception e) {
                this.m_category.logT(400, this.m_location, method, e.toString());
            }
        }
        String ticketString = null;
        HashMap<String, String> map = null;
        String passwd = null;
        String uID = null;
        String uAlias = null;
        Object message = null;
        if (certificate != null && !certificate.equals(defCacheID) && this.m_enableCert == 1) {
            block46: {
                this.m_category.logT(this.m_severity, this.m_location, method, "Try certificate logon without specifiying an user id.");
                map = new HashMap<String, String>();
                map.put("javax.servlet.http.X509Certificate", certificate);
                try {
                    user = this.loginViaAccountFact(request, response, map, false);
                    if (user == null) {
                        this.m_location.exiting(method);
                        return null;
                    }
                }
                catch (MissingPasswdChangeException mpce) {
                    this.m_category.logT(500, this.m_location, method, mpce.toString());
                    throw mpce;
                }
                catch (UserLockedException ule) {
                    throw (AuthenticationFailedException)this.m_exlog.logException((Throwable)new AuthenticationFailedException(ule.getMessage()), 500);
                }
                catch (UMException ume) {
                    this.m_category.logT(400, this.m_location, method, ume.toString());
                    if (!(ume instanceof AuthenticationFailedException) || ume.getMessage().equals("NO_MAPPING_FOUND") || ume.getMessage().equals("AUTH_METHOD_REQUIRES_SNC") || ume.getMessage().equals("X509_LOGON_DISABLED") || ume.getMessage().equals("X509_ENCODING_ERROR")) break block46;
                    uID = request.getParameter(this.m_httpParamUser);
                    language = request.getParameter(this.m_httpParamLanguage);
                    if (uID != null && !uID.equals(defCacheID)) {
                        map = new HashMap();
                        map.put("com.sap.security.SAPUser", uID);
                        map.put("javax.servlet.http.X509Certificate", certificate);
                        if (language != null && !language.equals(defCacheID)) {
                            map.put("com.sap.security.SAPLanguage", language);
                        }
                        this.m_category.logT(this.m_severity, this.m_location, method, "User id is set. Try certificate logon with user id = " + uID + ".");
                        try {
                            user = this.loginViaAccountFact(request, response, map, true);
                            if (user == null) {
                                this.m_location.exiting(method);
                                return null;
                            }
                        }
                        catch (MissingPasswdChangeException mpce) {
                            this.m_category.logT(500, this.m_location, method, mpce.toString());
                            throw mpce;
                        }
                        catch (UMException um) {
                            this.m_category.logT(400, this.m_location, method, um.toString());
                            break block46;
                        }
                        catch (CertificateException ce) {
                            this.m_category.logT(400, this.m_location, method, ce.toString());
                            break block46;
                        }
                    }
                    if (this.m_activateForward == 0 && this.m_enablePasswd != 1) {
                        throw (UMException)this.m_exlog.logException((Throwable)new MissingLoginParamException("Not enough parameters for certificate logon."), 500);
                    }
                    if (this.m_activateForward == 0) {
                        this.m_category.logT(400, this.m_location, method, "Not enough parameters for certificate logon.");
                    } else if (this.m_activateForward == 1) {
                        this.forwardToLoginPrompt(request, response, "certificate logon");
                        this.m_category.logT(this.m_severity, this.m_location, method, "Promting for user id.");
                        this.m_location.exiting(method);
                        return null;
                    }
                }
                catch (CertificateException ce) {
                    this.m_category.logT(400, this.m_location, method, ce.toString());
                }
            }
            if (user != null) {
                this.m_category.logT(this.m_severity, this.m_location, method, "Certificate logon succeeded.");
                if (this.m_createTicket == 1) {
                    ticketString = (String)map.get("com.sap.security.SAPLogonTicket");
                    if (ticketString == null) {
                        throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No SAP Logon Ticket received from the user account factory. Check configuration entry \"useraccountfactory.createticket\"."), 500);
                    }
                    Util.setSSOCookie(request, response, ticketString, Util.getCookieDomain(request), -1);
                    this.m_category.logT(this.m_severity, this.m_location, method, "SAP Logon Ticket set as SSO cookie");
                    String certKey = Util.getCacheKey(this.m_cacheID + certificate);
                    String ticketKey = Util.getCacheKey(this.m_cacheID + ticketString);
                    this.m_cache.put(certKey, user);
                    this.m_cache.put(ticketKey, user);
                    this.m_category.logT(this.m_severity, this.m_location, method, "User stored in cache, key 1: ticket, key 2: certificate.");
                }
                this.m_category.logT(this.m_severity, this.m_location, method, "return user");
                this.m_location.exiting(method);
                return user;
            }
        }
        if (this.m_enablePasswd == 1) {
            this.m_category.logT(this.m_severity, this.m_location, method, "Password logon is enabled.");
            passwd = request.getParameter(this.m_httpParamPasswd);
            if (passwd == null || passwd.equals(defCacheID)) {
                passwd = (String)request.getAttribute(this.m_httpParamPasswd);
            }
            language = request.getParameter(this.m_httpParamLanguage);
            uID = request.getParameter(this.m_httpParamUser);
            if (uID == null || uID.equals(defCacheID)) {
                uID = (String)request.getAttribute(this.m_httpParamUser);
            }
            if (uID == null || uID.equals(defCacheID)) {
                uID = null;
            }
            if ((uAlias = request.getParameter(this.m_httpParamAlias)) == null || uAlias.equals(defCacheID)) {
                uAlias = (String)request.getAttribute(this.m_httpParamAlias);
            }
            if (uAlias == null || uAlias.equals(defCacheID)) {
                uAlias = null;
            }
            if (passwd == null || passwd.equals(defCacheID) || uID == null && uAlias == null) {
                if (this.m_activateForward == 0) {
                    throw (UMException)this.m_exlog.logException((Throwable)new MissingLoginParamException("Not enough parameters for logon."), 500);
                }
                this.forwardToLoginPrompt(request, response, "password logon");
                this.m_category.logT(this.m_severity, this.m_location, method, "Promting for user id/alias and password.");
                this.m_location.exiting(method);
                return null;
            }
            map = new HashMap();
            map.put("com.sap.security.SAPPassword", passwd);
            if (uID != null) {
                map.put("com.sap.security.SAPUser", uID);
                this.m_category.logT(this.m_severity, this.m_location, method, "Try password logon with user id = " + uID + ".");
            } else {
                map.put("com.sap.security.SAPAliasUser", uAlias);
                this.m_category.logT(this.m_severity, this.m_location, method, "Try password logon with user alias = " + uID + ".");
            }
            if (language != null) {
                map.put("com.sap.security.SAPLanguage", language);
                this.m_category.logT(this.m_severity, this.m_location, method, "Language for password logon is " + language + ".");
            }
            try {
                user = this.loginViaAccountFact(request, response, map, true);
                if (user == null) {
                    this.m_location.exiting(method);
                    return null;
                }
            }
            catch (MissingPasswdChangeException mpce) {
                this.m_category.logT(500, this.m_location, method, mpce.toString());
                throw mpce;
            }
            catch (UserLockedException ule) {
                throw (AuthenticationFailedException)this.m_exlog.logException((Throwable)new AuthenticationFailedException(ule.getMessage()), 500);
            }
            catch (UMException ume) {
                this.m_category.logT(400, this.m_location, method, ume.toString());
            }
            catch (CertificateException ce) {
                this.m_category.logT(400, this.m_location, method, ce.toString());
            }
            if (user != null) {
                this.m_category.logT(this.m_severity, this.m_location, method, "Password logon succeeded.");
                if (this.m_createTicket == 1) {
                    ticketString = (String)map.get("com.sap.security.SAPLogonTicket");
                    if (ticketString == null) {
                        throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No SAP Logon Ticket received from the user account factory. Check configuration entry \"useraccountfactory.createticket\"."), 500);
                    }
                    Util.setSSOCookie(request, response, ticketString, Util.getCookieDomain(request), -1);
                    this.m_category.logT(this.m_severity, this.m_location, method, "SAP Logon Ticket set as SSO cookie");
                    String ticketKey = Util.getCacheKey(this.m_cacheID + ticketString);
                    this.m_category.logT(this.m_severity, this.m_location, method, "User stored in cache, key: ticket");
                    this.m_cache.put(ticketKey, user);
                }
                this.m_category.logT(this.m_severity, this.m_location, method, "return user");
                this.m_location.exiting(method);
                return user;
            }
        }
        throw (UMException)this.m_exlog.logException((Throwable)new AuthenticationFailedException("Could not lock in user."), 500);
    }

    private void forwardToLoginPrompt(HttpServletRequest request, HttpServletResponse response, String loginmethod) {
        String method = "forwardToLoginPrompt(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse, java.lang.String)";
        this.m_location.entering(method, new Object[]{request, response, loginmethod});
        String uID = request.getParameter(this.m_httpParamUser);
        String alias = request.getParameter(this.m_httpParamAlias);
        boolean passwdRequired = false;
        boolean uIDRequired = false;
        boolean changeRequired = false;
        if (loginmethod.equals("certificate logon")) {
            passwdRequired = false;
            uIDRequired = true;
        }
        if (loginmethod.equals("password logon")) {
            passwdRequired = true;
            uIDRequired = true;
        }
        if (loginmethod.equals("password change")) {
            changeRequired = true;
            passwdRequired = true;
            if (request.getParameter(this.m_httpParamUser) != null) {
                uIDRequired = true;
            }
        }
        StringBuffer parameters = new StringBuffer();
        parameters.append("?");
        parameters.append(HTTP_PARAM_ORIGINAL_URL);
        parameters.append("=");
        parameters.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            parameters.append("?" + request.getQueryString());
        }
        parameters.append("&");
        parameters.append(HTTP_PARAM_LOGIN_METHOD);
        parameters.append("=");
        parameters.append(loginmethod);
        parameters.append("&");
        if (uIDRequired) {
            parameters.append(this.m_httpParamUser);
            parameters.append("=");
            if (uID != null) {
                parameters.append(uID);
            } else {
                parameters.append("\"\"");
            }
            parameters.append("&");
            parameters.append(this.m_httpParamAlias);
            parameters.append("=");
            if (alias != null) {
                parameters.append(alias);
            } else {
                parameters.append("\"\"");
            }
        }
        if (passwdRequired) {
            parameters.append("&");
            parameters.append(this.m_httpParamPasswd);
            parameters.append("=\"\"");
        }
        if (changeRequired) {
            parameters.append("&");
            parameters.append(this.m_httpParamNewPasswd1);
            parameters.append("=\"\"");
            parameters.append("&");
            parameters.append(this.m_httpParamNewPasswd2);
            parameters.append("=\"\"");
        }
        parameters.append("&");
        parameters.append(this.m_httpParamLanguage);
        parameters.append("=");
        parameters.append((String)this.m_languages[0]);
        int i = 1;
        while (i < this.m_languages.length) {
            parameters.append(", ");
            parameters.append((String)this.m_languages[i]);
            ++i;
        }
        try {
            RequestDispatcher dispatcher = request.getRequestDispatcher(this.m_forwardUrl + parameters.toString());
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            this.m_location.exiting(method);
            return;
        }
        catch (Exception e) {
            throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException(e.getMessage()), 500);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response) {
        String key;
        String method = "logout(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)";
        this.m_location.entering(method, new Object[]{request, response});
        String ticketString = null;
        if (this.m_createTicket == 1) {
            ticketString = Util.getTicketFromCookie(request);
        }
        String certificate = (String)request.getAttribute("javax.servlet.http.X509Certificate");
        if (ticketString != null && !ticketString.equals(defCacheID)) {
            Util.deleteSSOCookie(request, response);
            this.m_category.logT(this.m_severity, this.m_location, method, "SSO cookie with SAP Logon Ticket deleted.");
            key = Util.getCacheKey(this.m_cacheID + ticketString);
            this.m_cache.invalidate(key);
            this.m_category.logT(this.m_severity, this.m_location, method, "User deleted from cache, key: ticket.");
        }
        if (certificate != null && !certificate.equals(defCacheID) && this.m_createTicket == 1) {
            key = Util.getCacheKey(this.m_cacheID + certificate);
            this.m_cache.invalidate(key);
            this.m_category.logT(this.m_severity, this.m_location, method, "User deleted from cache, key: certificate.");
        }
        this.m_location.exiting(method);
    }

    private boolean redirectIfFQHNNotSupplied(HttpServletRequest request, HttpServletResponse response) {
        String method = "redirectIfFQHNNotSupplied(HttpServletRequest, HttpServletResponse)";
        this.m_location.entering(method, new Object[]{request, response});
        String serverName = request.getServerName();
        int firstdot = serverName.indexOf(46);
        int lastdot = serverName.lastIndexOf(46);
        String hostName = null;
        String fqhn = null;
        try {
            hostName = InetAddress.getByName(serverName).getHostAddress();
        }
        catch (UnknownHostException e) {
            this.m_category.logT(400, this.m_location, method, e.toString());
        }
        catch (IOException f) {
            this.m_category.logT(400, this.m_location, method, f.toString());
        }
        if (firstdot == -1 && lastdot == -1 || hostName.equals(serverName)) {
            if (this.m_hostName != null) {
                fqhn = this.m_hostName;
            } else {
                try {
                    fqhn = InetAddress.getByName(hostName).getHostName();
                }
                catch (UnknownHostException e) {
                    throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException(e.toString() + "Can't set SAP Logon Ticket as cookie, FQHN required. " + "Set FQHN under " + HOST_NAME), 500);
                }
                catch (IOException f) {
                    throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException(f.toString() + "Can't set SAP Logon Ticket as cookie, FQHN required. " + "Set FQHN under " + HOST_NAME), 500);
                }
            }
            int dot = fqhn.indexOf(46);
            if (dot == -1 || dot == 0 || dot == fqhn.length() - 1) {
                throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("Can't set SAP Logon Ticket as cookie, FQHN required. Set FQHN under fullqualifiedhostname"), 500);
            }
            StringBuffer buf = null;
            buf = new StringBuffer();
            String Uri = HttpUtils.getRequestURL((HttpServletRequest)request).toString();
            int startServerName = Uri.indexOf(serverName);
            int endServerName = Uri.indexOf(serverName) + serverName.length();
            buf.append(Uri.substring(0, startServerName));
            buf.append(fqhn);
            buf.append(Uri.substring(endServerName));
            if (request.getQueryString() != null) {
                buf.append("?");
                buf.append(request.getQueryString());
            }
            try {
                response.sendRedirect(buf.toString());
                this.m_category.logT(this.m_severity, this.m_location, method, "Redirect to same URL with host name replaced by Full Qualified Host Name: " + fqhn);
                this.m_location.exiting(method);
                return true;
            }
            catch (IOException e) {
                throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException(e, "Can not redirect to Full Qualified Host Name"), 500);
            }
        }
        this.m_category.logT(this.m_severity, this.m_location, method, "Request was send to the Full Qualified Host Name.");
        this.m_location.exiting(method);
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IUser loginViaAccountFact(HttpServletRequest request, HttpServletResponse response, Map map, boolean passwdChangeAllowed) throws UMException, CertificateException {
        void var6_10;
        Map ssomap;
        String ticketString;
        String uID;
        IUserAccount useraccount;
        String method;
        block28: {
            block27: {
                method = "loginViaAccountFact(HttpServletRequest, HttpServletResponse, java.util.Map, boolean)";
                this.m_location.entering(method, new Object[]{request, response, "xxx", new Boolean(passwdChangeAllowed)});
                Object var6_6 = null;
                useraccount = null;
                if (this.m_accountfactory == null) {
                    if (this.m_accountfactoryID == null) {
                        this.m_accountfactory = Security.getUserAccountFactory();
                        if (this.m_accountfactory == null) {
                            throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No default useraccountfactory registered."), 500);
                        }
                    } else {
                        this.m_accountfactory = Security.getUserAccountFactory(this.m_accountfactoryID);
                        if (this.m_accountfactory == null) {
                            throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No useraccountfactory with name " + this.m_accountfactoryID + " registered."), 500);
                        }
                    }
                }
                if ((useraccount = this.m_accountfactory.getAuthenticatedUserAccount(map)) == null) {
                    throw new UMRuntimeException("No useraccount with this user id exists");
                }
                if (!useraccount.isPasswordChangeRequired() || !passwdChangeAllowed) break block27;
                this.m_category.logT(this.m_severity, this.m_location, method, "Password change required");
                String passwd = request.getParameter(this.m_httpParamPasswd);
                String newPasswd1 = request.getParameter(this.m_httpParamNewPasswd1);
                String newPasswd2 = request.getParameter(this.m_httpParamNewPasswd2);
                if (newPasswd1 != null && !newPasswd1.equals(defCacheID) && newPasswd2 != null && !newPasswd2.equals(defCacheID)) {
                    if (!newPasswd1.equals(newPasswd2)) {
                        throw new UMRuntimeException("Password change failed, same new password has to be entered two times");
                    }
                    useraccount.setPassword(passwd, newPasswd1);
                    try {
                        useraccount.commit();
                    }
                    catch (UMException e) {
                        throw new UMRuntimeException("Password change failed: " + e);
                    }
                    this.m_category.logT(this.m_severity, this.m_location, method, "Password has been changed");
                    break block28;
                } else {
                    if (this.m_activateForward == 0) {
                        throw new MissingPasswdChangeException("Not enough parameters for password change.");
                    }
                    this.forwardToLoginPrompt(request, response, "password change");
                    this.m_location.exiting(method);
                    return null;
                }
            }
            if (useraccount.isPasswordChangeRequired() && !passwdChangeAllowed) {
                throw new UMException("Password change required. Can not login without user interaction.");
            }
        }
        if ((uID = (String)map.get("com.sap.security.SAPUser")) == null) {
            uID = useraccount.getLogonUid();
        }
        if (this.m_useUserfactory == 1) {
            if (this.m_userfactory == null) {
                if (this.m_userfactoryID == null) {
                    this.m_userfactory = Security.getUserFactory();
                    if (this.m_userfactory == null) {
                        throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No default userfactory registered."), 500);
                    }
                } else {
                    this.m_userfactory = Security.getUserFactory(this.m_userfactoryID);
                    if (this.m_userfactory == null) {
                        throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No userfactory with name " + this.m_userfactoryID + " registered."), 500);
                    }
                }
            }
            IUser iUser = this.m_userfactory.getUser(uID);
            if (this.m_createTicket == 1 && iUser instanceof SSOUser) {
                ticketString = (String)map.get("com.sap.security.SAPLogonTicket");
                if (ticketString == null) {
                    throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No SAP Logon Ticket received from the user account factory. Check configuration entry \"useraccountfactory.createticket\"."), 500);
                }
                ssomap = ((SSOUser)((Object)iUser)).getCredentials();
                ssomap.put("com.sap.security.SAPLogonTicket", ticketString);
            }
        } else if (useraccount instanceof R3UserAccount) {
            R3User r3User = ((R3UserAccount)useraccount).getImplicitUser();
        } else {
            R3User r3User = new R3User(null);
            if (this.m_createTicket == 1) {
                ticketString = (String)map.get("com.sap.security.SAPLogonTicket");
                if (ticketString == null) {
                    throw (UMRuntimeException)this.m_exlog.logException((Throwable)new UMRuntimeException("No SAP Logon Ticket received from the user account factory. Check configuration entry \"useraccountfactory.createticket\"."), 500);
                }
                ssomap = ((SSOUser)r3User).getCredentials();
                ssomap.put("com.sap.security.SAPLogonTicket", ticketString);
            }
        }
        this.m_location.exiting(method);
        return var6_10;
    }

    public void setUserFactory(IUserFactory factory) {
        this.m_userfactory = factory;
    }

    public void setUserAccountFactory(IUserAccountFactory factory, int cacheSize) {
        this.m_accountfactory = factory;
        this.m_cache = new MostRecentlyUsedCache(cacheSize);
        this.m_cacheCheck = new CacheCheck(this.m_cache, this.m_cacheID, this.m_tolerance);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

