/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.tools;

import com.sap.engine.core.configuration.bootstrap.ConfigurationManagerBootstrapImpl;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.frame.core.configuration.NameAlreadyExistsException;
import com.sap.engine.frame.core.configuration.NameNotFoundException;
import com.sap.engine.frame.core.configuration.addons.PropertyEntry;
import com.sap.engine.frame.core.configuration.addons.PropertySheet;
import com.sap.security.core.server.secstorefs.NotFoundException;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import com.sap.tc.logging.Location;
import java.io.FileInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class WizardModelDB {
    private static String cfgFileLocation = null;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$tools$WizardModelDB == null ? (class$com$sap$security$tools$WizardModelDB = WizardModelDB.class$("com.sap.security.tools.WizardModelDB")) : class$com$sap$security$tools$WizardModelDB));
    private ConfigurationManagerBootstrapImpl cfgMgrBootImpl = null;
    private ConfigurationHandler cfgHandler = null;
    private HashMap roots = new HashMap();
    private PropertySheet umeSheet = null;
    private PropertySheet secSheet = null;
    private DatasourceConfiguration _datasourceConfiguration = null;
    static /* synthetic */ Class class$com$sap$security$tools$WizardModelDB;
    static /* synthetic */ Class class$java$lang$String;

    public WizardModelDB(String cfgFilePath) {
        cfgFileLocation = cfgFilePath;
    }

    public void open() {
        try {
            this.cfgMgrBootImpl = new ConfigurationManagerBootstrapImpl(cfgFileLocation);
            this.cfgHandler = this.cfgMgrBootImpl.getConfigurationHandler();
            this.umeSheet = this.cfgHandler.openConfiguration("cluster_data/server/cfg/services/com.sap.security.core.ume.service", 1).getPropertySheetInterface();
            this.secSheet = this.cfgHandler.openConfiguration("cluster_data/server/cfg/services/security", 1).getPropertySheetInterface();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() {
        try {
            try {
                this.cfgHandler.commit();
                this.cfgHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                Object var3_2 = null;
                this.cfgMgrBootImpl.shutdown();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cfgMgrBootImpl.shutdown();
            throw throwable;
        }
        this.cfgMgrBootImpl.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() {
        try {
            try {
                this.cfgHandler.rollback();
                this.cfgHandler.closeAllConfigurations();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
                Object var3_2 = null;
                this.cfgMgrBootImpl.shutdown();
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cfgMgrBootImpl.shutdown();
            throw throwable;
        }
        this.cfgMgrBootImpl.shutdown();
    }

    public DatasourceConfiguration getDatasourceConfiguration() {
        if (this._datasourceConfiguration == null) {
            this._datasourceConfiguration = new DatasourceConfiguration();
        }
        return this._datasourceConfiguration;
    }

    public String getGuestUser() {
        PropertyEntry propEntry = null;
        try {
            propEntry = this.umeSheet.getPropertyEntry("ume.login.guest_user.uniqueids");
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return (String)propEntry.getValue();
    }

    public void setUMEProperty(String key, String value) {
        String method = "setUMEProperty(String key, String value)";
        Object cfgStore = null;
        try {
            PropertyEntry propEntry = this.umeSheet.getPropertyEntry(key);
            propEntry.setValue((Object)value);
            LOCATION.debugT("setUMEProperty(String key, String value)", "Set value for UME property >> " + key);
        }
        catch (NameNotFoundException e) {
            LOCATION.traceThrowableT(500, "Could not set value for UME property >>" + key, (Throwable)e);
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not set value for UME property >>" + key, (Throwable)e);
        }
    }

    public void setGuestUser(String userName) {
        Configuration cfgStore = null;
        try {
            PropertyEntry propEntry = this.umeSheet.getPropertyEntry("ume.login.guest_user.uniqueids");
            propEntry.setValue((Object)userName);
            cfgStore = this.getConfiguration("security/userstores/UME User Store", 1);
            cfgStore.modifyConfigEntry("anonymous-user", (Object)userName, true);
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setAdminUser(String userName, String password) {
        Object cfgStore = null;
        try {
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(cfgFileLocation));
            SecStoreFS.setSID((String)configProps.getProperty("system.name"));
            SecStoreFS.setDefaultFilenames((String)configProps.getProperty("secstorefs.secfile"), (String)configProps.getProperty("secstorefs.keyfile"));
            SecStoreFS secStoreFS = new SecStoreFS();
            secStoreFS.openExistingStore();
            secStoreFS.updatePair("admin/user/" + configProps.getProperty("system.name"), userName);
            secStoreFS.updatePair("admin/password/" + configProps.getProperty("system.name"), password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDefaultGroups(String grpAdmins, String grpGuests, String grpAll) {
        Configuration cfgApp = null;
        Configuration cfgRole = null;
        Object cfgUsers = null;
        Configuration cfgGroups = null;
        try {
            cfgApp = this.getConfiguration("security/roles/UME User Store", 1);
            cfgRole = cfgApp.getSubConfiguration("administrators");
            cfgGroups = cfgRole.getSubConfiguration("groups");
            cfgGroups.addConfigEntry(grpAdmins, (Object)"");
            cfgRole = cfgApp.getSubConfiguration("guests");
            cfgGroups = cfgRole.getSubConfiguration("groups");
            cfgGroups.addConfigEntry(grpGuests, (Object)"");
            cfgRole = cfgApp.getSubConfiguration("all");
            cfgGroups = cfgRole.getSubConfiguration("groups");
            cfgGroups.addConfigEntry(grpAll, (Object)"");
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles) {
        String method = "addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)";
        try {
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(cfgFileLocation));
            SecStoreFS.setSID((String)configProps.getProperty("system.name"));
            SecStoreFS.setDefaultFilenames((String)configProps.getProperty("secstorefs.secfile"), (String)configProps.getProperty("secstorefs.keyfile"));
            SecStoreFS secStoreFS = new SecStoreFS();
            secStoreFS.openExistingStore();
            try {
                secStoreFS.deletePair("user/" + uid + "/name");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + uid + "/isUser");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + uid + "/password");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + uid + "/parentGroups");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + uid + "/isLocked");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + uid + "/roles");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            StringBuffer parentString = new StringBuffer();
            int i = 0;
            while (i < parents.length) {
                parentString.append(parents[i]);
                if (i < parents.length - 1) {
                    parentString.append(",");
                }
                ++i;
            }
            StringBuffer roleString = new StringBuffer();
            int i2 = 0;
            while (i2 < roles.length) {
                roleString.append(roles[i2]);
                if (i2 < roles.length - 1) {
                    roleString.append(",");
                }
                ++i2;
            }
            secStoreFS.insertPair("user/" + uid + "/name", uid);
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/name = " + uid);
            secStoreFS.insertPair("user/" + uid + "/isUser", "true");
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/isUser = true");
            secStoreFS.insertPair("user/" + uid + "/password", pwd);
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/password = *****");
            secStoreFS.insertPair("user/" + uid + "/parentGroups", parentString.toString());
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/parentGroups = " + parentString.toString());
            secStoreFS.insertPair("user/" + uid + "/isLocked", new Boolean(isLocked).toString());
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/isLocked = " + new Boolean(isLocked).toString());
            secStoreFS.insertPair("user/" + uid + "/roles", roleString.toString());
            LOCATION.debugT("addUser(String uid, String pwd, String[] parents, boolean isLocked, String[] roles)", "Added SecureStoreFS entry >> user/" + uid + "/roles = " + roleString.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addGroup(String gid, String[] roles) {
        String method = "addGroup(String gid, String[] roles)";
        try {
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(cfgFileLocation));
            SecStoreFS.setSID((String)configProps.getProperty("system.name"));
            SecStoreFS.setDefaultFilenames((String)configProps.getProperty("secstorefs.secfile"), (String)configProps.getProperty("secstorefs.keyfile"));
            SecStoreFS secStoreFS = new SecStoreFS();
            secStoreFS.openExistingStore();
            try {
                secStoreFS.deletePair("user/" + gid + "/name");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + gid + "/isUser");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            try {
                secStoreFS.deletePair("user/" + gid + "/roles");
            }
            catch (NotFoundException e) {
                // empty catch block
            }
            StringBuffer roleString = new StringBuffer();
            int i = 0;
            while (i < roles.length) {
                roleString.append(roles[i]);
                if (i < roles.length - 1) {
                    roleString.append(",");
                }
                ++i;
            }
            secStoreFS.insertPair("user/" + gid + "/name", gid);
            LOCATION.debugT("addGroup(String gid, String[] roles)", "Added SecureStoreFS entry >> user/" + gid + "/name = " + gid);
            secStoreFS.insertPair("user/" + gid + "/isUser", "false");
            LOCATION.debugT("addGroup(String gid, String[] roles)", "Added SecureStoreFS entry >> user/" + gid + "/isUser = false");
            secStoreFS.insertPair("user/" + gid + "/roles", roleString.toString());
            LOCATION.debugT("addGroup(String gid, String[] roles)", "Added SecureStoreFS entry >> user/" + gid + "/roles = " + roleString.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getSuperUserActive() {
        PropertyEntry propEntry = null;
        try {
            propEntry = this.umeSheet.getPropertyEntry("ume.superadmin.activated");
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return Boolean.valueOf((String)propEntry.getValue());
    }

    public String getSuperUserPassword() {
        PropertyEntry propEntry = null;
        try {
            propEntry = this.umeSheet.getPropertyEntry("ume.superadmin.password");
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        return (String)propEntry.getValue();
    }

    public void setSuperUserActive(boolean active) {
        try {
            PropertyEntry propEntry = this.umeSheet.getPropertyEntry("ume.superadmin.activated");
            propEntry.setValue((Object)new Boolean(active).toString());
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setSuperUserPassword(String password) {
        try {
            PropertyEntry propEntry = this.umeSheet.getPropertyEntry("ume.superadmin.password");
            propEntry.setValue((Object)password);
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void clearRoleAssignments() {
        Configuration cfgConfigs = null;
        Configuration cfgApp = null;
        Configuration cfgRole = null;
        Configuration cfgNode = null;
        Iterator configs = null;
        String[] roles = null;
        String appName = null;
        String roleName = null;
        try {
            cfgConfigs = this.getConfiguration("security/configurations", 1);
            configs = cfgConfigs.getAllConfigEntries().values().iterator();
            while (configs.hasNext()) {
                appName = (String)configs.next();
                System.out.println("\n" + appName);
                try {
                    cfgApp = this.getConfiguration(appName + "/security/roles/UME User Store", 1);
                    roles = cfgApp.getAllSubConfigurationNames();
                    int i = 0;
                    while (i < roles.length) {
                        roleName = roles[i];
                        System.out.println("==>" + roleName);
                        cfgRole = cfgApp.getSubConfiguration(roleName);
                        try {
                            cfgNode = cfgRole.getSubConfiguration("users");
                            cfgNode.deleteAllConfigEntries();
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            cfgNode = cfgRole.getSubConfiguration("groups");
                            cfgNode.deleteAllConfigEntries();
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                        try {
                            cfgRole.deleteConfigEntry("run-as_identity");
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
            }
            try {
                System.out.println("\nSAP-J2EE-Engine");
                cfgApp = this.getConfiguration("security/roles/UME User Store", 1);
                roles = cfgApp.getAllSubConfigurationNames();
                int i = 0;
                while (i < roles.length) {
                    roleName = roles[i];
                    System.out.println("==>" + roleName);
                    cfgRole = cfgApp.getSubConfiguration(roleName);
                    try {
                        cfgNode = cfgRole.getSubConfiguration("users");
                        cfgNode.deleteAllConfigEntries();
                    }
                    catch (NameNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        cfgNode = cfgRole.getSubConfiguration("groups");
                        cfgNode.deleteAllConfigEntries();
                    }
                    catch (NameNotFoundException e) {
                        // empty catch block
                    }
                    try {
                        cfgRole.deleteConfigEntry("run-as_identity");
                    }
                    catch (NameNotFoundException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            catch (NameNotFoundException e) {}
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void clearUsersAndGroups() {
        Configuration cfgStore = null;
        try {
            cfgStore = this.getConfiguration("security/userstores/UME User Store/configuration", 1);
            cfgStore.deleteAllConfigEntries();
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(cfgFileLocation));
            SecStoreFS.setSID((String)configProps.getProperty("system.name"));
            SecStoreFS.setDefaultFilenames((String)configProps.getProperty("secstorefs.secfile"), (String)configProps.getProperty("secstorefs.keyfile"));
            SecStoreFS secStoreFS = new SecStoreFS();
            secStoreFS.openExistingStore();
            Properties props = secStoreFS.getStringPairs();
            Enumeration keys = ((Hashtable)props).keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith("user/")) continue;
                secStoreFS.deletePair(key);
            }
        }
        catch (NameNotFoundException e) {
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearServiceConfigs() {
        try {
            this.deleteConfiguration("vsi");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.deleteConfiguration("saml");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.deleteConfiguration("securestorage");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.deleteConfiguration("ssl");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.deleteConfiguration("keystore");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            Configuration cfgConfigs = null;
            Iterator configs = null;
            String appName = null;
            cfgConfigs = this.getConfiguration("security/configurations", 1);
            configs = cfgConfigs.getAllConfigEntries().keySet().iterator();
            while (configs.hasNext()) {
                appName = (String)configs.next();
                if (!appName.startsWith("keystore-view")) continue;
                cfgConfigs.deleteConfigEntry(appName);
            }
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            this.deleteConfiguration("security/roles/UME User Store/KeystoreAdministrator");
            this.deleteConfiguration("security/roles/UME User Store/KeystoreViewsCreator");
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void clearWSSEC() {
        Configuration cfgStore = null;
        Configuration cfgWSSEC = null;
        Configuration cfgVendor = null;
        Configuration cfgApp = null;
        Configuration cfgConfig = null;
        Configuration cfgOperation = null;
        Iterator vendors = null;
        Iterator apps = null;
        Iterator configs = null;
        Iterator operations = null;
        String vendor = null;
        String app = null;
        String config = null;
        String operation = null;
        try {
            cfgStore = this.getConfiguration("webservices/security/wss/policy-profiles", 1);
            cfgStore.deleteAllConfigEntries();
            cfgStore.deleteAllSubConfigurations();
            cfgWSSEC = this.getConfiguration("webservices/services", 1);
            vendors = cfgWSSEC.getAllSubConfigurations().keySet().iterator();
            while (vendors.hasNext()) {
                vendor = (String)vendors.next();
                System.out.println("\n" + vendor);
                try {
                    cfgVendor = this.getConfiguration("webservices/services/" + vendor, 1);
                    apps = cfgVendor.getAllSubConfigurations().keySet().iterator();
                    while (apps.hasNext()) {
                        app = (String)apps.next();
                        System.out.println("==>" + app);
                        try {
                            cfgApp = this.getConfiguration("webservices/services/" + vendor + "/" + app, 1);
                            configs = cfgApp.getAllSubConfigurations().keySet().iterator();
                            while (configs.hasNext()) {
                                config = (String)configs.next();
                                System.out.println("====>" + config);
                                try {
                                    cfgConfig = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config, 1);
                                    operations = cfgConfig.getAllSubConfigurations().keySet().iterator();
                                    while (operations.hasNext()) {
                                        operation = (String)operations.next();
                                        System.out.println("======>" + operation);
                                        try {
                                            cfgOperation = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config + "/" + operation + "/wss/inbound", 1);
                                            System.out.println("--->" + (String)cfgOperation.getConfigEntry("profile") + " >>> " + "None");
                                            cfgOperation.modifyConfigEntry("profile", (Object)"None");
                                        }
                                        catch (NameNotFoundException e) {
                                            // empty catch block
                                        }
                                        try {
                                            cfgOperation = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config + "/" + operation + "/wss/outbound", 1);
                                            System.out.println("--->" + (String)cfgOperation.getConfigEntry("profile") + " >>> " + "None");
                                            cfgOperation.modifyConfigEntry("profile", (Object)"None");
                                        }
                                        catch (NameNotFoundException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                catch (NameNotFoundException e) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
            }
            cfgWSSEC = this.getConfiguration("webservices/proxies", 1);
            vendors = cfgWSSEC.getAllSubConfigurations().keySet().iterator();
            while (vendors.hasNext()) {
                vendor = (String)vendors.next();
                System.out.println("\n" + vendor);
                try {
                    cfgVendor = this.getConfiguration("webservices/services/" + vendor, 1);
                    apps = cfgVendor.getAllSubConfigurations().keySet().iterator();
                    while (apps.hasNext()) {
                        app = (String)apps.next();
                        System.out.println("==>" + app);
                        try {
                            cfgApp = this.getConfiguration("webservices/services/" + vendor + "/" + app, 1);
                            configs = cfgApp.getAllSubConfigurations().keySet().iterator();
                            while (configs.hasNext()) {
                                config = (String)configs.next();
                                System.out.println("====>" + config);
                                try {
                                    cfgConfig = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config, 1);
                                    operations = cfgConfig.getAllSubConfigurations().keySet().iterator();
                                    while (operations.hasNext()) {
                                        operation = (String)operations.next();
                                        System.out.println("======>" + operation);
                                        try {
                                            cfgOperation = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config + "/" + operation + "/wss/inbound", 1);
                                            System.out.println("--->" + (String)cfgOperation.getConfigEntry("profile") + " >>> " + "None");
                                            cfgOperation.modifyConfigEntry("profile", (Object)"None");
                                        }
                                        catch (NameNotFoundException e) {
                                            // empty catch block
                                        }
                                        try {
                                            cfgOperation = this.getConfiguration("webservices/services/" + vendor + "/" + app + "/" + config + "/" + operation + "/wss/outbound", 1);
                                            System.out.println("--->" + (String)cfgOperation.getConfigEntry("profile") + " >>> " + "None");
                                            cfgOperation.modifyConfigEntry("profile", (Object)"None");
                                        }
                                        catch (NameNotFoundException e) {
                                            // empty catch block
                                        }
                                    }
                                }
                                catch (NameNotFoundException e) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (NameNotFoundException e) {
                            // empty catch block
                        }
                    }
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
            }
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setJMSUser(String userName) {
        Configuration cfgProviders = null;
        Configuration cfgProvider = null;
        Configuration cfgRole = null;
        Iterator providers = null;
        Iterator factories = null;
        String providerName = null;
        String factoryName = null;
        try {
            cfgProviders = this.getConfiguration("jms_provider/DEFAULT", 1);
            providers = cfgProviders.getAllSubConfigurations().keySet().iterator();
            while (providers.hasNext()) {
                providerName = (String)providers.next();
                System.out.println("\n" + providerName);
                try {
                    cfgProvider = this.getConfiguration("jms_provider/DEFAULT/" + providerName + "/conn_factories", 1);
                    factories = cfgProvider.getAllSubConfigurations().keySet().iterator();
                    while (factories.hasNext()) {
                        factoryName = (String)factories.next();
                        System.out.println("==>" + factoryName);
                        cfgRole = cfgProvider.getSubConfiguration(factoryName);
                        System.out.println("--->" + (String)cfgRole.getConfigEntry("userName") + " >>> " + userName);
                        cfgRole.modifyConfigEntry("userName", (Object)userName);
                    }
                }
                catch (NameNotFoundException e) {
                    // empty catch block
                }
            }
        }
        catch (NameNotFoundException e) {
            e.printStackTrace();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void clearUMETables() {
        try {
            Properties configProps = new Properties();
            configProps.load(new FileInputStream(cfgFileLocation));
            SecStoreFS.setSID((String)configProps.getProperty("system.name"));
            SecStoreFS.setDefaultFilenames((String)configProps.getProperty("secstorefs.secfile"), (String)configProps.getProperty("secstorefs.keyfile"));
            Class<?> c = Class.forName("com.sap.sql.connect.OpenSQLDataSource");
            Field typeField = c.getField("CONN_TYPE_OPEN_SQL");
            Method m = c.getMethod("newInstance", new Class[0]);
            Object openSQLDataSource = m.invoke(null, new Object[0]);
            m = c.getMethod("setConnectionType", Integer.TYPE);
            m.invoke(openSQLDataSource, new Integer(typeField.getInt(null)));
            m = c.getMethod("setDataSourceName", class$java$lang$String == null ? (class$java$lang$String = WizardModelDB.class$("java.lang.String")) : class$java$lang$String);
            m.invoke(openSQLDataSource, configProps.getProperty("rdbms.connection"));
            m = c.getMethod("getConnection", new Class[0]);
            Connection connection = (Connection)m.invoke(openSQLDataSource, new Object[0]);
            connection.setAutoCommit(true);
            PreparedStatement statement = connection.prepareStatement("delete from UME_STRINGS");
            statement.execute();
            connection.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearUMAPKey() {
        Object cfgStore = null;
        try {
            PropertyEntry propEntry = this.umeSheet.getPropertyEntry("com.sap.security.core.umap.key");
            System.out.println("\n==> UMAPKey = " + propEntry.getValue());
            propEntry.setDefault((Object)"");
            propEntry.restoreDefault();
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setRoleReferences() {
        Configuration cfgApp = null;
        Configuration cfgRole = null;
        try {
            cfgApp = this.getConfiguration("security/roles/UME User Store", 1);
            try {
                cfgRole = cfgApp.getSubConfiguration("KeystoreAdministrator");
                cfgRole.deleteAllSubConfigurations();
                cfgRole.deleteAllConfigEntries();
                cfgRole.addConfigEntry("reference_policy", (Object)"SAP-J2EE-Engine");
                cfgRole.addConfigEntry("reference_role", (Object)"administrators");
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            try {
                cfgRole = cfgApp.getSubConfiguration("KeystoreViewsCreator");
                cfgRole.deleteAllSubConfigurations();
                cfgRole.deleteAllConfigEntries();
                cfgRole.addConfigEntry("reference_policy", (Object)"SAP-J2EE-Engine");
                cfgRole.addConfigEntry("reference_role", (Object)"administrators");
            }
            catch (NameNotFoundException e) {}
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            cfgApp = this.getConfiguration("security/configurations/service.naming/security/roles/UME User Store", 1);
            try {
                cfgRole = cfgApp.getSubConfiguration("jndi_all_operations");
                cfgRole.deleteAllSubConfigurations();
                cfgRole.deleteAllConfigEntries();
                cfgRole.addConfigEntry("reference_policy", (Object)"SAP-J2EE-Engine");
                cfgRole.addConfigEntry("reference_role", (Object)"administrators");
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            try {
                cfgRole = cfgApp.getSubConfiguration("jndi_get_initial_context");
                cfgRole.deleteAllSubConfigurations();
                cfgRole.deleteAllConfigEntries();
                cfgRole.addConfigEntry("reference_policy", (Object)"SAP-J2EE-Engine");
                cfgRole.addConfigEntry("reference_role", (Object)"all");
            }
            catch (NameNotFoundException e) {}
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
        try {
            cfgApp = this.getConfiguration("security/configurations/service.telnet/security/roles/UME User Store", 1);
            cfgRole = cfgApp.getSubConfiguration("telnet_login");
            cfgRole.deleteAllSubConfigurations();
            cfgRole.deleteAllConfigEntries();
            cfgRole.addConfigEntry("reference_policy", (Object)"SAP-J2EE-Engine");
            cfgRole.addConfigEntry("reference_role", (Object)"administrators");
        }
        catch (NameNotFoundException e) {
        }
        catch (ConfigurationException e) {
            e.printStackTrace();
        }
    }

    public void setXMLFiles(String policyXML, String userstoreXML) {
        String method = "setXMLFiles(String policyXML, String userstoreXML)";
        try {
            this.secSheet.deletePropertyEntry("policy.xml");
        }
        catch (NameNotFoundException e) {
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not delete policy.xml", (Throwable)e);
        }
        try {
            this.secSheet.deletePropertyEntry("userstore.xml");
        }
        catch (NameNotFoundException e) {
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not delete userstore.xml", (Throwable)e);
        }
        try {
            PropertyEntry propEntry = null;
            propEntry = this.secSheet.createSecurePropertyEntry("policy.xml", (Object)policyXML, "policy.xml");
            LOCATION.debugT("setXMLFiles(String policyXML, String userstoreXML)", "Uploaded policy.xml");
            propEntry = this.secSheet.createSecurePropertyEntry("userstore.xml", (Object)userstoreXML, "userstore.xml");
            LOCATION.debugT("setXMLFiles(String policyXML, String userstoreXML)", "Uploaded userstore.xml");
        }
        catch (NameAlreadyExistsException e) {
            LOCATION.traceThrowableT(500, "Could not upload XML files", (Throwable)e);
        }
        catch (NameNotFoundException e) {
            LOCATION.traceThrowableT(500, "Could not upload XML files", (Throwable)e);
        }
        catch (ConfigurationLockedException e) {
            LOCATION.traceThrowableT(500, "Could not upload XML files", (Throwable)e);
        }
        catch (ConfigurationException e) {
            LOCATION.traceThrowableT(500, "Could not upload XML files", (Throwable)e);
        }
    }

    public String[] getDatasourceConfigurations() {
        String[] items = new String[]{"dataSourceConfiguration_ads_deep_readonly_db.xml", "dataSourceConfiguration_ads_deep_writeable_db.xml", "dataSourceConfiguration_ads_readonly_db.xml", "dataSourceConfiguration_ads_writeable_db.xml", "dataSourceConfiguration_database_only.xml", "dataSourceConfiguration_iplanet_deep_not_readonly_db.xml", "dataSourceConfiguration_iplanet_deep_readonly_db.xml", "dataSourceConfiguration_iplanet_not_readonly_db.xml", "dataSourceConfiguration_iplanet_readonly_db.xml", "dataSourceConfiguration_novell_deep_not_readonly_db.xml", "dataSourceConfiguration_novell_deep_readonly_db.xml", "dataSourceConfiguration_novell_not_readonly_db.xml", "dataSourceConfiguration_novell_readonly_db.xml", "dataSourceConfiguration_PCDRoles.xml", "dataSourceConfiguration_r3.xml", "dataSourceConfiguration_r3_rw.xml", "dataSourceConfiguration_r3_roles_db.xml", "dataSourceConfiguration_siemens_deep_readonly_db.xml", "dataSourceConfiguration_siemens_deep_writeable_db.xml", "dataSourceConfiguration_siemens_readonly_db.xml", "dataSourceConfiguration_siemens_writeable_db.xml", "dataSourceConfiguration_textfile.xml", "dataSourceConfiguration_UMERoles.xml"};
        return items;
    }

    private Configuration getConfiguration(String configName, int mode) throws ConfigurationException {
        Configuration root = null;
        StringTokenizer tokenizer = new StringTokenizer(configName, "/");
        String rootName = tokenizer.nextToken();
        if (this.roots.containsKey(rootName)) {
            root = (Configuration)this.roots.get(rootName);
        } else {
            root = this.cfgHandler.openConfiguration(rootName, mode);
            this.roots.put(rootName, root);
        }
        if (rootName.equals(configName)) {
            return root;
        }
        return root.getSubConfiguration(configName.substring(rootName.length() + 1, configName.length()));
    }

    private void deleteConfiguration(String configName) throws ConfigurationException {
        try {
            this.getConfiguration(configName, 1).deleteConfiguration();
        }
        catch (NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DatasourceDB {
    }

    public class DatasourceABAP {
        public String getClient() {
            return this.getProperty("ume.r3.connection.master.client");
        }

        public String getUserName() {
            return this.getProperty("ume.r3.connection.master.user");
        }

        public String getPassword() {
            return this.getProperty("ume.r3.connection.master.passwd");
        }

        public String getAsHost() {
            return this.getProperty("ume.r3.connection.master.ashost");
        }

        public String getSysNr() {
            return this.getProperty("ume.r3.connection.master.sysnr");
        }

        public String getMsgHost() {
            return this.getProperty("ume.r3.connection.master.msghost");
        }

        public String getMsserv() {
            return this.getProperty("ume.r3.connection.master.msserv");
        }

        public String getGroup() {
            return this.getProperty("ume.r3.connection.master.group");
        }

        public String getR3Name() {
            return this.getProperty("ume.r3.connection.master.r3name");
        }

        public String getSncMyName() {
            return this.getProperty("ume.r3.connection.master.snc_myname");
        }

        public String getSncPartnerName() {
            return this.getProperty("ume.r3.connection.master.snc_partnername");
        }

        public String getSncLib() {
            return this.getProperty("ume.r3.connection.master.snc_lib");
        }

        public boolean isLoadBalancing() {
            return !"".equals(this.getProperty("ume.r3.connection.master.msghost")) && !"".equals(this.getProperty("ume.r3.connection.master.msserv")) && !"".equals(this.getProperty("ume.r3.connection.master.group")) && !"".equals(this.getProperty("ume.r3.connection.master.r3name"));
        }

        public boolean isSNC() {
            return "1".equals(this.getProperty("ume.r3.connection.master.snc_mode")) && !"".equals(this.getProperty("ume.r3.connection.master.snc_myname")) && !"".equals(this.getProperty("ume.r3.connection.master.snc_partnername")) && !"".equals(this.getProperty("ume.r3.connection.master.snc_lib"));
        }

        public void setClient(String client) {
            this.setProperty("ume.r3.connection.master.client", client);
        }

        public void setUser(String userName, String password) {
            this.setProperty("ume.r3.connection.master.user", userName);
            this.setProperty("ume.r3.connection.master.passwd", password);
            this.setProperty("ume.r3.connection.master.snc_mode", "0");
        }

        public void setSnc(String myName, String partnerName, String libPath) {
            this.setProperty("ume.r3.connection.master.snc_mode", "1");
            this.setProperty("ume.r3.connection.master.snc_myname", myName);
            this.setProperty("ume.r3.connection.master.snc_partnername", partnerName);
            this.setProperty("ume.r3.connection.master.snc_lib", libPath);
        }

        public void setHostSingle(String ashost, String sysnr) {
            this.setProperty("ume.r3.connection.master.ashost", ashost);
            this.setProperty("ume.r3.connection.master.sysnr", sysnr);
        }

        public void setHostLoadBalancing(String msghost, String msserv, String group, String r3name) {
            this.setProperty("ume.r3.connection.master.msghost", msghost);
            this.setProperty("ume.r3.connection.master.msserv", msserv);
            this.setProperty("ume.r3.connection.master.group", group);
            this.setProperty("ume.r3.connection.master.r3name", r3name);
        }

        private String getProperty(String key) {
            PropertyEntry propEntry = null;
            try {
                propEntry = WizardModelDB.this.umeSheet.getPropertyEntry(key);
            }
            catch (NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            return (String)propEntry.getValue();
        }

        private void setProperty(String key, String value) {
            try {
                PropertyEntry propEntry = WizardModelDB.this.umeSheet.getPropertyEntry(key);
                propEntry.setValue((Object)value);
            }
            catch (NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }

        private void validateClient(String client) throws Exception {
            try {
                int nClient = Integer.parseInt(client);
                if (nClient < 0 || nClient > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException nfe) {
                throw new Exception("sapbasis.client must be an integer in the range 0-999 (was: " + client + ")");
            }
        }

        private String[] validateSapRouter(String input) throws Exception {
            return null;
        }
    }

    public class DatasourceConfiguration {
        public Object[] getDatasources() {
            Object[] _datasources = null;
            PropertyEntry propEntry = null;
            try {
                propEntry = WizardModelDB.this.umeSheet.getPropertyEntry("ume.persistence.data_source_configuration");
            }
            catch (NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            String configName = (String)propEntry.getValue();
            if ("dataSourceConfiguration_database_only.xml".equals(configName)) {
                _datasources = new Object[]{new DatasourceDB()};
            } else if ("dataSourceConfiguration_r3_roles_db.xml".equals(configName)) {
                _datasources = new Object[]{new DatasourceDB(), new DatasourceABAP()};
            } else if ("dataSourceConfiguration_r3_rw.xml".equals(configName)) {
                _datasources = new Object[]{new DatasourceDB(), new DatasourceABAP()};
            }
            return _datasources;
        }

        public String getConfigurationXML() {
            PropertyEntry propEntry = null;
            try {
                propEntry = WizardModelDB.this.umeSheet.getPropertyEntry("ume.persistence.data_source_configuration");
            }
            catch (NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
            return (String)propEntry.getValue();
        }

        public void setConfigurationXML(String configName) {
            try {
                PropertyEntry propEntry = WizardModelDB.this.umeSheet.getPropertyEntry("ume.persistence.data_source_configuration");
                propEntry.setValue((Object)configName);
            }
            catch (NameNotFoundException e) {
                e.printStackTrace();
            }
            catch (ConfigurationException e) {
                e.printStackTrace();
            }
        }
    }
}

