/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.tools;

import com.sap.mw.jco.JCO;
import com.sap.security.roles.RoleService;
import com.sap.security.um.r3.R3UserAccount;
import com.sap.security.um.r3.R3UserFactory;
import com.sap.security.usermanagement.AuthenticationFailedException;
import com.sap.security.usermanagement.IUser;
import com.sap.security.usermanagement.NoSuchUserException;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.ConsoleLog;
import com.sap.tc.logging.FileLog;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.TraceFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class UserCheck {
    public static final int RC_UNSPECIFIED_ERROR = -2;
    public static final int RC_INVALID_ARGS = -1;
    public static final int RC_OK = 0;
    public static final int RC_NO_SUCH_USER = 1;
    public static final int RC_WRONG_PASSWORD = 2;
    public static final int RC_ROLE_NOT_ASSIGNED = 3;
    public static final int RC_RFC_ERROR = 4;
    private static final Location LOC = Location.getLocation((Class)(class$com$sap$security$tools$UserCheck == null ? (class$com$sap$security$tools$UserCheck = UserCheck.class$("com.sap.security.tools.UserCheck")) : class$com$sap$security$tools$UserCheck));
    private static final String LS = System.getProperty("line.separator");
    private static final String MSG_ENTERING = "Entering method";
    private static final String MSG_EXITING = "Exiting method";
    private final Properties _connectProps = new Properties();
    private boolean _displayUsage = false;
    private boolean _verbose = false;
    private int _returnCode = 0;
    private String _user;
    private String _role;
    private String _passwd;
    static /* synthetic */ Class class$com$sap$security$tools$UserCheck;

    public static void main(String[] args) {
        int severity;
        int defSeverity = 300;
        String s = System.getProperty("UserCheck.debug");
        if (null == s) {
            severity = 300;
        } else {
            try {
                severity = Severity.parse((String)s);
            }
            catch (IllegalArgumentException iae) {
                severity = 300;
            }
        }
        FileLog log = new FileLog("dev_usercheck", (Formatter)new TraceFormatter("%24d %-13l %s: %m"));
        log.setEffectiveSeverity(0);
        LOC.setEffectiveSeverity(severity);
        LOC.addLog((Log)log);
        String method = "main";
        LOC.pathT("main", MSG_ENTERING);
        UserCheck instance = new UserCheck();
        instance.parseArgs(args);
        if (instance._displayUsage) {
            UserCheck.usage();
        }
        if (instance._verbose) {
            log = new ConsoleLog((Formatter)new TraceFormatter("%m"));
            log.setEffectiveSeverity(0);
            LOC.addLog((Log)log);
        }
        if (-1 != instance._returnCode) {
            instance.doCheck();
        }
        LOC.infoT("main", "Return Code: " + instance._returnCode);
        LOC.pathT("main", MSG_EXITING);
        System.exit(instance._returnCode);
    }

    private static void usage() {
        String method = "usage";
        LOC.pathT("usage", MSG_ENTERING);
        String USAGE = "Usage: java " + (class$com$sap$security$tools$UserCheck == null ? (class$com$sap$security$tools$UserCheck = UserCheck.class$("com.sap.security.tools.UserCheck")) : class$com$sap$security$tools$UserCheck).getName() + " OPTIONS..." + LS + "Check existence, password, and/or role assignment of an ABAP user" + LS + LS + "  -u ID              verify user existence               (required)" + LS + "  -p PASSWD          verify user/password combination    (optional)" + LS + "  -r ROLE            verify role assignment              (optional)" + LS + "  -c KEY=VALUE       specifies a connect property        (required)" + LS + "  -h                 display this help                   (optional)" + LS + "  -v                 verbose                             (optional)" + LS + LS + "Example Connect Properties" + LS + "--------------------------" + LS + "  ashost             application server hostname" + LS + "  sysnr              system number" + LS + "  mshost             message server hostname" + LS + "  group              logon group (CASE SENSITIVE)" + LS + "  r3name             system ID" + LS + "  msserv             message server port number" + LS + "  user               communication user ID" + LS + "  passwd             communication user password" + LS + "  client             three digit number of logical system" + LS + "All given arguments will be passed as is to the Java Connector.";
        System.out.println(USAGE);
        LOC.pathT("usage", MSG_EXITING);
    }

    private static String t2s(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private UserCheck() {
    }

    private void parseArgs(String[] args) {
        String method = "parseArgs";
        LOC.pathT("parseArgs", MSG_ENTERING);
        try {
            int i = 0;
            while (i < args.length) {
                if ("-c".equals(args[i])) {
                    String value;
                    String key;
                    String arg;
                    int idx;
                    if (-1 != (idx = (arg = args[++i]).indexOf(61))) {
                        key = arg.substring(0, idx);
                        value = idx < arg.length() - 1 ? arg.substring(idx + 1) : "";
                    } else {
                        throw new Exception("Invalid connect property: " + arg + " Required: KEY=VALUE");
                    }
                    this._connectProps.setProperty(key, value);
                    if (-1 != key.indexOf("passw")) {
                        value = "********";
                    }
                    LOC.infoT("parseArgs", "Added connect property: " + key + "=" + value);
                } else if ("-u".equals(args[i])) {
                    this._user = args[++i];
                    LOC.infoT("parseArgs", "ABAP user ID: " + this._user);
                } else if ("-p".equals(args[i])) {
                    this._passwd = args[++i];
                    LOC.infoT("parseArgs", "ABAP user password: ********");
                } else if ("-r".equals(args[i])) {
                    this._role = args[++i].toUpperCase();
                    LOC.infoT("parseArgs", "Role of ABAP user: " + this._role);
                } else if ("-h".equals(args[i])) {
                    this._displayUsage = true;
                    LOC.infoT("parseArgs", "Help message will be written to stdout");
                } else if ("-v".equals(args[i])) {
                    this._verbose = true;
                    LOC.infoT("parseArgs", "Diagnostic messages will be written to stderr");
                } else {
                    LOC.errorT("parseArgs", "Unexpected argument: " + args[i]);
                    throw new Exception();
                }
                ++i;
            }
            if (((Hashtable)this._connectProps).isEmpty()) {
                LOC.errorT("parseArgs", "No connect properties specified");
                throw new Exception();
            }
            if (null == this._user) {
                LOC.errorT("parseArgs", "No ABAP user ID specified");
                throw new Exception();
            }
        }
        catch (Exception e) {
            LOC.debugT("parseArgs", UserCheck.t2s(e));
            this._displayUsage = true;
            this._returnCode = -1;
        }
        LOC.pathT("parseArgs", MSG_EXITING);
    }

    private void doCheck() {
        String method = "doCheck";
        LOC.pathT("doCheck", MSG_ENTERING);
        try {
            SAPBasis sapBasis = new SAPBasis(this._connectProps);
            R3UserFactory factory = new R3UserFactory(sapBasis, null);
            IUser principal = null;
            LOC.debugT("doCheck", "sapBasis = " + sapBasis);
            LOC.debugT("doCheck", "factory = " + factory);
            LOC.pathT("doCheck", "Performing existence check");
            principal = factory.getUser(this._user);
            LOC.infoT("doCheck", "User exists: YES");
            LOC.debugT("doCheck", "principal = " + principal);
            if (null != this._passwd) {
                LOC.pathT("doCheck", "Performing password verification");
                HashMap<String, String> credentials = new HashMap<String, String>();
                credentials.put("com.sap.security.SAPUser", this._user);
                credentials.put("com.sap.security.SAPPassword", this._passwd);
                R3UserAccount account = (R3UserAccount)factory.getAuthenticatedUserAccount(credentials);
                LOC.infoT("doCheck", "User/Password combination is correct: YES");
                LOC.debugT("doCheck", "account = " + account);
            }
            if (null != this._role) {
                LOC.pathT("doCheck", "Performing role assignment verification");
                RoleService roleService = new RoleService(sapBasis);
                LOC.debugT("doCheck", "roleService = " + roleService);
                Object[] roles = roleService.getAssignedRoleNames(principal);
                LOC.debugT("doCheck", "roles = " + Arrays.asList(roles));
                if (Arrays.binarySearch(roles, this._role) < 0) {
                    this._returnCode = 3;
                    LOC.infoT("doCheck", "User is assigned to role: NO");
                } else {
                    LOC.infoT("doCheck", "User is assigned to role: YES");
                }
            }
        }
        catch (NoSuchUserException e1) {
            LOC.infoT("doCheck", "User exists: NO");
            LOC.debugT("doCheck", UserCheck.t2s(e1));
            this._returnCode = 1;
        }
        catch (AuthenticationFailedException e2) {
            LOC.infoT("doCheck", "User/Password combination is correct: NO");
            LOC.debugT("doCheck", UserCheck.t2s(e2));
            this._returnCode = 2;
        }
        catch (JCO.Exception e3) {
            LOC.errorT("doCheck", "Remote Function Call failed:" + LS + UserCheck.t2s(e3));
            this._returnCode = 4;
        }
        catch (Throwable t) {
            LOC.errorT("doCheck", "An unspecified error occured:" + LS + UserCheck.t2s(t));
            LOC.errorT("doCheck", UserCheck.t2s(t));
            this._returnCode = -2;
        }
        LOC.pathT("doCheck", MSG_EXITING);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

