/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.sso;

import com.sap.mw.jco.JCO;
import com.sap.security.um.SSOUser;
import com.sap.security.usermanagement.UMException;
import com.sap.security.util.LogUtil;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.Location;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

public class ConnectionFactory {
    private static final String JCO_CLIENT = "jco.client.client";
    private static final String JCO_USER = "jco.client.user";
    private static final String JCO_PASSWD = "jco.client.passwd";
    private static final String JCO_TYPE = "jco.client.type";
    private static final String JCO_PROFILE_NAME = "jco.client.profile_name";
    private static final String JCO_MYSAPSSO2 = "jco.client.mysapsso2";
    private static final String JCO_GETSSO2 = "jco.client.getsso2";
    private static final String JCO_X509CERT = "jco.client.x509cert";
    private static final String JCO_EXTIDDATA = "jco.client.extiddata";
    private static final String JCO_EXTIDTYPE = "jco.client.extidtype";
    private static final String JCO_SNC_PARTNERNAME = "jco.client.snc_partnername";
    private static final String JCO_SNC_QOP = "jco.client.snc_qop";
    private static final String JCO_SNC_MYNAME = "jco.client.snc_myname";
    private static final String JCO_SNC_MODE = "jco.client.snc_mode";
    private static final String JCO_SNC_LIBRARY = "jco.client.snc_lib";
    private static final String M0 = "<clinit>";
    private static final String M1 = "ConnectionFactory()";
    private static final String M2 = "getConnection(Principal,Properties)";
    private static final String M3 = "getConnection(Principal)";
    private static final String SAP_PROFILE = "SAPPROFILE";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$sso$ConnectionFactory == null ? (class$com$sap$security$sso$ConnectionFactory = ConnectionFactory.class$("com.sap.security.sso.ConnectionFactory")) : class$com$sap$security$sso$ConnectionFactory));
    private static final LogUtil LOG_UTIL = new LogUtil(LOCATION, null);
    private Properties m_defaultConnectionSpec;
    static /* synthetic */ Class class$com$sap$security$sso$ConnectionFactory;

    public ConnectionFactory() {
        SAPBasis sapBasis = SAPBasis.getSAPBasis();
        if (sapBasis == null) {
            LOCATION.warningT(M1, "No default connection spec available");
        } else {
            Properties p = null;
            String profileName = System.getProperty(SAP_PROFILE);
            if (profileName != null && !"".equals(profileName)) {
                p = new Properties();
                p.setProperty(JCO_TYPE, "F");
                p.setProperty(JCO_PROFILE_NAME, profileName);
                p.setProperty(JCO_CLIENT, sapBasis.getClientID());
            } else {
                JCO.Client client = null;
                try {
                    client = sapBasis.getClient();
                    p = client.getProperties();
                    Object var6_5 = null;
                    if (client != null) {
                        sapBasis.releaseClient(client);
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (client != null) {
                        sapBasis.releaseClient(client);
                    }
                    throw throwable;
                }
                this.removeAuthData(p);
            }
            LOCATION.infoT(M1, "Using default connection spec: " + p);
            this.m_defaultConnectionSpec = p;
        }
    }

    public JCO.Client getConnection(Principal principal, Properties connectionSpec) throws UMException {
        String b64Ticket = this.getTicket(principal, M2);
        Properties p = new Properties();
        ((Hashtable)p).putAll(connectionSpec);
        this.removeAuthData(p);
        p.setProperty(JCO_MYSAPSSO2, b64Ticket);
        return JCO.createClient((Properties)p);
    }

    public JCO.Client getConnection(Principal principal) throws UMException {
        if (this.m_defaultConnectionSpec == null) {
            throw (UMException)LOG_UTIL.logException(new UMException("No default connection spec available"), M3);
        }
        String b64Ticket = this.getTicket(principal, M3);
        Properties p = new Properties();
        ((Hashtable)p).putAll(this.m_defaultConnectionSpec);
        p.setProperty(JCO_MYSAPSSO2, b64Ticket);
        return JCO.createClient((Properties)p);
    }

    private String getTicket(Principal principal, String subLoc) throws UMException {
        if (!(principal instanceof SSOUser)) {
            throw (UMException)LOG_UTIL.logException(new UMException("Unsupported principal class: " + principal != null ? principal.getClass().getName() : "null"), subLoc);
        }
        Map credentials = ((SSOUser)((Object)principal)).getCredentials();
        if (credentials == null) {
            throw (UMException)LOG_UTIL.logException(new UMException("No credentials available for " + principal), subLoc);
        }
        String b64Ticket = (String)credentials.get("com.sap.security.SAPLogonTicket");
        if (b64Ticket == null) {
            throw (UMException)LOG_UTIL.logException(new UMException("No SAP Logon Ticket available for " + principal), subLoc);
        }
        return b64Ticket;
    }

    private void removeAuthData(Properties p) {
        ((Hashtable)p).remove(JCO_USER);
        ((Hashtable)p).remove(JCO_PASSWD);
        ((Hashtable)p).remove(JCO_GETSSO2);
        ((Hashtable)p).remove(JCO_X509CERT);
        ((Hashtable)p).remove(JCO_EXTIDDATA);
        ((Hashtable)p).remove(JCO_EXTIDTYPE);
        ((Hashtable)p).remove(JCO_MYSAPSSO2);
        ((Hashtable)p).remove(JCO_SNC_LIBRARY);
        ((Hashtable)p).remove(JCO_SNC_MODE);
        ((Hashtable)p).remove(JCO_SNC_MYNAME);
        ((Hashtable)p).remove(JCO_SNC_PARTNERNAME);
        ((Hashtable)p).remove(JCO_SNC_QOP);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (LOCATION.beDebug()) {
            LOCATION.debugT(M0, "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/sso/ConnectionFactory.java#1 $ from $DateTime: 2004/03/08 16:48:25 $ ($Change: 14740 $)");
        }
    }
}

