/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.roles;

import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import com.sap.security.roles.IRole;
import com.sap.security.roles.IRoleService;
import com.sap.security.roles.Role;
import com.sap.security.util.LogUtil;
import com.sap.security.util.SAPBasis;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;

public class RoleService
implements IRoleService {
    private static final String M1 = "getAssignedRoleNames(Principal)";
    private static final String M2 = "getRoles(Principal,Locale,boolean)";
    private static final String M3 = "setRelevant(String[],boolean)";
    private static final String M4 = "getRoles(Locale,boolean)";
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$security$roles$RoleService == null ? (class$com$sap$security$roles$RoleService = RoleService.class$("com.sap.security.roles.RoleService")) : class$com$sap$security$roles$RoleService));
    private SAPBasis m_sapBasis;
    private boolean m_replaceDerived = true;
    private boolean m_debug;
    private Category m_category = Category.getCategory((String)"/Security/SAPRoles");
    private LogUtil m_logUtil = new LogUtil(LOCATION, this.m_category);
    static /* synthetic */ Class class$com$sap$security$roles$RoleService;

    public RoleService(SAPBasis sapBasis) {
        this.m_sapBasis = sapBasis;
    }

    public String[] getAssignedRoleNames(Principal principal) {
        if (LOCATION.bePath()) {
            LOCATION.entering(M1, new Object[]{principal});
        }
        JCO.Function function = null;
        JCO.Table tabRoles = null;
        JCO.Table tabReturn = null;
        Object[] roles = null;
        try {
            String name = RoleService.charWiseToUpperCase(principal.getName());
            IRepository repository = this.m_sapBasis.getRepository();
            function = repository.getFunctionTemplate("PRGN_J2EE_USER_GET_ROLENAMES").getFunction();
            JCO.ParameterList imports = function.getImportParameterList();
            imports.setValue(name, "IF_UNAME");
            if (this.m_replaceDerived) {
                imports.setValue("X", "IF_REPLACE_DERIVED");
            }
            JCO.Client client = this.m_sapBasis.getClient();
            try {
                client.execute(function);
                Object var11_11 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M1);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M1);
                throw throwable;
            }
            JCO.ParameterList tables = function.getTableParameterList();
            tabReturn = tables.getTable("ET_RETURN");
            int i = 0;
            while (i < tabReturn.getNumRows()) {
                tabReturn.setRow(i);
                String msgType = tabReturn.getString("TYPE");
                int severity = 0;
                severity = "W".equals(msgType) ? 400 : ("I".equals(msgType) || "S".equals(msgType) ? 300 : 500);
                if (LOCATION.beLogged(severity)) {
                    LOCATION.logT(severity, this.m_category, M1, tabReturn.getString("MESSAGE"));
                }
                ++i;
            }
            tabRoles = tables.getTable("ET_AGR");
            int nRoles = tabRoles.getNumRows();
            roles = new String[nRoles];
            int i2 = 0;
            while (i2 < nRoles) {
                tabRoles.setRow(i2);
                roles[i2] = tabRoles.getString("AGR_NAME");
                ++i2;
            }
        }
        catch (JCO.Exception e) {
            throw (JCO.Exception)this.m_logUtil.logException(e, M1);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M1);
        }
        Arrays.sort(roles);
        return roles;
    }

    public IRole[] getRoles(Locale locale, boolean onlyRelevant) {
        if (LOCATION.bePath()) {
            LOCATION.entering(M4, new Object[]{locale, onlyRelevant ? Boolean.TRUE : Boolean.FALSE});
        }
        JCO.Function function = null;
        JCO.Table tabRoles = null;
        JCO.Table tabCollRoles = null;
        JCO.Table tabReturn = null;
        HashMap<String, Role> mpRoles = null;
        try {
            String language = locale != null ? locale.getLanguage().toUpperCase() : null;
            IRepository repository = this.m_sapBasis.getRepository();
            function = repository.getFunctionTemplate("PRGN_J2EE_GET_ROLES").getFunction();
            JCO.ParameterList imports = function.getImportParameterList();
            if (language != null) {
                imports.setValue(language.toUpperCase(), "IF_LAISO");
            }
            if (onlyRelevant) {
                imports.setValue("X", "IF_J2EE_ONLY");
            }
            if (this.m_replaceDerived) {
                imports.setValue("X", "IF_REPLACE_DERIVED");
            }
            JCO.Client client = this.m_sapBasis.getClient();
            try {
                client.execute(function);
                Object var13_13 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M4);
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M4);
                throw throwable;
            }
            JCO.ParameterList tables = function.getTableParameterList();
            tabReturn = tables.getTable("ET_RETURN");
            int i = 0;
            while (i < tabReturn.getNumRows()) {
                tabReturn.setRow(i);
                String msgType = tabReturn.getString("TYPE");
                int severity = 0;
                severity = "W".equals(msgType) ? 400 : ("I".equals(msgType) || "S".equals(msgType) ? 300 : 500);
                if (LOCATION.beLogged(severity)) {
                    LOCATION.logT(severity, this.m_category, M4, tabReturn.getString("MESSAGE"));
                }
                ++i;
            }
            tabRoles = tables.getTable("ET_AGR");
            tabCollRoles = tables.getTable("ET_COLL_AGR");
            int nRoles = tabRoles.getNumRows();
            mpRoles = new HashMap<String, Role>(nRoles);
            int i2 = 0;
            while (i2 < nRoles) {
                tabRoles.setRow(i2);
                Role role = new Role(tabRoles.getString("AGR_NAME"));
                role.setDescription(tabRoles.getString("TEXT"));
                role.setRelevant("X".equals(tabRoles.getString("FLAG_J2EE")));
                mpRoles.put(role.getName(), role);
                ++i2;
            }
            int nCollRoles = tabCollRoles.getNumRows();
            int i3 = 0;
            while (i3 < nCollRoles) {
                tabCollRoles.setRow(i3);
                String strCollRole = tabCollRoles.getString("COLL_AGR");
                String strChildRole = tabCollRoles.getString("CHILD_AGR");
                Role collRole = (Role)mpRoles.get(strCollRole);
                Role childRole = (Role)mpRoles.get(strChildRole);
                if (collRole != null && childRole != null) {
                    collRole.addChild(childRole);
                } else if (LOCATION.beWarning()) {
                    StringBuffer sb = new StringBuffer();
                    if (collRole == null) {
                        sb.append("No definition for collective role ");
                        sb.append(strCollRole).append(" was returned.\n");
                    }
                    if (childRole == null) {
                        sb.append("No definition for child role ");
                        sb.append(strChildRole).append(" (contained in ");
                        sb.append(strCollRole).append(") was returned.\n");
                    }
                    LOCATION.warningT(this.m_category, M4, sb.toString());
                }
                ++i3;
            }
        }
        catch (JCO.Exception e) {
            throw (JCO.Exception)this.m_logUtil.logException(e, M4);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M4);
        }
        IRole[] roles = mpRoles.values().toArray(new IRole[mpRoles.size()]);
        Arrays.sort(roles, Role.COMPARATOR);
        return roles;
    }

    public IRole[] getRoles(Principal principal, Locale locale, boolean onlyRelevant) {
        if (LOCATION.bePath()) {
            LOCATION.entering(M2, new Object[]{principal, locale, onlyRelevant ? Boolean.TRUE : Boolean.FALSE});
        }
        if (principal == null) {
            if (LOCATION.bePath()) {
                LOCATION.exiting(M2);
            }
            return this.getRoles(locale, onlyRelevant);
        }
        JCO.Function function = null;
        JCO.Table tabRoles = null;
        JCO.Table tabCollRoles = null;
        JCO.Table tabReturn = null;
        HashMap<String, Role> mpRoles = null;
        try {
            String language = locale != null ? locale.getLanguage().toUpperCase() : null;
            IRepository repository = this.m_sapBasis.getRepository();
            function = repository.getFunctionTemplate("PRGN_J2EE_USER_GET_ROLES").getFunction();
            JCO.ParameterList imports = function.getImportParameterList();
            imports.setValue(principal.getName().toUpperCase(), "IF_UNAME");
            if (language != null) {
                imports.setValue(language.toUpperCase(), "IF_LAISO");
            }
            if (onlyRelevant) {
                imports.setValue("X", "IF_J2EE_ONLY");
            }
            if (this.m_replaceDerived) {
                imports.setValue("X", "IF_REPLACE_DERIVED");
            }
            JCO.Client client = this.m_sapBasis.getClient();
            try {
                client.execute(function);
                Object var14_14 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M2);
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M2);
                throw throwable;
            }
            JCO.ParameterList tables = function.getTableParameterList();
            tabReturn = tables.getTable("ET_RETURN");
            int i = 0;
            while (i < tabReturn.getNumRows()) {
                tabReturn.setRow(i);
                String msgType = tabReturn.getString("TYPE");
                int severity = 0;
                severity = "W".equals(msgType) ? 400 : ("I".equals(msgType) || "S".equals(msgType) ? 300 : 500);
                if (LOCATION.beLogged(severity)) {
                    LOCATION.logT(severity, this.m_category, M2, tabReturn.getString("MESSAGE"));
                }
                ++i;
            }
            tabRoles = tables.getTable("ET_AGR");
            tabCollRoles = tables.getTable("ET_COLL_AGR");
            int nRoles = tabRoles.getNumRows();
            mpRoles = new HashMap<String, Role>(nRoles);
            HashMap<String, Role> mpRolesViaColl = new HashMap<String, Role>();
            int i2 = 0;
            while (i2 < nRoles) {
                tabRoles.setRow(i2);
                Role role = new Role(tabRoles.getString("AGR_NAME"));
                role.setDescription(tabRoles.getString("TEXT"));
                role.setRelevant("X".equals(tabRoles.getString("FLAG_J2EE")));
                if ("X".equals(tabRoles.getString("FLAG_VIA_COLL"))) {
                    mpRolesViaColl.put(role.getName(), role);
                } else {
                    mpRoles.put(role.getName(), role);
                }
                ++i2;
            }
            int nCollRoles = tabCollRoles.getNumRows();
            int i3 = 0;
            while (i3 < nCollRoles) {
                tabCollRoles.setRow(i3);
                String strCollRole = tabCollRoles.getString("COLL_AGR");
                String strChildRole = tabCollRoles.getString("CHILD_AGR");
                Role collRole = (Role)mpRoles.get(strCollRole);
                Role childRole = (Role)mpRolesViaColl.get(strChildRole);
                if (collRole != null && childRole != null) {
                    collRole.addChild(childRole);
                } else if (LOCATION.beWarning()) {
                    StringBuffer sb = new StringBuffer();
                    if (collRole == null) {
                        sb.append("No definition for collective role ");
                        sb.append(strCollRole).append(" was returned.\n");
                    }
                    if (childRole == null) {
                        sb.append("No definition for child role ");
                        sb.append(strChildRole).append(" (contained in ");
                        sb.append(strCollRole).append(") was returned.\n");
                    }
                    LOCATION.warningT(this.m_category, M2, sb.toString());
                }
                ++i3;
            }
        }
        catch (JCO.Exception e) {
            throw (JCO.Exception)this.m_logUtil.logException(e, M2);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M2);
        }
        IRole[] roles = mpRoles.values().toArray(new IRole[mpRoles.size()]);
        Arrays.sort(roles, Role.COMPARATOR);
        return roles;
    }

    public void setRelevant(String[] roleNames, boolean relevant) {
        if (LOCATION.bePath()) {
            LOCATION.entering(M3, new Object[]{roleNames, relevant ? Boolean.TRUE : Boolean.FALSE});
        }
        JCO.Function function = null;
        JCO.Table tabRoles = null;
        JCO.Table tabReturn = null;
        try {
            IRepository repository = this.m_sapBasis.getRepository();
            function = repository.getFunctionTemplate("PRGN_J2EE_SET_ROLE_FLAG").getFunction();
            JCO.ParameterList tables = function.getTableParameterList();
            tabRoles = tables.getTable("IT_AGR");
            String flag = relevant ? "X" : null;
            int i = 0;
            while (i < roleNames.length) {
                if (roleNames[i] != null) {
                    tabRoles.appendRow();
                    tabRoles.setValue(roleNames[i].toUpperCase(), "AGR_NAME");
                    tabRoles.setValue(flag, "FLAG_J2EE");
                }
                ++i;
            }
            JCO.Client client = this.m_sapBasis.getClient();
            try {
                client.execute(function);
                Object var12_12 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M3);
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                if (client != null) {
                    this.m_sapBasis.releaseClient(client);
                }
                this.m_logUtil.logFunction(function, M3);
                throw throwable;
            }
            tabReturn = tables.getTable("ET_RETURN");
            int i2 = 0;
            while (i2 < tabReturn.getNumRows()) {
                tabReturn.setRow(i2);
                String msgType = tabReturn.getString("TYPE");
                int severity = 0;
                severity = "W".equals(msgType) ? 400 : ("I".equals(msgType) || "S".equals(msgType) ? 300 : 500);
                if (LOCATION.beLogged(severity)) {
                    LOCATION.logT(severity, this.m_category, M3, tabReturn.getString("MESSAGE"));
                }
                ++i2;
            }
        }
        catch (JCO.Exception e) {
            throw (JCO.Exception)this.m_logUtil.logException(e, M3);
        }
        if (LOCATION.bePath()) {
            LOCATION.exiting(M3);
        }
    }

    void setDebug(boolean debug) {
        this.m_debug = debug;
    }

    public void setReplaceDerivedRoles(boolean replace) {
        this.m_replaceDerived = replace;
    }

    public void setLogCategory(String logCategory) {
        this.m_category = Category.getCategory((String)logCategory);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(':');
        sb.append("\n   SAP Basis: ").append(this.m_sapBasis);
        sb.append("\n   Replace Derived Roles: ").append(this.m_replaceDerived);
        sb.append("\n   Log Category: ").append(this.m_category.getName());
        sb.append("\n   Debugging Enabled: ").append(this.m_debug);
        return sb.toString();
    }

    private static String charWiseToUpperCase(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(in.length());
        int i = 0;
        while (i < in.length()) {
            buf.append(Character.toUpperCase(in.charAt(i)));
            ++i;
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (LOCATION.beDebug()) {
            LOCATION.debugT("<clinit>", "$Id: //shared_tc/com.sap.security.core.server/630_VAL_REL/src/_compat/java/_core/com/sap/security/roles/RoleService.java#2 $ from $DateTime: 2004/06/09 16:32:00 $ ($Change: 16221 $)");
        }
    }
}

