/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.timer.j2ee;

import com.sap.engine.services.jmx.timer.j2ee.Timer;
import com.sap.engine.services.jmx.timer.j2ee.TimerFactoryMBean;
import com.sap.engine.services.timeout.TimeoutManager;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class TimerFactory
implements TimerFactoryMBean,
MBeanRegistration {
    public static final String TIMER_TYPE_PROPERTY = "timer.type";
    public static final String TIMER_TYPE_J2EE_SYSTEM = "J2EE.SystemTimer";
    public static final String TIMER_TYPE_J2EE_APPLICATION = "J2EE.ApplicationTimer";
    MBeanServer mbs;
    TimeoutManager timeoutManager;

    public TimerFactory(TimeoutManager timeoutManager) {
        this.timeoutManager = timeoutManager;
    }

    public ObjectInstance createTimer(ObjectName name, boolean useSystemThreads) throws JMException {
        Timer timer = new Timer(this.timeoutManager, useSystemThreads);
        timer.setMyName(name);
        return this.mbs.registerMBean(timer, name);
    }

    public ObjectInstance createTimer(ObjectName name) throws JMException {
        Timer timer = new Timer(this.timeoutManager, false);
        timer.setMyName(name);
        return this.mbs.registerMBean(timer, name);
    }

    public ObjectName preRegister(MBeanServer mbs, ObjectName objectName) throws Exception {
        this.mbs = mbs;
        return objectName;
    }

    public void postRegister(Boolean arg0) {
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
}

