/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.timer.j2ee;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.timer.SynchronousTimerNotification;
import com.sap.engine.services.jmx.timer.j2ee.TimerNotificationEntry;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.engine.services.timeout.TimeoutManager;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;

public class Timer
extends javax.management.timer.Timer
implements TimerMBean {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$timer$j2ee$Timer == null ? (class$com$sap$engine$services$jmx$timer$j2ee$Timer = Timer.class$("com.sap.engine.services.jmx.timer.j2ee.Timer")) : class$com$sap$engine$services$jmx$timer$j2ee$Timer));
    private int sequenceNumber;
    private boolean sendPastNotifications = false;
    TimeoutManager timeoutManager;
    private final Hashtable notifications = new Hashtable();
    boolean useSystemThreads;
    boolean isActive;
    String myName = "";
    private int counterID = 0;
    static /* synthetic */ Class class$com$sap$engine$services$jmx$timer$j2ee$Timer;

    public Timer(TimeoutManager timeoutManager, boolean useSystemThreads) {
        this.useSystemThreads = useSystemThreads;
        this.timeoutManager = timeoutManager;
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, "new Timer(useSystemThreads = " + useSystemThreads + ")");
        }
    }

    public Timer(TimeoutManager timeoutManager) {
        this(timeoutManager, false);
    }

    public void setMyName(ObjectName name) {
        if (name != null) {
            this.myName = "[Timer-" + name.toString() + "] ";
        }
    }

    public synchronized void start() {
        if (!this.isActive) {
            if (LOCATION.beLogged(200)) {
                LOCATION.logT(200, this.myName + "starting ...");
            }
            Date currentDate = new Date();
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, this.myName + "starting ... 1. send all past notifications");
            }
            this.sendPastNotifications(currentDate, this.sendPastNotifications);
            this.isActive = true;
            if (LOCATION.beLogged(100)) {
                LOCATION.logT(100, this.myName + "starting ... 2. activate all live notifications");
            }
            Enumeration e = this.notifications.elements();
            while (e.hasMoreElements()) {
                TimerNotificationEntry entry = (TimerNotificationEntry)e.nextElement();
                this.activate(entry, currentDate);
            }
            if (LOCATION.beLogged(200)) {
                LOCATION.logT(200, this.myName + "starting ... OK");
            }
        } else if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "already started");
        }
    }

    public synchronized void stop() {
        if (this.isActive) {
            if (LOCATION.beLogged(200)) {
                LOCATION.logT(200, this.myName + "stop");
            }
            this.removeAllNotifications();
            this.isActive = false;
        } else if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "already stopped");
        }
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences, boolean fixedRate) throws IllegalArgumentException {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "addNotification(" + "type=" + type + " message=" + message + " userData=" + userData + " date=" + date + " period=" + period + " nbOccurences=" + nbOccurences + " fixedRate=" + fixedRate);
        }
        if (date == null) {
            throw new IllegalArgumentException("Timer notification date cannot be null.");
        }
        if (period < 0L || nbOccurences < 0L) {
            throw new IllegalArgumentException("Negative values for the periodicity");
        }
        Date currentDate = new Date();
        if (currentDate.after(date)) {
            date.setTime(currentDate.getTime());
        }
        Integer notifID = new Integer(++this.counterID);
        date = new Date(date.getTime());
        TimerNotificationEntry notifEntry = new TimerNotificationEntry(type, message, userData, date, period, nbOccurences, fixedRate, notifID, this);
        this.notifications.put(notifID, notifEntry);
        this.activate(notifEntry, currentDate);
        return notifID;
    }

    void activate(TimerNotificationEntry notifEntry, Date currentDate) {
        if (this.isActive) {
            if (LOCATION.beLogged(200)) {
                LOCATION.logT(200, this.myName + "activate: " + notifEntry + "  currentDate=" + currentDate);
            }
            long delayTime = notifEntry.date.getTime() - currentDate.getTime();
            if (notifEntry.fixedRate) {
                this.timeoutManager.registerTimeoutListener((TimeoutListener)notifEntry, false, delayTime, notifEntry.period, notifEntry.nbOccurences, this.useSystemThreads);
            } else {
                this.timeoutManager.registerTimeoutListener((TimeoutListener)notifEntry, true, delayTime, notifEntry.period, notifEntry.nbOccurences, this.useSystemThreads);
            }
        }
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period, long nbOccurences) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, nbOccurences, false);
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public synchronized Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L, 0L);
    }

    public synchronized void removeNotification(Integer id) throws InstanceNotFoundException {
        TimerNotificationEntry e;
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "removeNotification(id=" + id + ")");
        }
        if ((e = (TimerNotificationEntry)this.notifications.remove(id)) == null) {
            throw new InstanceNotFoundException("Timer notification to remove not in the list of notifications");
        }
        e.cancel();
    }

    public synchronized void removeNotifications(String type) throws InstanceNotFoundException {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "removeNotifications(type=" + type + ")");
        }
        int removed = 0;
        Enumeration enumeration = this.notifications.keys();
        while (enumeration.hasMoreElements()) {
            TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(enumeration.nextElement());
            String et = e.type;
            if ((type != null || et != null) && (type == null || !type.equals(et))) continue;
            e.cancel();
            ++removed;
        }
        if (removed == 0) {
            throw new InstanceNotFoundException("Timer notifications to remove not in the list of notifications");
        }
    }

    public synchronized void removeAllNotifications() {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "removeAllNotifications()");
        }
        Enumeration enumeration = this.notifications.keys();
        while (enumeration.hasMoreElements()) {
            TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(enumeration.nextElement());
            e.cancel();
        }
    }

    public int getNbNotifications() {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "getNbNotifications()");
        }
        return this.notifications.size();
    }

    public synchronized Vector getAllNotificationIDs() {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "getAllNotificationIDs()");
        }
        Enumeration enumeration = this.notifications.keys();
        Vector result = new Vector(this.notifications.size());
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }

    public synchronized Vector getNotificationIDs(String type) {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "getNotificationIDs(type=" + type + ")");
        }
        Enumeration enumeration = this.notifications.keys();
        Vector result = new Vector(this.notifications.size());
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(key);
            String et = e.type;
            if ((type != null || et != null) && (type == null || !type.equals(et))) continue;
            result.add(key);
        }
        return result;
    }

    public String getNotificationType(Integer id) {
        TimerNotificationEntry e;
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "getNotificationType(id=" + id + ")");
        }
        if ((e = (TimerNotificationEntry)this.notifications.get(id)) != null) {
            return e.type;
        }
        return null;
    }

    public String getNotificationMessage(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return e.message;
        }
        return null;
    }

    public Object getNotificationUserData(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return e.userData;
        }
        return null;
    }

    public Date getDate(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return e.date;
        }
        return null;
    }

    public Long getPeriod(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return new Long(e.period);
        }
        return null;
    }

    public Long getNbOccurences(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return new Long(e.nbOccurences);
        }
        return null;
    }

    public Boolean getFixedRate(Integer id) {
        TimerNotificationEntry e = (TimerNotificationEntry)this.notifications.get(id);
        if (e != null) {
            return new Boolean(e.fixedRate);
        }
        return null;
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public void setSendPastNotifications(boolean value) {
        this.sendPastNotifications = value;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isEmpty() {
        return this.notifications.isEmpty();
    }

    void removeMe(TimerNotificationEntry e) {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "removeMe: " + e);
        }
        this.notifications.remove(e.notifID);
        this.timeoutManager.unregisterTimeoutListener((TimeoutListener)e);
    }

    void sendTimerNotification(TimerNotificationEntry e) {
        long curSeqNumber;
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "sendTimerNotification: " + e);
        }
        Timer timer = this;
        synchronized (timer) {
            ++this.sequenceNumber;
            curSeqNumber = this.sequenceNumber;
        }
        SynchronousTimerNotification notification = new SynchronousTimerNotification(e.type, this, curSeqNumber, e.date.getTime(), e.message, e.notifID);
        notification.setUserData(e.userData);
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "sendTimerNotification: " + notification);
        }
        try {
            this.sendNotification(notification);
        }
        catch (RuntimeException ex) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)(this.myName + "unable to send timer notification: " + notification + " reason: " + this.toString()), (Throwable)ex);
        }
    }

    private synchronized void sendPastNotifications(Date currentDate, boolean currentFlag) {
        if (LOCATION.beLogged(200)) {
            LOCATION.logT(200, this.myName + "sendPastNotifications ... currentDate=" + currentDate);
        }
        Enumeration e = this.notifications.elements();
        while (e.hasMoreElements()) {
            TimerNotificationEntry entry = (TimerNotificationEntry)e.nextElement();
            if (LOCATION.beLogged(200)) {
                LOCATION.logT(200, this.myName + "sendPastNotifications ... entry=" + entry);
            }
            Integer notifID = entry.notifID;
            boolean processEntry = this.notifications.containsKey(notifID);
            while (currentDate.after(entry.date) && processEntry) {
                if (currentFlag) {
                    if (LOCATION.beLogged(200)) {
                        LOCATION.logT(200, this.myName + "sendPastNotification: " + entry);
                    }
                    this.sendTimerNotification(entry);
                }
                if (LOCATION.beLogged(200)) {
                    LOCATION.logT(200, this.myName + "update: " + entry);
                }
                processEntry = entry.update();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

