/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.timer;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.timer.SynchronousTimerNotification;
import com.sap.engine.services.jmx.timer.SystemTimer;
import com.sap.engine.services.timeout.TimeoutListener;
import com.sap.pj.jmx.timer.AbstractTimerNotificationInfo;
import com.sap.pj.jmx.timer.NumberGenerator;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Date;
import javax.management.timer.Timer;
import javax.management.timer.TimerNotification;

public class TimerNotificationInfo
extends AbstractTimerNotificationInfo
implements TimeoutListener {
    private final boolean systemTimer;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$timer$TimerNotificationInfo == null ? (class$com$sap$engine$services$jmx$timer$TimerNotificationInfo = TimerNotificationInfo.class$("com.sap.engine.services.jmx.timer.TimerNotificationInfo")) : class$com$sap$engine$services$jmx$timer$TimerNotificationInfo));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$timer$TimerNotificationInfo;

    public TimerNotificationInfo(Timer timer, long delay, Date date, long period, long occurences, String type, NumberGenerator sequenceNumberGenerator, String msg, Integer id, Object userData) {
        super(timer, delay, date, period, occurences, type, sequenceNumberGenerator, msg, id, userData);
        this.systemTimer = timer instanceof SystemTimer;
    }

    public boolean check() {
        return true;
    }

    public void timeout() {
        try {
            if (LOCATION.beLogged(200)) {
                LOCATION.pathT("timeout()", "before sending timer notification {0}", new Object[]{this.toString()});
            }
            this.sendNotification();
            if (LOCATION.beLogged(200)) {
                LOCATION.pathT("timeout()", "timer notification successfully sent {0}", new Object[]{this.toString()});
            }
        }
        catch (RuntimeException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"timeout()", (String)("unable to send timer notification " + this.toString()), (Throwable)e);
        }
    }

    boolean isSystemTimer() {
        return this.systemTimer;
    }

    protected TimerNotification createNotification() {
        return new SynchronousTimerNotification(this.type, this.source, 0L, 0L, this.msg, this.id);
    }

    protected String getDisplayName() {
        return this.systemTimer ? "system-timer" : "user-timer";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

