/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.server;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.lib.util.WaitQueue;
import com.sap.engine.services.jmx.JmxServiceManagementInterfaceImpl;
import com.sap.engine.services.jmx.JmxServicePropertyManager;
import com.sap.engine.services.jmx.PropertyChangeListener;
import com.sap.engine.services.jmx.server.NotificationDispatcher;
import com.sap.engine.services.jmx.server.NotificationQueueItem;
import com.sap.engine.services.jmx.server.NotificationQueueMBean;
import com.sap.engine.services.jmx.server.SynchronousAttributeChangeNotification;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.util.Properties;
import javax.management.JMException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationQueue
implements NotificationQueueMBean,
NotificationEmitter,
PropertyChangeListener {
    private static final String QUEUE_OBJECT_NAME = ":j2eeType=com.sap.engine.services.jmx.server.NotificationQueue,name=JmxNotificationQueue";
    private static final String CURRENT_THREADS_PROP = "NotificationQueueCurrentThreads";
    private static final String CURRENT_SIZE_PROP = "NotificationQueueCurrentSize";
    private static final String MSG = "";
    private static final String INTERGER_CLASS_NAME = (class$java$lang$Integer == null ? (class$java$lang$Integer = NotificationQueue.class$("java.lang.Integer")) : class$java$lang$Integer).getName();
    private static final NotificationQueue queue = new NotificationQueue();
    private ThreadSystem threadSystem;
    private int lastCurrentThreads = 0;
    private int lastCurrentSize = 0;
    private int runningThreads = 0;
    private int maxThreads;
    private long enqueTimeout;
    private int newThreadThreshold;
    private long sequence = 0L;
    private JmxServicePropertyManager propMgr;
    private final WaitQueue notificationQueue = new WaitQueue();
    private final NotificationBroadcasterSupport broadcaster = new NotificationBroadcasterSupport();
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$server$NotificationQueue == null ? (class$com$sap$engine$services$jmx$server$NotificationQueue = NotificationQueue.class$("com.sap.engine.services.jmx.server.NotificationQueue")) : class$com$sap$engine$services$jmx$server$NotificationQueue));
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$sap$engine$services$jmx$server$NotificationQueue;

    private NotificationQueue() {
    }

    static NotificationQueue getQueue() {
        return queue;
    }

    public static void init(ThreadSystem threadSystem, JmxServicePropertyManager propManager, JmxServiceManagementInterfaceImpl mgmtIntf) {
        NotificationQueue.queue.threadSystem = threadSystem;
        NotificationQueue.queue.propMgr = propManager;
        queue.setServiceProperties(new Properties());
        propManager.addPropertyChangeListener(queue);
    }

    void process() {
        while (true) {
            NotificationQueueItem item = null;
            NotificationQueue notificationQueue = this;
            synchronized (notificationQueue) {
                int currentSize = this.notificationQueue.size();
                if (currentSize == 0) {
                    --this.runningThreads;
                    this.monitorCurrentThreads(this.runningThreads);
                    return;
                }
                try {
                    item = (NotificationQueueItem)this.notificationQueue.dequeue(0L);
                    this.monitorCurrentSize(currentSize - 1);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (item == null) {
                    --this.runningThreads;
                    this.monitorCurrentThreads(this.runningThreads);
                    return;
                }
            }
            try {
                if (LOCATION.beLogged(200)) {
                    LOCATION.pathT("process()", "before processing notification notification {0}", new Object[]{item.toString()});
                }
                item.process();
                if (!LOCATION.beLogged(200)) continue;
                LOCATION.pathT("process()", "notification successfully processed {0}", new Object[]{item.toString()});
                continue;
            }
            catch (Exception e) {
                LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"process()", (String)("exception during processing of notification " + item.toString()), (Throwable)e);
                continue;
            }
            break;
        }
    }

    public synchronized void enqueue(NotificationQueueItem queueItem) {
        boolean successful = false;
        try {
            successful = this.notificationQueue.enqueue((Object)queueItem, this.enqueTimeout);
        }
        catch (InterruptedException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"enqueue(NotificationQueueItem)", (String)("unable to enqueue of notification " + queueItem), (Throwable)e);
        }
        int currentSize = this.notificationQueue.size();
        if (this.runningThreads == 0 && currentSize > 0 || this.runningThreads < this.maxThreads && currentSize > this.newThreadThreshold * this.runningThreads) {
            ++this.runningThreads;
            this.threadSystem.startThread((Runnable)new NotificationDispatcher(this), true);
        }
        this.monitorCurrentSize(currentSize);
        this.monitorCurrentThreads(this.runningThreads);
        if (!successful) {
            LoggingHelper.SYS_SERVER.logT(500, LOCATION, "enqueue(NotificationQueueItem)", "enqueue of notification failed " + queueItem);
        }
    }

    private void monitorCurrentThreads(int currentThreads) {
        this.sendNotification(CURRENT_THREADS_PROP, this.lastCurrentThreads, currentThreads);
        this.lastCurrentThreads = currentThreads;
    }

    private void monitorCurrentSize(int currentSize) {
        this.sendNotification(CURRENT_SIZE_PROP, this.lastCurrentSize, currentSize);
        this.lastCurrentSize = currentSize;
    }

    private void sendNotification(String attrName, int prevValue, int value) {
        if (prevValue == value) {
            return;
        }
        SynchronousAttributeChangeNotification acn = new SynchronousAttributeChangeNotification(this, this.getSequence(), System.currentTimeMillis(), MSG, attrName, INTERGER_CLASS_NAME, new Integer(prevValue), new Integer(value));
        this.broadcaster.sendNotification(acn);
    }

    private long getSequence() {
        return this.sequence++;
    }

    public int getNotificationQueueCurrentSize() {
        return this.lastCurrentSize;
    }

    public int getNotificationQueueCurrentThreads() {
        return this.lastCurrentThreads;
    }

    public static void registerMBean(MBeanServer mbs) throws JMException {
        mbs.registerMBean(queue, new ObjectName(QUEUE_OBJECT_NAME));
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener, filter, handback);
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.broadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.broadcaster.getNotificationInfo();
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcaster.removeNotificationListener(listener);
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        this.maxThreads = this.propMgr.getNotificationQueueMaxThreads();
        this.enqueTimeout = this.propMgr.getNotificationQueueEnqTimeout();
        this.newThreadThreshold = this.propMgr.getNotificationQueueNewThreadThreshold();
        return true;
    }

    public boolean setServiceProperty(String key, String value) {
        Properties props = new Properties();
        props.setProperty(key, value);
        return this.setServiceProperties(props);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

