/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx.connector.notification;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.Date;

public final class ListenerID
implements Serializable {
    private static int listCount;
    private final long ts;
    private final int listID;

    public static ListenerID newListenerID() {
        return new ListenerID();
    }

    private ListenerID() {
        this.ts = new Date().getTime();
        this.listID = ListenerID.getNextID();
    }

    public ListenerID(ByteArrayInputStream bais) {
        long timeStamp = (long)bais.read() << 56;
        timeStamp |= (long)bais.read() << 48;
        timeStamp |= (long)bais.read() << 40;
        timeStamp |= (long)bais.read() << 32;
        timeStamp |= (long)bais.read() << 24;
        timeStamp |= (long)bais.read() << 16;
        timeStamp |= (long)bais.read() << 8;
        this.ts = timeStamp |= (long)bais.read();
        int identifier = bais.read() << 24;
        identifier |= bais.read() << 16;
        identifier |= bais.read() << 8;
        this.listID = identifier |= bais.read();
    }

    public void write(ByteArrayOutputStream baos) {
        baos.write((int)(this.ts >> 56));
        baos.write((int)(this.ts >> 48));
        baos.write((int)(this.ts >> 40));
        baos.write((int)(this.ts >> 32));
        baos.write((int)(this.ts >> 24));
        baos.write((int)(this.ts >> 16));
        baos.write((int)(this.ts >> 8));
        baos.write((int)this.ts);
        baos.write(this.listID >> 24);
        baos.write(this.listID >> 16);
        baos.write(this.listID >> 8);
        baos.write(this.listID);
    }

    private static synchronized int getNextID() {
        return listCount++;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        try {
            if (this.listID == ((ListenerID)obj).listID && this.ts == ((ListenerID)obj).ts) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return this.listID;
    }
}

