/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.shellcmd.QueryNamesCommand;
import java.util.Properties;

public class ShellInterfaceEventListener
implements ContainerEventListener {
    private static final String SHELL_INTERFACE_NAME = "shell";
    private static final String JMX_SERVICE_NAME = "jmx";
    private final JmxFrame frame;
    private ShellInterface shell = null;
    private int shellCommandsId = -1;
    private final Command[] commands;

    public ShellInterfaceEventListener(JmxFrame frame) {
        this.frame = frame;
        this.commands = new Command[]{new QueryNamesCommand(frame.getContainerContext().getObjectRegistry())};
        this.registerShellCommands(frame.getContainerContext().getObjectRegistry().getProvidedInterface(SHELL_INTERFACE_NAME));
    }

    private synchronized void unregisterShellCommands() {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.shellCommandsId);
            this.shell = null;
            this.shellCommandsId = -1;
        }
    }

    private synchronized void registerShellCommands(Object interfaceImpl) {
        if (interfaceImpl instanceof ShellInterface && this.shell == null) {
            this.shell = (ShellInterface)interfaceImpl;
            this.shellCommandsId = this.shell.registerCommands(this.commands);
        }
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals(SHELL_INTERFACE_NAME)) {
            this.registerShellCommands(interfaceImpl);
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals(SHELL_INTERFACE_NAME)) {
            ShellInterfaceEventListener shellInterfaceEventListener = this;
            synchronized (shellInterfaceEventListener) {
                this.shell = null;
                this.shellCommandsId = -1;
            }
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
        if (JMX_SERVICE_NAME.equals(serviceName)) {
            this.unregisterShellCommands();
        }
    }

    public void serviceStopped(String serviceName) {
    }

    public void markForShutdown(long time) {
    }

    public boolean setServiceProperty(String key, String value) {
        return true;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return true;
    }
}

