/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.core.thread.ClientThreadContext;
import com.sap.engine.services.jmx.DefaultClassLoader;
import com.sap.engine.services.jmx.Message;
import com.sap.engine.services.jmx.ObjectStreamFactory;
import com.sap.engine.services.jmx.ParameterizedStream;
import com.sap.engine.services.jmx.ThreadContextSerializator;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import com.sap.engine.services.jmx.exception.JmxImplementationException;
import com.sap.jmx.ObjectNameFactory;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class RequestMessage
extends Message {
    public static final int REQ_TYPE_UNKNOWN = 0;
    private static final int REQ_TYPE_MIN = 1;
    public static final int CREATE_MBEAN = 1;
    public static final int CREATE_MBEAN_LOADER = 2;
    public static final int CREATE_MBEAN_PARAMS = 3;
    public static final int CREATE_MBEAN_LOADER_PARAMS = 4;
    public static final int GET_ATTRIBUTE = 5;
    public static final int GET_ATTRIBUTES = 6;
    public static final int GET_DEFAULT_DOMAIN = 7;
    public static final int GET_MBEAN_COUNT = 8;
    public static final int GET_MBEAN_INFO = 9;
    public static final int GET_OBJECT_INSTANCE = 10;
    public static final int INVOKE = 11;
    public static final int IS_INSTANCE_OF = 12;
    public static final int IS_REGISTERED = 13;
    public static final int QUERY_MBEANS = 14;
    public static final int QUERY_NAMES = 15;
    public static final int SET_ATTRIBUTE = 16;
    public static final int SET_ATTRIBUTES = 17;
    public static final int UNREGISTER_MBEAN = 18;
    public static final int ADD_NOTIFICATION_LISTENER = 19;
    public static final int ADD_NOTIFICATION_LISTENER_MBEAN = 20;
    public static final int REMOVE_NOTIFICATION_LISTENER_ALL = 21;
    public static final int REMOVE_NOTIFICATION_LISTENER_SINGLE = 22;
    public static final int REMOVE_NOTIFICATION_LISTENER_MBEAN_ALL = 23;
    public static final int REMOVE_NOTIFICATION_LISTENER_MBEAN_SINGLE = 24;
    public static final int ADD_SERVER_SIDE_LISTENER = 25;
    public static final int ADD_SERVER_SIDE_LISTENER_MBEAN = 26;
    public static final int REMOVE_SERVER_SIDE_LISTENERS = 27;
    public static final int CHECK_ENABLED = 28;
    public static final int SEND_NOTIFICATION = 29;
    public static final int GET_DOMAINS = 30;
    private static final int REQ_TYPE_MAX = 30;
    private static final String[] REQ_TYPE_MAP = new String[]{"unknown", "createMBean(S,ON)", "createMBean(S,ON,ON)", "createMBean(S,ON,O,S)", "createMBean(S,ON,ON,O,S)", "getAttribute", "getAttributes", "getDefaultDomain", "getMBeanCount", "getMBeanInfo", "getObjectInstance", "invoke", "isInstanceOf", "isRegistered", "queryMBeans", "queryNames", "setAttribute", "setAttributes", "unregisterMBean", "addNotificationListener(ON,L,F,H)", "addNotificationListener(ON,ON,F,H)", "removeNotificationListener(ON,L)", "removeNotificationListener(ON,L,F,H)", "removeNotificationListener(ON,ON)", "removeNotificationListener(ON,ON,F,H)", "addServerSideListener", "addServerSideListenerMBean", "removeServerSideListeners", "checkEnabled", "sendNotification", "getDomains"};
    private static final byte TARGET_NODE_SPECIFIED_MASK = 1;
    private static final byte TARGET_NODE_SPECIFIED_SHIFT = 0;
    private static final byte CLASS_LOADER_INDEX_IS_LOADER_NAME_MASK = 2;
    private static final byte CLASS_LOADER_INDEX_IS_LOADER_NAME_SHIFT = 1;
    private transient byte requestType;
    private transient byte sourceType;
    private transient byte nbParams;
    private transient byte classLoaderIndex;
    private transient boolean targetNodeSpecified;
    private transient boolean classLoaderIndexIsLoaderName;
    private transient int targetNodeId;
    private transient int paramsLength;
    private transient Object[] params;
    private transient ClientThreadContext threadContext;

    public RequestMessage() {
    }

    public RequestMessage(int requestType, Object[] params) {
        this(requestType, params, 1);
    }

    public RequestMessage(int requestType, Object[] params, ClientThreadContext threadContext) {
        this(requestType, params, threadContext, 1);
    }

    public RequestMessage(int requestType, Object[] params, byte sourceType) {
        this(requestType, params, null, sourceType);
    }

    public RequestMessage(int requestType, Object[] params, ClientThreadContext threadContext, byte sourceType) {
        this.requestType = (byte)requestType;
        this.setSourceType(sourceType);
        this.classLoaderIndex = (byte)-1;
        this.targetNodeSpecified = false;
        this.classLoaderIndexIsLoaderName = false;
        this.targetNodeId = -1;
        this.params = params != null ? params : new Object[]{};
        this.nbParams = (byte)this.params.length;
        this.threadContext = threadContext;
        this.paramsLength = 0;
        switch (requestType) {
            case 1: {
                this.setTargetNode((ObjectName)params[1]);
                break;
            }
            case 2: {
                this.setTargetNode((ObjectName)params[1]);
                this.classLoaderIndex = (byte)2;
                this.classLoaderIndexIsLoaderName = true;
                break;
            }
            case 4: {
                this.setTargetNode((ObjectName)params[1]);
                this.classLoaderIndex = (byte)2;
                this.classLoaderIndexIsLoaderName = true;
                break;
            }
            case 3: {
                this.setTargetNode((ObjectName)params[1]);
                break;
            }
            case 5: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 6: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 10: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 11: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 12: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 13: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 14: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 15: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 16: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 17: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 18: {
                this.setTargetNode((ObjectName)params[0]);
                break;
            }
            case 19: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 20: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 21: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 22: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 23: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 24: {
                this.setTargetNode((ObjectName)params[0]);
                this.classLoaderIndex = 0;
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            default: {
                throw new JmxIllegalArgumentException("jmx_1307", new Object[]{String.valueOf(requestType)});
            }
        }
    }

    public void setSourceType(byte sourceType) {
        this.checkSourceType(sourceType);
        this.sourceType = sourceType;
    }

    private void setTargetNode(ObjectName name) {
        String targetNodeIdString = ObjectNameFactory.getClusterNode((ObjectName)name);
        if (targetNodeIdString != null && !targetNodeIdString.equals("\"\"")) {
            this.targetNodeId = Integer.parseInt(targetNodeIdString);
            this.targetNodeSpecified = true;
        }
    }

    protected int writeVariableHeader(int startPos) throws IOException {
        DataOutput dout = this.getDataOutput(startPos);
        dout.writeByte(this.requestType);
        dout.writeByte(this.sourceType);
        dout.writeByte(this.nbParams);
        dout.writeByte(this.classLoaderIndex);
        dout.writeByte((this.classLoaderIndexIsLoaderName ? 1 : 0) << 1 & 2 | (this.targetNodeSpecified ? 1 : 0) << 0 & 1);
        dout.writeInt(this.targetNodeId);
        dout.writeInt(this.paramsLength);
        return this.getCurrentWritePos() - startPos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int writeBody(int startPos) throws IOException {
        ByteArrayOutputStream baos;
        block8: {
            baos = this.getOutputStream(startPos);
            if (this.nbParams > 0) {
                ObjectOutputStream oos = null;
                try {
                    oos = ObjectStreamFactory.getOutputStream(baos);
                    int i = 0;
                    while (true) {
                        if (i >= this.params.length) {
                            oos.flush();
                            Object var6_5 = null;
                            if (oos == null) break block8;
                            break;
                        }
                        oos.writeObject(this.params[i]);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    if (oos == null) throw throwable;
                    try {
                        oos.close();
                        throw throwable;
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (IOException ignored) {}
                oos.close();
            }
        }
        if (this.threadContext == null) return this.getCurrentWritePos() - startPos;
        baos.write(new ThreadContextSerializator(this.threadContext).getBytes());
        return this.getCurrentWritePos() - startPos;
    }

    public void saveThreadContext(ClientThreadContext threadContext) throws JmxConnectorException {
        this.threadContext = threadContext;
        if (this.getHeaderLength() < 0) {
            return;
        }
        try {
            byte[] serializedThreadContext = new ThreadContextSerializator(threadContext).getBytes();
            this.setBodyLength(this.paramsLength + serializedThreadContext.length);
            DataOutput dout = this.getDataOutput(this.getHeaderLength() + this.paramsLength);
            dout.write(serializedThreadContext);
        }
        catch (IOException e) {
            throw new JmxConnectorException("jmx_2226", new Object[]{this.toString()});
        }
        catch (RuntimeException e) {
            throw new JmxConnectorException("jmx_2226", new Object[]{this.toString()});
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreThreadContext(ClientThreadContext threadContext) throws JmxConnectorException {
        if (this.getHeaderLength() < 0) {
            if (this.threadContext == null) throw new JmxConnectorException("jmx_2228", new Object[]{this.toString()});
            ThreadContextSerializator.restore(this.threadContext, threadContext);
            return;
        }
        try {
            ThreadContextSerializator.restore(this.getMsg(), this.getMsgOff() + this.getHeaderLength() + this.paramsLength, threadContext);
            return;
        }
        catch (IOException e) {
            throw new JmxConnectorException("jmx_2228", new Object[]{this.toString()}, e);
        }
    }

    protected void readVariableHeader(DataInput din) throws IOException {
        this.requestType = din.readByte();
        this.sourceType = din.readByte();
        this.nbParams = din.readByte();
        this.classLoaderIndex = din.readByte();
        byte flag = din.readByte();
        this.classLoaderIndexIsLoaderName = (flag & 2) >>> 1 == 1;
        this.targetNodeSpecified = (flag & 1) >>> 0 == 1;
        this.targetNodeId = din.readInt();
        this.paramsLength = din.readInt();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readParams(MBeanServer mbs) throws JmxConnectorException {
        if (this.params != null) {
            return;
        }
        this.params = new Object[this.nbParams];
        if (this.nbParams == 0) {
            return;
        }
        ObjectInputStream ois = null;
        HashMap<String, ClassLoader> streamParams = new HashMap<String, ClassLoader>(2);
        streamParams.put("StreamClassLoader", DefaultClassLoader.DEFAULT_CLASS_LOADER);
        try {
            ois = ObjectStreamFactory.getInputStream(this.getInputStream(this.getHeaderLength()));
            ((ParameterizedStream)((Object)ois)).setParameters(streamParams);
            int i = 0;
            while (i < this.nbParams) {
                try {
                    this.params[i] = ois.readObject();
                }
                catch (Throwable t) {
                    throw new JmxConnectorException("jmx_2214", new Object[]{this.toString()}, t);
                }
                if (mbs != null && i == this.classLoaderIndex) {
                    if (!(this.params[i] instanceof ObjectName)) {
                        throw new JmxImplementationException("jmx_1104", new Object[]{this.toString()});
                    }
                    try {
                        if (this.classLoaderIndexIsLoaderName) {
                            streamParams.put("StreamClassLoader", mbs.getClassLoader((ObjectName)this.params[i]));
                        } else {
                            streamParams.put("StreamClassLoader", mbs.getClassLoaderFor((ObjectName)this.params[i]));
                        }
                    }
                    catch (InstanceNotFoundException e) {
                        throw new JmxConnectorException("jmx_2214", new Object[]{this.toString()}, e);
                    }
                    catch (RuntimeException e) {
                        throw new JmxConnectorException("jmx_2214", new Object[]{this.toString()}, e);
                    }
                    ((ParameterizedStream)((Object)ois)).setParameters(streamParams);
                }
                ++i;
            }
            Object var8_8 = null;
            if (ois == null) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (ois == null) throw throwable;
            try {
                ois.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ois.close();
            return;
        }
        catch (IOException ignored) {}
    }

    public final int getRequestType() {
        return this.requestType;
    }

    public final byte getSourceType() {
        return this.sourceType;
    }

    public Object[] getParams(MBeanServer mbs) throws JmxConnectorException {
        this.readParams(mbs);
        return this.params;
    }

    protected StringBuffer appendBody(StringBuffer sb) {
        if (this.params != null && this.params.length > 0) {
            sb.append(this.params[0]);
            int i = 1;
            while (i < this.params.length) {
                sb.append(' ').append(this.params[i] == null ? null : this.params[i].toString());
                ++i;
            }
        }
        return sb;
    }

    protected StringBuffer appendVariableHeader(StringBuffer sb) {
        sb.append(" src: ").append(this.getSourceTypeAsString(this.sourceType));
        if (this.targetNodeSpecified) {
            sb.append(" target-node: ").append(this.targetNodeId);
        }
        sb.append(" req: ").append(this.getRequestTypeAsString());
        sb.append(" params-number: ").append(this.nbParams);
        return sb.append(" params-bytes: ").append(this.paramsLength);
    }

    public final String getRequestTypeAsString() {
        if (1 <= this.requestType && this.requestType <= 30) {
            return REQ_TYPE_MAP[this.requestType];
        }
        return String.valueOf(this.requestType);
    }

    public int getTargetNodeId() {
        return this.targetNodeId;
    }

    public String getTargetNodeIdAsString() {
        if (this.targetNodeSpecified) {
            return String.valueOf(this.targetNodeId);
        }
        return null;
    }

    public boolean isTargetNodeSpecified() {
        return this.targetNodeSpecified;
    }
}

