/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;

public class ObjectStreamFactory {
    private static final String INPUT_STREAM_P4_CLASS_NAME = "com.sap.engine.services.jmx.ClassLoaderSpecificObjectInputStreamP4";
    private static final String INPUT_STREAM_CLASS_NAME = "com.sap.engine.services.jmx.ClassLoaderSpecificObjectInputStream";
    private static final String OUTPUT_STREAM_P4_CLASS_NAME = "com.sap.engine.services.jmx.JmxServiceObjectOutputStreamP4";
    private static final String OUTPUT_STREAM_CLASS_NAME = "com.sap.engine.services.jmx.JmxServiceObjectOutputStream";
    private static Constructor inputStreamConstructor;
    private static Constructor outputStreamConstructor;
    private static boolean useP4;
    private static final Location LOCATION;
    static /* synthetic */ Class class$com$sap$engine$services$jmx$ObjectStreamFactory;
    static /* synthetic */ Class class$java$io$ByteArrayOutputStream;
    static /* synthetic */ Class class$java$io$ByteArrayInputStream;

    static void initialize(boolean p4Available) {
        ObjectOutputStream oos = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Class<?> outputStreamClass;
            if (p4Available) {
                outputStreamClass = Class.forName(OUTPUT_STREAM_P4_CLASS_NAME);
                useP4 = true;
            } else {
                outputStreamClass = Class.forName(OUTPUT_STREAM_CLASS_NAME);
                useP4 = false;
            }
            outputStreamConstructor = outputStreamClass.getConstructor(class$java$io$ByteArrayOutputStream == null ? (class$java$io$ByteArrayOutputStream = ObjectStreamFactory.class$("java.io.ByteArrayOutputStream")) : class$java$io$ByteArrayOutputStream);
            oos = ObjectStreamFactory.getOutputStream(baos);
        }
        catch (Throwable ignored) {
            try {
                useP4 = false;
                Class<?> outputStreamClass = Class.forName(OUTPUT_STREAM_CLASS_NAME);
                outputStreamConstructor = outputStreamClass.getConstructor(class$java$io$ByteArrayOutputStream == null ? (class$java$io$ByteArrayOutputStream = ObjectStreamFactory.class$("java.io.ByteArrayOutputStream")) : class$java$io$ByteArrayOutputStream);
                oos = ObjectStreamFactory.getOutputStream(baos);
            }
            catch (Throwable e) {
                StringWriter writer = new StringWriter();
                PrintWriter wrapper = new PrintWriter(writer);
                e.printStackTrace(wrapper);
                LOCATION.logT(500, "<clinit>", "Unable to initialize stream factory for JMX remote communication. Administration of this cluster node will not be possible. Please check the attached exceptions.");
                LOCATION.logT(500, "<clinit>", e.toString());
                LOCATION.logT(500, "<clinit>", writer.toString());
            }
        }
        if (oos != null) {
            byte[] test = baos.toByteArray();
            try {
                Class<?> inputStreamClass = p4Available ? Class.forName(INPUT_STREAM_P4_CLASS_NAME) : Class.forName(INPUT_STREAM_CLASS_NAME);
                inputStreamConstructor = inputStreamClass.getConstructor(class$java$io$ByteArrayInputStream == null ? (class$java$io$ByteArrayInputStream = ObjectStreamFactory.class$("java.io.ByteArrayInputStream")) : class$java$io$ByteArrayInputStream);
                ObjectStreamFactory.getInputStream(new ByteArrayInputStream(test));
            }
            catch (Throwable ignored) {
                try {
                    Class<?> inputStreamClass = Class.forName(INPUT_STREAM_CLASS_NAME);
                    inputStreamConstructor = inputStreamClass.getConstructor(class$java$io$ByteArrayInputStream == null ? (class$java$io$ByteArrayInputStream = ObjectStreamFactory.class$("java.io.ByteArrayInputStream")) : class$java$io$ByteArrayInputStream);
                    ObjectStreamFactory.getInputStream(new ByteArrayInputStream(test));
                }
                catch (Throwable e) {
                    StringWriter writer = new StringWriter();
                    PrintWriter wrapper = new PrintWriter(writer);
                    e.printStackTrace(wrapper);
                    LOCATION.logT(500, "<clinit>", "Unable to initialize stream factory for JMX remote communication. Administration of this cluster node will not be possible. Please check the attached exceptions.");
                    LOCATION.logT(500, "<clinit>", e.toString());
                    LOCATION.logT(500, "<clinit>", writer.toString());
                }
            }
        }
    }

    public static ObjectInputStream getInputStream(ByteArrayInputStream stream) throws JmxConnectorException {
        try {
            return (ObjectInputStream)inputStreamConstructor.newInstance(stream);
        }
        catch (Throwable e) {
            throw new JmxConnectorException("jmx_2203", e);
        }
    }

    public static ObjectOutputStream getOutputStream(ByteArrayOutputStream stream) throws JmxConnectorException {
        try {
            return (ObjectOutputStream)outputStreamConstructor.newInstance(stream);
        }
        catch (Throwable e) {
            throw new JmxConnectorException("jmx_2204", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$ObjectStreamFactory == null ? (class$com$sap$engine$services$jmx$ObjectStreamFactory = ObjectStreamFactory.class$("com.sap.engine.services.jmx.ObjectStreamFactory")) : class$com$sap$engine$services$jmx$ObjectStreamFactory));
        ObjectStreamFactory.initialize(true);
    }
}

