/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.lib.util.cache.Cache;
import com.sap.engine.lib.util.cache.StableCacheObject;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServicePropertyManager;
import com.sap.engine.services.jmx.ObjectNameCacheMBean;
import com.sap.engine.services.jmx.PropertyChangeListener;
import com.sap.engine.services.jmx.server.SynchronousAttributeChangeNotification;
import com.sap.pj.jmx.NotificationBroadcasterSupport;
import java.util.Properties;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class ObjectNameCache
implements PropertyChangeListener,
ObjectNameCacheMBean,
NotificationEmitter {
    private static final String OBJECT_NAME_CACHE_MAX_SIZE = "ObjectNameCacheMaxSize";
    private static final String OBJECT_NAME_CACHE_CURRENT_USAGE = "ObjectNameCacheCurrentUsage";
    private static final String OBJECT_NAME_CACHE_REPLACED_OBJECTS = "ObjectNameCacheReplacedObjects";
    private static final String OBJECT_NAME_CACHE_TOTAL_READS = "ObjectNameCacheTotalReads";
    private static final String OBJECT_NAME_CACHE_TOTAL_HITS = "ObjectNameCacheTotalHits";
    private static final String MSG = "";
    private static final String INTERGER_CLASS_NAME = Integer.TYPE.getName();
    private static final String LONG_CLASS_NAME = Long.TYPE.getName();
    private final Object mbean;
    private long sequence = 0L;
    private Cache cache;
    private JmxServicePropertyManager propMgr;
    private final NotificationBroadcasterSupport emitter = new NotificationBroadcasterSupport();
    private int maxSize;
    private int currentUsage;
    private int replacedObjects;
    private long totalHits;
    private long totalReads;
    private final Object sequenceLock = new Object();
    private final Object replacedObjectsLock = new Object();
    private final Object totalHitsLock = new Object();
    private final Object totalReadsLock = new Object();

    public ObjectNameCache(JmxFrame frame, Object mbean) {
        this.mbean = mbean;
        this.propMgr = frame.getPropertyManager();
        this.setServiceProperties(new Properties());
        this.propMgr.addPropertyChangeListener(this);
    }

    private synchronized void resize(int newMinSize, int newMaxSize) {
        if (this.maxSize != newMaxSize) {
            this.cache = new Cache(newMinSize, newMaxSize);
            int oldMaxSize = this.maxSize;
            this.maxSize = newMaxSize;
            this.notify(OBJECT_NAME_CACHE_MAX_SIZE, oldMaxSize, newMaxSize);
            this.setCurrentUsage(this.cache.stableSize());
            this.resetReplacedObjects();
        }
    }

    public synchronized void add(ObjectName key, ObjectName value) {
        if (this.cache.lookupCache((Object)key) != null) {
            return;
        }
        this.cache.addCache((Object)key, (Object)new CacheObject(value));
        this.setCurrentUsage(this.cache.stableSize());
    }

    public ObjectName lookup(ObjectName key) {
        this.incTotalReads();
        CacheObject obj = (CacheObject)this.cache.lookupCache((Object)key);
        if (obj == null) {
            return null;
        }
        this.incTotalHits();
        return obj.getValue();
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        int newMinSize = this.propMgr.getObjectNameCompletionCacheMinSize();
        int newMaxSize = this.propMgr.getObjectNameCompletionCacheMaxSize();
        this.resize(newMinSize, newMaxSize);
        return true;
    }

    public boolean setServiceProperty(String key, String value) {
        Properties props = new Properties();
        props.setProperty(key, value);
        return this.setServiceProperties(props);
    }

    public int getObjectNameCacheMaxSize() {
        return this.maxSize;
    }

    public int getObjectNameCacheCurrentUsage() {
        return this.currentUsage;
    }

    public long getObjectNameCacheTotalHits() {
        return this.totalHits;
    }

    public long getObjectNameCacheTotalReads() {
        return this.totalReads;
    }

    public int getObjectNameCacheReplacedObjects() {
        return this.replacedObjects;
    }

    private final void notify(String attribute, int oldValue, int newValue) {
        NotificationBroadcasterSupport.ListenersArray currListeners = this.emitter.getCurrentListeners();
        if (currListeners.nextFreePos > 0 && oldValue != newValue) {
            SynchronousAttributeChangeNotification notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, attribute, INTERGER_CLASS_NAME, new Integer(oldValue), new Integer(newValue));
            int i = 0;
            while (i < currListeners.nextFreePos) {
                if (currListeners.listsners[i].filter == null || currListeners.listsners[i].filter.isNotificationEnabled(notification)) {
                    currListeners.listsners[i].listener.handleNotification(notification, currListeners.listsners[i].handback);
                }
                ++i;
            }
        }
    }

    private final void notify(String attribute, long oldValue, long newValue) {
        NotificationBroadcasterSupport.ListenersArray currListeners = this.emitter.getCurrentListeners();
        if (currListeners.nextFreePos > 0 && oldValue != newValue) {
            SynchronousAttributeChangeNotification notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, attribute, LONG_CLASS_NAME, new Long(oldValue), new Long(newValue));
            int i = 0;
            while (i < currListeners.nextFreePos) {
                if (currListeners.listsners[i].filter == null || currListeners.listsners[i].filter.isNotificationEnabled(notification)) {
                    currListeners.listsners[i].listener.handleNotification(notification, currListeners.listsners[i].handback);
                }
                ++i;
            }
        }
    }

    private long getSequence() {
        Object object = this.sequenceLock;
        synchronized (object) {
            long l = this.sequence++;
            return l;
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
        SynchronousAttributeChangeNotification notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, OBJECT_NAME_CACHE_MAX_SIZE, INTERGER_CLASS_NAME, new Integer(0), new Integer(this.maxSize));
        if (filter == null || filter.isNotificationEnabled(notification)) {
            listener.handleNotification(notification, handback);
        }
        notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, OBJECT_NAME_CACHE_CURRENT_USAGE, INTERGER_CLASS_NAME, new Integer(0), new Integer(this.currentUsage));
        if (filter == null || filter.isNotificationEnabled(notification)) {
            listener.handleNotification(notification, handback);
        }
        notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, OBJECT_NAME_CACHE_REPLACED_OBJECTS, INTERGER_CLASS_NAME, new Integer(0), new Integer(this.replacedObjects));
        if (filter == null || filter.isNotificationEnabled(notification)) {
            listener.handleNotification(notification, handback);
        }
        notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, OBJECT_NAME_CACHE_TOTAL_READS, LONG_CLASS_NAME, new Long(0L), new Long(this.totalReads));
        if (filter == null || filter.isNotificationEnabled(notification)) {
            listener.handleNotification(notification, handback);
        }
        notification = new SynchronousAttributeChangeNotification(this.mbean, this.getSequence(), System.currentTimeMillis(), MSG, OBJECT_NAME_CACHE_TOTAL_HITS, LONG_CLASS_NAME, new Long(0L), new Long(this.totalHits));
        if (filter == null || filter.isNotificationEnabled(notification)) {
            listener.handleNotification(notification, handback);
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.emitter.getNotificationInfo();
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    private void incReplacedObjects() {
        int newNumber;
        int oldNumber;
        Object object = this.replacedObjectsLock;
        synchronized (object) {
            if (Integer.MAX_VALUE == this.replacedObjects) {
                return;
            }
            oldNumber = this.replacedObjects++;
            newNumber = this.replacedObjects;
        }
        this.notify(OBJECT_NAME_CACHE_REPLACED_OBJECTS, oldNumber, newNumber);
    }

    private void resetReplacedObjects() {
        int oldNumber;
        int newNumber = 0;
        Object object = this.replacedObjectsLock;
        synchronized (object) {
            oldNumber = this.replacedObjects;
            this.replacedObjects = newNumber;
        }
        this.notify(OBJECT_NAME_CACHE_REPLACED_OBJECTS, oldNumber, newNumber);
    }

    private void setCurrentUsage(int newUsage) {
        int oldUsage = this.currentUsage;
        this.currentUsage = newUsage;
        this.notify(OBJECT_NAME_CACHE_CURRENT_USAGE, oldUsage, newUsage);
    }

    private void incTotalHits() {
        long newNumber;
        long oldNumber;
        Object object = this.totalHitsLock;
        synchronized (object) {
            if (Long.MAX_VALUE == this.totalHits) {
                return;
            }
            oldNumber = this.totalHits++;
            newNumber = this.totalHits;
        }
        this.notify(OBJECT_NAME_CACHE_TOTAL_HITS, oldNumber, newNumber);
    }

    private void incTotalReads() {
        long newNumber;
        long oldNumber;
        Object object = this.totalReadsLock;
        synchronized (object) {
            if (Long.MAX_VALUE == this.totalReads) {
                return;
            }
            oldNumber = this.totalReads++;
            newNumber = this.totalReads;
        }
        this.notify(OBJECT_NAME_CACHE_TOTAL_READS, oldNumber, newNumber);
    }

    private class CacheObject
    implements StableCacheObject {
        private final ObjectName name;

        public CacheObject(ObjectName name) {
            this.name = name;
        }

        public ObjectName getValue() {
            return this.name;
        }

        public void cacheFinalization() {
            ObjectNameCache.this.incReplacedObjects();
        }
    }
}

