/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.JmxServiceByteArrayOutputStream;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.engine.services.jmx.exception.JmxEOFException;
import com.sap.engine.services.jmx.exception.JmxIllegalArgumentException;
import com.sap.engine.services.jmx.exception.JmxStreamCorruptedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Message
implements Externalizable {
    public static final byte MAJOR_VERSION = 1;
    public static final short MINOR_VERSION = 0;
    private static final byte MESSAGE_TYPE_UNKNOWN = 0;
    private static final byte MESSAGE_TYPE_MIN = 1;
    public static final byte MESSAGE_TYPE_REQUEST = 1;
    public static final byte MESSAGE_TYPE_RESPONSE = 2;
    public static final byte MESSAGE_TYPE_NOTIFICATION = 3;
    public static final byte MESSAGE_TYPE_EXCEPTION = 4;
    private static final byte MESSAGE_TYPE_MAX = 4;
    private static final String[] TYPE_MAP = new String[]{"unknown", "request", "response", "notification", "exception"};
    private static final byte SERIALIZATION_METHOD_UNKNOWN = 0;
    private static final byte SERIALIZATION_METHOD_MIN = 1;
    private static final byte SERIALIZATION_METHOD_JAVA = 1;
    private static final byte SERIALIZATION_METHOD_MAX = 1;
    private static final String[] SERIALIZATION_MAP = new String[]{"unknown", "java"};
    private static final byte MESSAGE_TYPE_MASK = 15;
    private static final byte MESSAGE_TYPE_SHIFT = 0;
    private static final int SERIAL_METHOD_MASK = 48;
    private static final int SERIAL_METHOD_SHIFT = 4;
    public static final byte SOURCE_TYPE_UNKNOWN = 0;
    private static final byte SOURCE_TYPE_MIN = 1;
    public static final byte SOURCE_TYPE_CLUSTER = 1;
    public static final byte SOURCE_TYPE_P4 = 2;
    private static final byte SOURCE_TYPE_MAX = 2;
    public static final byte SOURCE_TYPE_DEFAULT = 1;
    private static final String[] SOURCE_TYPE_MAP = new String[]{"unknown", "cluster", "p4"};
    private static final int MAGIC_COOCKIE = -87102289;
    private transient int headerLengthOff;
    private transient int headerLength;
    private transient int bodyLengthOff;
    private transient int bodyLength;
    private static final int FLAG_OFF = 12;
    private transient byte messageType;
    private transient byte serializationMethod;
    private transient byte majorProtocolVersion;
    private transient short minorProtocolVersion;
    private transient JmxServiceByteArrayOutputStream outputStream;
    private transient DataOutputStream dataOutput;

    public Message() {
        this(1);
    }

    protected Message(byte serializationMethod) {
        if (this instanceof RequestMessage) {
            this.messageType = 1;
        } else if (this instanceof ExceptionMessage) {
            this.messageType = (byte)4;
        } else if (this instanceof ResponseMessage) {
            this.messageType = (byte)2;
        } else if (this instanceof Message) {
            this.messageType = 0;
        } else {
            throw new JmxIllegalArgumentException("jmx_1315", new Object[]{this.getClass().getName()});
        }
        if (serializationMethod < 1 || serializationMethod > 1) {
            throw new JmxIllegalArgumentException("jmx_1316", new Object[]{String.valueOf(serializationMethod)});
        }
        this.serializationMethod = serializationMethod;
        this.majorProtocolVersion = 1;
        this.minorProtocolVersion = 0;
        this.headerLength = -1;
    }

    private void initFromByteArray(byte[] message, int off, int len) throws JmxConnectorException {
        try {
            this.outputStream = new JmxServiceByteArrayOutputStream(message, off, len, true);
            DataInputStream din = new DataInputStream(this.getInputStream(0));
            this.readCommonHeader(din);
            if (len < this.headerLength + this.bodyLength) {
                throw new JmxEOFException();
            }
            this.readVariableHeader(din);
        }
        catch (IOException e) {
            throw new JmxConnectorException("jmx_2202", new Object[]{this.toString()}, e);
        }
        catch (RuntimeException e) {
            throw new JmxConnectorException("jmx_2202", new Object[]{this.toString()}, e);
        }
    }

    public static final Message getMessageFromBytes(byte[] message, int off, int len) throws JmxConnectorException {
        Message msg2;
        if (message == null) {
            throw new JmxConnectorException("jmx_2227", (Throwable)((Object)new JmxIllegalArgumentException("jmx_1317")));
        }
        if (off < 0 || off > message.length || len < 0 || off + len > message.length || off + len < 0) {
            throw new JmxConnectorException("jmx_2227", new IndexOutOfBoundsException());
        }
        if (len < 12) {
            throw new JmxConnectorException("jmx_2227", (Throwable)((Object)new JmxEOFException()));
        }
        byte msgType = (byte)((message[off + 12] & 0xF) >>> 0);
        switch (msgType) {
            case 1: {
                msg2 = new RequestMessage();
                break;
            }
            case 2: {
                msg2 = new ResponseMessage();
                break;
            }
            case 4: {
                msg2 = new ExceptionMessage();
                break;
            }
            default: {
                Message msg2 = new Message();
                msg2.initFromByteArray(message, off, len);
                throw new JmxConnectorException("jmx_2202", new Object[]{msg2});
            }
        }
        super.initFromByteArray(message, off, len);
        return msg2;
    }

    private void writeMsg() throws JmxConnectorException {
        if (this.outputStream != null) {
            return;
        }
        try {
            this.outputStream = new JmxServiceByteArrayOutputStream();
            int commonHeaderLength = this.writeCommonHeader();
            this.headerLength = this.writeVariableHeader(commonHeaderLength) + commonHeaderLength;
            this.bodyLength = this.writeBody(this.headerLength);
            DataOutput dout = this.getDataOutput(this.headerLengthOff);
            dout.writeInt(this.headerLength);
            dout.writeInt(this.bodyLength);
        }
        catch (IOException e) {
            throw new JmxConnectorException("jmx_2201", new Object[]{this.toString()}, e);
        }
        catch (RuntimeException e) {
            throw new JmxConnectorException("jmx_2201", new Object[]{this.toString()}, e);
        }
    }

    private int writeCommonHeader() throws IOException {
        DataOutput dout = this.getDataOutput(0);
        dout.writeInt(-87102289);
        this.headerLengthOff = this.outputStream.getCurrentPos();
        dout.writeInt(this.headerLength);
        this.bodyLengthOff = this.outputStream.getCurrentPos();
        dout.writeInt(this.bodyLength);
        dout.writeByte(this.serializationMethod << 4 & 0x30 | this.messageType << 0 & 0xF);
        dout.writeByte(this.majorProtocolVersion);
        dout.writeShort(this.minorProtocolVersion);
        return this.getCurrentWritePos();
    }

    protected int writeVariableHeader(int startPos) throws IOException {
        return startPos;
    }

    protected int writeBody(int startPos) throws IOException {
        return startPos;
    }

    protected final DataOutput getDataOutput(int pos) {
        if (this.dataOutput == null) {
            this.dataOutput = new DataOutputStream(this.outputStream);
        }
        this.outputStream.setCurrentPos(pos);
        return this.dataOutput;
    }

    protected final ByteArrayOutputStream getOutputStream(int pos) {
        this.outputStream.setCurrentPos(pos);
        return this.outputStream;
    }

    protected final ByteArrayInputStream getInputStream(int pos) {
        return new ByteArrayInputStream(this.outputStream.getBuf(), this.outputStream.bufOff + pos, this.outputStream.size() - pos);
    }

    protected final int getCurrentWritePos() {
        return this.outputStream.getCurrentPos();
    }

    protected final int getHeaderLength() {
        return this.headerLength;
    }

    protected final int getBodyLength() {
        return this.bodyLength;
    }

    protected final void setBodyLength(int len) throws IOException {
        this.outputStream.ensureCapacity(len);
        this.bodyLength = len;
        this.getDataOutput(this.bodyLengthOff).writeInt(this.bodyLength);
    }

    private void readCommonHeader(DataInput din) throws IOException {
        if (-87102289 != din.readInt()) {
            throw new JmxConnectorException("jmx_2202", new Object[]{this.toString()}, (Throwable)((Object)new JmxStreamCorruptedException()));
        }
        this.headerLength = din.readInt();
        this.bodyLength = din.readInt();
        byte flag = din.readByte();
        this.messageType = (byte)((flag & 0xF) >>> 0);
        this.serializationMethod = (byte)((flag & 0x30) >>> 4);
        this.majorProtocolVersion = din.readByte();
        this.minorProtocolVersion = din.readShort();
        if (this.majorProtocolVersion > 1) {
            throw new JmxConnectorException("jmx_2216", new Object[]{this.majorProtocolVersion + "." + this.minorProtocolVersion, "1.0"});
        }
    }

    protected void readVariableHeader(DataInput din) throws IOException {
    }

    public final byte getMajorProtocolVersion() {
        return this.majorProtocolVersion;
    }

    public final short getMinorProtocolVersion() {
        return this.minorProtocolVersion;
    }

    public final byte getSerializationMethod() {
        return this.serializationMethod;
    }

    public final byte[] getMsg() throws JmxConnectorException {
        this.writeMsg();
        return this.outputStream.getBuf();
    }

    public final int getMsgLen() throws JmxConnectorException {
        this.writeMsg();
        return this.headerLength + this.bodyLength;
    }

    public final int getMsgOff() throws JmxConnectorException {
        this.writeMsg();
        return this.outputStream.getBufOff();
    }

    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.readCommonHeader(in);
            int msgLen = this.headerLength + this.bodyLength;
            this.outputStream = new JmxServiceByteArrayOutputStream(new byte[msgLen], true);
            int commonHeaderLen = this.writeCommonHeader();
            in.readFully(this.outputStream.getBuf(), this.outputStream.getBufOff() + commonHeaderLen, msgLen - commonHeaderLen);
            this.readVariableHeader(new DataInputStream(this.getInputStream(commonHeaderLen)));
        }
        catch (RuntimeException e) {
            throw new JmxConnectorException("jmx_2202", new Object[]{this.toString()}, e);
        }
    }

    public final void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.write(this.getMsg(), this.getMsgOff(), this.getMsgLen());
        }
        catch (RuntimeException e) {
            throw new JmxConnectorException("jmx_2201", new Object[]{this.toString()}, e);
        }
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ JMX ").append(this.getMessageTypeAsString());
        sb.append(" (").append(this.getSerializationMethodAsString()).append(") ");
        sb.append("v").append(this.majorProtocolVersion).append('.').append(this.minorProtocolVersion);
        if (this.outputStream != null) {
            sb.append(" len: ");
            sb.append(this.headerLength + this.bodyLength);
        }
        sb.append(" | ");
        this.appendVariableHeader(sb);
        sb.append(" | ");
        this.appendBody(sb);
        sb.append(" ]");
        return sb.toString();
    }

    public final String getMessageTypeAsString() {
        if (1 <= this.messageType && this.messageType <= 4) {
            return TYPE_MAP[this.messageType];
        }
        return String.valueOf(this.messageType);
    }

    public final String getSerializationMethodAsString() {
        if (1 <= this.serializationMethod && this.serializationMethod <= 1) {
            return SERIALIZATION_MAP[this.serializationMethod];
        }
        return String.valueOf(this.serializationMethod);
    }

    protected final void checkSourceType(byte sourceType) {
        if (sourceType < 1 || sourceType > 2) {
            throw new JmxIllegalArgumentException("jmx_1314", new Object[]{String.valueOf(sourceType)});
        }
    }

    public final String getSourceTypeAsString(byte sourceType) {
        if (1 <= sourceType && sourceType <= 1) {
            return SOURCE_TYPE_MAP[sourceType];
        }
        return String.valueOf(sourceType);
    }

    protected StringBuffer appendVariableHeader(StringBuffer sb) {
        return sb;
    }

    protected StringBuffer appendBody(StringBuffer sb) {
        return sb;
    }
}

