/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.ClusterResult;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.MBeanServerClusterConnection;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class MBeanServerClusterConnectionSecurityWrapper
implements MBeanServerClusterConnection {
    private final JmxFrame frame;
    private final MBeanServerClusterConnection mbscc;

    public MBeanServerClusterConnectionSecurityWrapper(JmxFrame frame, MBeanServerClusterConnection mbscc) {
        this.frame = frame;
        this.mbscc = mbscc;
    }

    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "addNotificationListener");
        this.mbscc.addNotificationListener(name, listener, filter, handback);
    }

    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "addNotificationListener");
        this.mbscc.addNotificationListener(name, listener, filter, handback);
    }

    public ClusterResult createMBean(String className, ObjectName name, Object[] params, String[] signature) throws JmxConnectorException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbscc.createMBean(className, name, params, signature);
    }

    public ClusterResult createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws JmxConnectorException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbscc.createMBean(className, name, loaderName, params, signature);
    }

    public ClusterResult createMBean(String className, ObjectName name, ObjectName loaderName) throws JmxConnectorException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbscc.createMBean(className, name, loaderName);
    }

    public ClusterResult createMBean(String className, ObjectName name) throws JmxConnectorException {
        this.frame.checkMBeanPermission(className, null, null, "instantiate");
        this.frame.checkMBeanPermission(className, null, name, "registerMBean");
        return this.mbscc.createMBean(className, name);
    }

    public ClusterResult getAttribute(ObjectName name, String attribute) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, attribute, name, "getAttribute");
        return this.mbscc.getAttribute(name, attribute);
    }

    public ClusterResult getAttributes(ObjectName name, String[] attributes) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "getAttribute");
        return this.mbscc.getAttributes(name, attributes);
    }

    public ClusterResult getDefaultDomain() throws JmxConnectorException {
        return this.mbscc.getDefaultDomain();
    }

    public ClusterResult getMBeanCount() throws JmxConnectorException {
        return this.mbscc.getMBeanCount();
    }

    public ClusterResult getMBeanInfo(ObjectName name) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "getMBeanInfo");
        return this.mbscc.getMBeanInfo(name);
    }

    public ClusterResult getObjectInstance(ObjectName name) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "getObjectInstance");
        return this.mbscc.getObjectInstance(name);
    }

    public ClusterResult invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, operationName, name, "invoke");
        return this.mbscc.invoke(name, operationName, params, signature);
    }

    public ClusterResult isInstanceOf(ObjectName name, String className) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "isInstanceOf");
        return this.mbscc.isInstanceOf(name, className);
    }

    public ClusterResult isRegistered(ObjectName name) throws JmxConnectorException {
        return this.mbscc.isRegistered(name);
    }

    public ClusterResult queryMBeans(ObjectName name, QueryExp query) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, null, "queryMBeans");
        return this.mbscc.queryMBeans(name, query);
    }

    public ClusterResult queryNames(ObjectName name, QueryExp query) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, null, "queryNames");
        return this.mbscc.queryNames(name, query);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbscc.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbscc.removeNotificationListener(name, listener);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbscc.removeNotificationListener(name, listener, filter, handback);
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "removeNotificationListener");
        this.mbscc.removeNotificationListener(name, listener);
    }

    public void setAttribute(ObjectName name, Attribute attribute) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, attribute == null ? null : attribute.getName(), name, "setAttribute");
        this.mbscc.setAttribute(name, attribute);
    }

    public ClusterResult setAttributes(ObjectName name, AttributeList attributes) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "setAttribute");
        return this.mbscc.setAttributes(name, attributes);
    }

    public void unregisterMBean(ObjectName name) throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, name, "unregisterMBean");
        this.mbscc.unregisterMBean(name);
    }

    public ClusterResult getDomains() throws JmxConnectorException {
        this.frame.checkMBeanPermission(null, null, null, "getDomains");
        return this.mbscc.getDomains();
    }
}

