/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.JmxClientFactory;
import com.sap.engine.services.jmx.JmxServiceConnectorClient;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.connector.notification.ListenerID;
import com.sap.engine.services.jmx.connector.notification.ServerSideNotificationListener;
import com.sap.engine.services.jmx.server.SynchronousNotification;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import javax.management.Notification;

public class JmxServiceServerSideListener
implements ServerSideNotificationListener {
    private String clusterID;
    private ListenerID id;
    private transient JmxServiceMessageClient msgClient;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$JmxServiceServerSideListener == null ? (class$com$sap$engine$services$jmx$JmxServiceServerSideListener = JmxServiceServerSideListener.class$("com.sap.engine.services.jmx.JmxServiceServerSideListener")) : class$com$sap$engine$services$jmx$JmxServiceServerSideListener));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$JmxServiceServerSideListener;

    public JmxServiceServerSideListener(String clusterID, ListenerID id) {
        this.clusterID = clusterID;
        this.id = id;
    }

    public void handleNotification(Notification notification, Object handback) {
        this.sendNotification(this.id, notification);
    }

    private JmxServiceMessageClient getMessageClient() throws IOException {
        if (this.msgClient == null) {
            JmxServiceConnectorClient connector = (JmxServiceConnectorClient)JmxClientFactory.getJmxClient().getConnector("service:jmx:com.sap.engine.services.jmx.connector.n2n:" + this.clusterID);
            this.msgClient = connector.getMessageClient();
        }
        return this.msgClient;
    }

    public void sendNotification(ListenerID id, Notification notification) {
        try {
            if (notification instanceof SynchronousNotification) {
                this.getMessageClient().invokeMbs(new RequestMessage(29, new Object[]{id, notification}));
            } else {
                this.getMessageClient().invokeMbsAsync(new RequestMessage(29, new Object[]{id, notification}));
            }
        }
        catch (IOException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"sendNotification(ListenerID, Notification)", (String)("Unable to send " + notification == null ? "" : (notification.getType() + " notification " + notification == null ? null : " from " + notification.getSource() + " to a remote JMX notification listener.")), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

