/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.services.jmx.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class JmxServicePropertyManager {
    private static final String PROP_NAME_DEFAULT_DOMAIN = "DefaultDomain";
    private static final String PROP_VAL_DEFAULT_DOMAIN = "com.sap.default";
    private static final String PROP_NAME_MESSAGE_TIMEOUT = "MessageTimeout";
    private static final String PROP_VAL_MESSAGE_TIMEOUT = "100000";
    private static final String PROP_NAME_NOTIFICATION_QUEUE_MAX_THREADS = "NotificationQueueMaxThreads";
    private static final String PROP_VAL_NOTIFICATION_QUEUE_MAX_THREADS = "3";
    private static final String PROP_NAME_NOTIFICATION_QUEUE_ENQ_TIMEOUT = "NotificationQueueEnqTimeout";
    private static final String PROP_VAL_NOTIFICATION_QUEUE_ENQ_TIMEOUT = "1000";
    private static final String PROP_NAME_NOTIFICATION_QUEUE_THREAD_THRESHOLD = "NotificationQueueThreadThreshold";
    private static final String PROP_VAL_NOTIFICATION_QUEUE_THREAD_THRESHOLD = "30";
    private static final String PROP_NAME_OBJECT_NAME_COMPLETION_CACHE_MIN_SIZE = "ObjectNameCompletionCacheMinSize";
    private static final String PROP_VAL_OBJECT_NAME_COMPLETION_CACHE_MIN_SIZE = "300";
    private static final String PROP_NAME_OBJECT_NAME_COMPLETION_CACHE_MAX_SIZE = "ObjectNameCompletionCacheMaxSize";
    private static final String PROP_VAL_OBJECT_NAME_COMPLETION_CACHE_MAX_SIZE = "1000";
    private final List listeners = new ArrayList();
    private Properties props;
    private String defaultDomain;
    private long messageTimeout;
    private int notificationQueueMaxThreads;
    private long notificationQueueEnqTimeout;
    private int notificationQueueNewThreadThreshold;
    private int objectNameCompletionCacheMinSize;
    private int objectNameCompletionCacheMaxSize;

    JmxServicePropertyManager(Properties props) throws RuntimeException {
        this.init(props);
    }

    private void init(Properties props) {
        this.props = props;
        this.defaultDomain = props.getProperty(PROP_NAME_DEFAULT_DOMAIN, PROP_VAL_DEFAULT_DOMAIN);
        this.messageTimeout = Long.parseLong(props.getProperty(PROP_NAME_MESSAGE_TIMEOUT, PROP_VAL_MESSAGE_TIMEOUT));
        this.notificationQueueMaxThreads = Integer.parseInt(props.getProperty(PROP_NAME_NOTIFICATION_QUEUE_MAX_THREADS, PROP_VAL_NOTIFICATION_QUEUE_MAX_THREADS));
        this.notificationQueueEnqTimeout = Long.parseLong(props.getProperty(PROP_NAME_NOTIFICATION_QUEUE_ENQ_TIMEOUT, "1000"));
        this.notificationQueueNewThreadThreshold = Integer.parseInt(props.getProperty(PROP_NAME_NOTIFICATION_QUEUE_THREAD_THRESHOLD, PROP_VAL_NOTIFICATION_QUEUE_THREAD_THRESHOLD));
        this.objectNameCompletionCacheMinSize = Integer.parseInt(props.getProperty(PROP_NAME_OBJECT_NAME_COMPLETION_CACHE_MIN_SIZE, PROP_VAL_OBJECT_NAME_COMPLETION_CACHE_MIN_SIZE));
        this.objectNameCompletionCacheMaxSize = Integer.parseInt(props.getProperty(PROP_NAME_OBJECT_NAME_COMPLETION_CACHE_MAX_SIZE, "1000"));
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public long getMessageTimeout() {
        return this.messageTimeout;
    }

    public int getNotificationQueueMaxThreads() {
        return this.notificationQueueMaxThreads;
    }

    public long getNotificationQueueEnqTimeout() {
        return this.notificationQueueEnqTimeout;
    }

    public int getNotificationQueueNewThreadThreshold() {
        return this.notificationQueueNewThreadThreshold;
    }

    public int getObjectNameCompletionCacheMinSize() {
        return this.objectNameCompletionCacheMinSize;
    }

    public int getObjectNameCompletionCacheMaxSize() {
        return this.objectNameCompletionCacheMaxSize;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                if (iter.next() != listener) continue;
                iter.remove();
            }
        }
    }

    boolean setServiceProperties(Properties serviceProperties) {
        boolean result = true;
        List list = this.listeners;
        synchronized (list) {
            this.init(serviceProperties);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                PropertyChangeListener listener = (PropertyChangeListener)iter.next();
                if (listener == null || listener.setServiceProperties(serviceProperties)) continue;
                result = false;
            }
        }
        return result;
    }

    boolean setServiceProperty(String key, String value) {
        boolean result = true;
        List list = this.listeners;
        synchronized (list) {
            Properties newProps = this.props;
            newProps.setProperty(key, value);
            this.init(newProps);
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                PropertyChangeListener listener = (PropertyChangeListener)iter.next();
                if (listener == null || listener.setServiceProperty(key, value)) continue;
                result = false;
            }
        }
        return result;
    }
}

