/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.Message;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;

class JmxServiceConnectorServerInvoker
implements JmxServiceMessageClient {
    private final int targetID;
    private final JmxFrame frame;

    public JmxServiceConnectorServerInvoker(int targetID, JmxFrame frame) {
        this.frame = frame;
        this.targetID = targetID;
    }

    public ResponseMessage invokeMbs(RequestMessage request) {
        ResponseMessage response = null;
        try {
            MessageAnswer answer = this.frame.sendAndWaitForAnswer(this.targetID, request.getRequestType(), request.getMsg(), request.getMsgOff(), request.getMsgLen(), this.frame.getPropertyManager().getMessageTimeout());
            response = (ResponseMessage)Message.getMessageFromBytes(answer.getMessage(), answer.getOffset(), answer.getLength());
        }
        catch (JmxConnectorException e) {
            response = new ExceptionMessage((Throwable)((Object)e));
        }
        catch (ClusterException e) {
            response = new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2211", new Object[]{String.valueOf(this.targetID), request == null ? null : request.toString()}, e)));
        }
        catch (RuntimeException e) {
            response = new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2207", e)));
        }
        return response;
    }

    public void invokeMbsAsync(RequestMessage request) throws JmxConnectorException {
        try {
            this.frame.send(this.targetID, request.getRequestType(), request.getMsg(), request.getMsgOff(), request.getMsgLen());
        }
        catch (ClusterException e) {
            throw new JmxConnectorException("jmx_2212", new Object[]{String.valueOf(this.targetID), request == null ? null : request.toString()}, e);
        }
    }
}

