/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmx;

import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.message.PartialResponseException;
import com.sap.engine.lib.logging.LoggingHelper;
import com.sap.engine.services.jmx.ClusterResult;
import com.sap.engine.services.jmx.ExceptionMessage;
import com.sap.engine.services.jmx.JmxFrame;
import com.sap.engine.services.jmx.JmxServiceMessageClient;
import com.sap.engine.services.jmx.Message;
import com.sap.engine.services.jmx.RequestMessage;
import com.sap.engine.services.jmx.ResponseMessage;
import com.sap.engine.services.jmx.exception.JmxConnectorException;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

class JmxServiceConnectorServerClusterInvoker
implements JmxServiceMessageClient {
    private final JmxFrame frame;
    private final int groupID;
    private final byte nodeType;
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$jmx$JmxServiceConnectorServerClusterInvoker == null ? (class$com$sap$engine$services$jmx$JmxServiceConnectorServerClusterInvoker = JmxServiceConnectorServerClusterInvoker.class$("com.sap.engine.services.jmx.JmxServiceConnectorServerClusterInvoker")) : class$com$sap$engine$services$jmx$JmxServiceConnectorServerClusterInvoker));
    static /* synthetic */ Class class$com$sap$engine$services$jmx$JmxServiceConnectorServerClusterInvoker;

    public JmxServiceConnectorServerClusterInvoker(int groupID, byte nodeType, JmxFrame frame) {
        this.groupID = groupID;
        this.nodeType = nodeType;
        this.frame = frame;
    }

    public ResponseMessage invokeMbs(RequestMessage request) {
        MultipleAnswer answer;
        long timeout = this.frame.getPropertyManager().getMessageTimeout();
        try {
            answer = this.frame.sendAndWaitForAnswer(this.groupID, this.nodeType, request.getRequestType(), request.getMsg(), request.getMsgOff(), request.getMsgLen(), timeout);
        }
        catch (PartialResponseException e) {
            LoggingHelper.logThrowable((int)500, (Category)LoggingHelper.SYS_SERVER, (Location)LOCATION, (String)"invokeMbs(RequestMessage)", (String)("Partial response received for a JMX request to all cluster nodes. This means that the request might not be executed in the whole cluster or the client might be in an inconsistent state. Please check the attached request, the response status of the individual nodes. " + request), (Throwable)e);
            answer = e.getPartialResponse();
        }
        catch (ClusterException e) {
            Category.SYS_SERVER.logThrowableT(500, LOCATION, "Cluster exception occurred while processing JMX cluster request " + request, (Throwable)e);
            return new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2208", new Object[]{String.valueOf(this.groupID), String.valueOf(this.nodeType), String.valueOf(timeout), request == null ? null : request.toString()}, e)));
        }
        catch (JmxConnectorException e) {
            Category.SYS_SERVER.logThrowableT(500, LOCATION, "JMX connector exception occurred while processing JMX cluster request " + request, (Throwable)((Object)e));
            return new ExceptionMessage((Throwable)((Object)e));
        }
        ClusterResult results = new ClusterResult();
        int[] participants = answer.participants();
        int i = 0;
        while (i < participants.length) {
            ResponseMessage response;
            try {
                MessageAnswer singleAw = answer.getAnswer(participants[i]);
                response = (ResponseMessage)Message.getMessageFromBytes(singleAw.getMessage(), singleAw.getOffset(), singleAw.getLength());
            }
            catch (ClusterException e) {
                Category.SYS_SERVER.logThrowableT(500, LOCATION, "Cluster exception occurred while processing JMX cluster request " + request, (Throwable)e);
                response = new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2209", new Object[]{String.valueOf(participants[i]), String.valueOf(timeout), request == null ? null : request.toString()}, e)));
            }
            catch (JmxConnectorException e) {
                Category.SYS_SERVER.logThrowableT(500, LOCATION, "JMX connector exception occurred while processing JMX cluster request " + request, (Throwable)((Object)e));
                response = new ExceptionMessage((Throwable)((Object)e));
            }
            catch (RuntimeException e) {
                Category.SYS_SERVER.logThrowableT(500, LOCATION, "Runtime exception occurred while processing JMX cluster request " + request, (Throwable)e);
                response = new ExceptionMessage((Throwable)((Object)new JmxConnectorException("jmx_2207", e)));
            }
            results.setResult(String.valueOf(participants[i]), response);
            ++i;
        }
        return new ResponseMessage(results, request.getSourceType());
    }

    public void invokeMbsAsync(RequestMessage request) throws JmxConnectorException {
        try {
            this.frame.send(this.groupID, this.nodeType, request.getRequestType(), request.getMsg(), request.getMsgOff(), request.getMsgLen());
        }
        catch (ClusterException e) {
            throw new JmxConnectorException("jmx_2210", new Object[]{String.valueOf(this.groupID), String.valueOf(this.nodeType), request == null ? null : request.toString()}, e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

